/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolverImpl;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragmentImpl$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragmentImpl$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoBasedClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;

public abstract class DeserializedPackageFragmentImpl
extends DeserializedPackageFragment {
    private final BinaryVersion metadataVersion;
    private final DeserializedContainerSource containerSource;
    private final NameResolverImpl nameResolver;
    private final ProtoBasedClassDataFinder classDataFinder;
    private ProtoBuf.PackageFragment _proto;
    private MemberScope _memberScope;

    public DeserializedPackageFragmentImpl(FqName fqName, StorageManager storageManager, ModuleDescriptor moduleDescriptor, ProtoBuf.PackageFragment packageFragment, BinaryVersion binaryVersion, DeserializedContainerSource deserializedContainerSource) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)packageFragment, (String)"");
        Intrinsics.checkNotNullParameter((Object)binaryVersion, (String)"");
        super(fqName, storageManager, moduleDescriptor);
        this.metadataVersion = binaryVersion;
        this.containerSource = deserializedContainerSource;
        ProtoBuf.StringTable stringTable = packageFragment.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = packageFragment.getQualifiedNames();
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"");
        this.nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
        DeserializedPackageFragmentImpl deserializedPackageFragmentImpl = this;
        this.classDataFinder = new ProtoBasedClassDataFinder(packageFragment, this.nameResolver, this.metadataVersion, new DeserializedPackageFragmentImpl$$Lambda$0(deserializedPackageFragmentImpl));
        this._proto = packageFragment;
    }

    @Override
    public ProtoBasedClassDataFinder getClassDataFinder() {
        return this.classDataFinder;
    }

    @Override
    public void initialize(DeserializationComponents deserializationComponents) {
        Intrinsics.checkNotNullParameter((Object)deserializationComponents, (String)"");
        ProtoBuf.PackageFragment packageFragment = this._proto;
        if (packageFragment == null) {
            throw new IllegalStateException("Repeated call to DeserializedPackageFragmentImpl::initialize".toString());
        }
        ProtoBuf.PackageFragment packageFragment2 = packageFragment;
        this._proto = null;
        PackageFragmentDescriptor packageFragmentDescriptor = this;
        ProtoBuf.Package package_ = packageFragment2.getPackage();
        Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"");
        DeserializedPackageFragmentImpl deserializedPackageFragmentImpl = this;
        this._memberScope = new DeserializedPackageMemberScope(packageFragmentDescriptor, package_, this.nameResolver, this.metadataVersion, this.containerSource, deserializationComponents, "scope of " + this, new DeserializedPackageFragmentImpl$$Lambda$1(deserializedPackageFragmentImpl));
    }

    @Override
    public MemberScope getMemberScope() {
        MemberScope memberScope = this._memberScope;
        if (memberScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            memberScope = null;
        }
        return memberScope;
    }

    private static final SourceElement classDataFinder$lambda$0(DeserializedPackageFragmentImpl deserializedPackageFragmentImpl, ClassId classId) {
        SourceElement sourceElement;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        DeserializedContainerSource deserializedContainerSource = deserializedPackageFragmentImpl.containerSource;
        if (deserializedContainerSource != null) {
            sourceElement = deserializedContainerSource;
        } else {
            SourceElement sourceElement2 = SourceElement.NO_SOURCE;
            sourceElement = sourceElement2;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement2, (String)"");
        }
        return sourceElement;
    }

    private static final Collection initialize$lambda$3(DeserializedPackageFragmentImpl deserializedPackageFragmentImpl) {
        boolean bl;
        ClassId classId;
        Iterable iterable = deserializedPackageFragmentImpl.getClassDataFinder().getAllClassIds();
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t : iterable2) {
            classId = (ClassId)t;
            bl = false;
            if (!(!classId.isNestedClass() && !ClassDeserializer.Companion.getBLACK_LIST().contains(classId))) continue;
            collection.add(t);
        }
        iterable = (List)collection;
        bl2 = false;
        iterable2 = iterable;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        bl3 = false;
        for (Object t : iterable2) {
            classId = (ClassId)t;
            Collection collection2 = collection;
            bl = false;
            collection2.add(classId.getShortClassName());
        }
        return (List)collection;
    }

    static /* synthetic */ SourceElement accessor$DeserializedPackageFragmentImpl$lambda0(DeserializedPackageFragmentImpl deserializedPackageFragmentImpl, ClassId classId) {
        return DeserializedPackageFragmentImpl.classDataFinder$lambda$0(deserializedPackageFragmentImpl, classId);
    }

    static /* synthetic */ Collection accessor$DeserializedPackageFragmentImpl$lambda1(DeserializedPackageFragmentImpl deserializedPackageFragmentImpl) {
        return DeserializedPackageFragmentImpl.initialize$lambda$3(deserializedPackageFragmentImpl);
    }
}

