/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;

public abstract class ProtoContainer {
    private final NameResolver nameResolver;
    private final TypeTable typeTable;
    private final SourceElement source;

    private ProtoContainer(NameResolver nameResolver, TypeTable typeTable, SourceElement sourceElement) {
        this.nameResolver = nameResolver;
        this.typeTable = typeTable;
        this.source = sourceElement;
    }

    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    public final SourceElement getSource() {
        return this.source;
    }

    public abstract FqName debugFqName();

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.debugFqName();
    }

    public /* synthetic */ ProtoContainer(NameResolver nameResolver, TypeTable typeTable, SourceElement sourceElement, DefaultConstructorMarker defaultConstructorMarker) {
        this(nameResolver, typeTable, sourceElement);
    }

    public static final class Class
    extends ProtoContainer {
        private final ProtoBuf.Class classProto;
        private final Class outerClass;
        private final ClassId classId;
        private final ProtoBuf.Class.Kind kind;
        private final boolean isInner;
        private final boolean isData;

        public Class(ProtoBuf.Class clazz, NameResolver nameResolver, TypeTable typeTable, SourceElement sourceElement, Class clazz2) {
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"");
            Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
            Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
            super(nameResolver, typeTable, sourceElement, null);
            this.classProto = clazz;
            this.outerClass = clazz2;
            this.classId = NameResolverUtilKt.getClassId(nameResolver, this.classProto.getFqName());
            ProtoBuf.Class.Kind kind = Flags.CLASS_KIND.get(this.classProto.getFlags());
            if (kind == null) {
                kind = ProtoBuf.Class.Kind.CLASS;
            }
            this.kind = kind;
            Boolean bl = Flags.IS_INNER.get(this.classProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"");
            this.isInner = bl;
            Boolean bl2 = Flags.IS_DATA.get(this.classProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"");
            this.isData = bl2;
        }

        public final ProtoBuf.Class getClassProto() {
            return this.classProto;
        }

        public final Class getOuterClass() {
            return this.outerClass;
        }

        public final ClassId getClassId() {
            return this.classId;
        }

        public final ProtoBuf.Class.Kind getKind() {
            return this.kind;
        }

        public final boolean isInner() {
            return this.isInner;
        }

        @Override
        public FqName debugFqName() {
            return this.classId.asSingleFqName();
        }
    }

    public static final class Package
    extends ProtoContainer {
        private final FqName fqName;

        public Package(FqName fqName, NameResolver nameResolver, TypeTable typeTable, SourceElement sourceElement) {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
            Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
            Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
            super(nameResolver, typeTable, sourceElement, null);
            this.fqName = fqName;
        }

        @Override
        public FqName debugFqName() {
            return this.fqName;
        }
    }
}

