/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.DelegatingSimpleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;

public final class SimpleTypeWithEnhancement
extends DelegatingSimpleType
implements TypeWithEnhancement {
    private final SimpleType delegate;
    private final KotlinType enhancement;

    public SimpleTypeWithEnhancement(SimpleType simpleType, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)simpleType, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        this.delegate = simpleType;
        this.enhancement = kotlinType;
    }

    @Override
    protected SimpleType getDelegate() {
        return this.delegate;
    }

    @Override
    public KotlinType getEnhancement() {
        return this.enhancement;
    }

    @Override
    public SimpleType getOrigin() {
        return this.getDelegate();
    }

    @Override
    public SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        UnwrappedType unwrappedType = TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().replaceAttributes(typeAttributes), this.getEnhancement());
        Intrinsics.checkNotNull((Object)unwrappedType);
        return (SimpleType)unwrappedType;
    }

    @Override
    public SimpleType makeNullableAsSpecified(boolean bl) {
        UnwrappedType unwrappedType = TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().makeNullableAsSpecified(bl), this.getEnhancement().unwrap().makeNullableAsSpecified(bl));
        Intrinsics.checkNotNull((Object)unwrappedType);
        return (SimpleType)unwrappedType;
    }

    @Override
    public SimpleTypeWithEnhancement replaceDelegate(SimpleType simpleType) {
        Intrinsics.checkNotNullParameter((Object)simpleType, (String)"");
        return new SimpleTypeWithEnhancement(simpleType, this.getEnhancement());
    }

    @Override
    public SimpleTypeWithEnhancement refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        KotlinType kotlinType = kotlinTypeRefiner.refineType(this.getDelegate());
        Intrinsics.checkNotNull((Object)kotlinType);
        return new SimpleTypeWithEnhancement((SimpleType)kotlinType, kotlinTypeRefiner.refineType(this.getEnhancement()));
    }

    @Override
    public String toString() {
        return "[@EnhancedForWarnings(" + this.getEnhancement() + ")] " + this.getOrigin();
    }
}

