/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.FilteredAnnotations;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.types.CustomTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.DisjointKeysUnionTypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.IndexedParametersSubstitution;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.RawType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilitiesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt;
import kotlin.reflect.jvm.internal.impl.utils.ExceptionUtilsKt;

public class TypeSubstitutor {
    public static final TypeSubstitutor EMPTY = TypeSubstitutor.create(TypeSubstitution.EMPTY);
    private final TypeSubstitution substitution;

    public static TypeSubstitutor create(TypeSubstitution typeSubstitution) {
        if (typeSubstitution == null) {
            TypeSubstitutor.$$$reportNull$$$0(0);
        }
        return new TypeSubstitutor(typeSubstitution);
    }

    public TypeSubstitutor replaceWithNonApproximatingSubstitution() {
        if (!(this.substitution instanceof IndexedParametersSubstitution) || !this.substitution.approximateContravariantCapturedTypes()) {
            TypeSubstitutor typeSubstitutor2 = this;
            if (typeSubstitutor2 == null) {
                TypeSubstitutor.$$$reportNull$$$0(1);
            }
            return typeSubstitutor2;
        }
        return new TypeSubstitutor(new IndexedParametersSubstitution(((IndexedParametersSubstitution)this.substitution).getParameters(), ((IndexedParametersSubstitution)this.substitution).getArguments(), false));
    }

    public static TypeSubstitutor createChainedSubstitutor(TypeSubstitution typeSubstitution, TypeSubstitution typeSubstitution2) {
        if (typeSubstitution == null) {
            TypeSubstitutor.$$$reportNull$$$0(3);
        }
        if (typeSubstitution2 == null) {
            TypeSubstitutor.$$$reportNull$$$0(4);
        }
        return TypeSubstitutor.create(DisjointKeysUnionTypeSubstitution.create(typeSubstitution, typeSubstitution2));
    }

    public static TypeSubstitutor create(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeSubstitutor.$$$reportNull$$$0(6);
        }
        return TypeSubstitutor.create(TypeConstructorSubstitution.create(kotlinType.getConstructor(), kotlinType.getArguments()));
    }

    protected TypeSubstitutor(TypeSubstitution typeSubstitution) {
        if (typeSubstitution == null) {
            TypeSubstitutor.$$$reportNull$$$0(7);
        }
        this.substitution = typeSubstitution;
    }

    public boolean isEmpty() {
        return this.substitution.isEmpty();
    }

    public TypeSubstitution getSubstitution() {
        TypeSubstitution typeSubstitution = this.substitution;
        if (typeSubstitution == null) {
            TypeSubstitutor.$$$reportNull$$$0(8);
        }
        return typeSubstitution;
    }

    public KotlinType safeSubstitute(KotlinType kotlinType, Variance variance) {
        KotlinType kotlinType2;
        if (kotlinType == null) {
            TypeSubstitutor.$$$reportNull$$$0(9);
        }
        if (variance == null) {
            TypeSubstitutor.$$$reportNull$$$0(10);
        }
        if (this.isEmpty()) {
            KotlinType kotlinType3 = kotlinType;
            if (kotlinType3 == null) {
                TypeSubstitutor.$$$reportNull$$$0(11);
            }
            return kotlinType3;
        }
        try {
            kotlinType2 = this.unsafeSubstitute(new TypeProjectionImpl(variance, kotlinType), null, 0).getType();
        }
        catch (SubstitutionException substitutionException) {
            ErrorType errorType = ErrorUtils.createErrorType(ErrorTypeKind.UNABLE_TO_SUBSTITUTE_TYPE, substitutionException.getMessage());
            if (errorType == null) {
                TypeSubstitutor.$$$reportNull$$$0(13);
            }
            return errorType;
        }
        if (kotlinType2 == null) {
            TypeSubstitutor.$$$reportNull$$$0(12);
        }
        return kotlinType2;
    }

    public KotlinType substitute(KotlinType kotlinType, Variance variance) {
        TypeProjection typeProjection;
        if (kotlinType == null) {
            TypeSubstitutor.$$$reportNull$$$0(14);
        }
        if (variance == null) {
            TypeSubstitutor.$$$reportNull$$$0(15);
        }
        return (typeProjection = this.substitute(new TypeProjectionImpl(variance, this.getSubstitution().prepareTopLevelType(kotlinType, variance)))) == null ? null : typeProjection.getType();
    }

    public TypeProjection substitute(TypeProjection typeProjection) {
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(16);
        }
        TypeProjection typeProjection2 = this.substituteWithoutApproximation(typeProjection);
        if (!this.substitution.approximateCapturedTypes() && !this.substitution.approximateContravariantCapturedTypes()) {
            return typeProjection2;
        }
        return CapturedTypeApproximationKt.approximateCapturedTypesIfNecessary(typeProjection2, this.substitution.approximateContravariantCapturedTypes());
    }

    public TypeProjection substituteWithoutApproximation(TypeProjection typeProjection) {
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(17);
        }
        if (this.isEmpty()) {
            return typeProjection;
        }
        try {
            return this.unsafeSubstitute(typeProjection, null, 0);
        }
        catch (SubstitutionException substitutionException) {
            return null;
        }
    }

    private TypeProjection unsafeSubstitute(TypeProjection typeProjection, TypeParameterDescriptor typeParameterDescriptor, int n) {
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(18);
        }
        TypeSubstitutor.assertRecursionDepth(n, typeProjection, this.substitution);
        if (typeProjection.isStarProjection()) {
            TypeProjection typeProjection2 = typeProjection;
            if (typeProjection2 == null) {
                TypeSubstitutor.$$$reportNull$$$0(19);
            }
            return typeProjection2;
        }
        KotlinType kotlinType = typeProjection.getType();
        if (kotlinType instanceof TypeWithEnhancement) {
            UnwrappedType unwrappedType = ((TypeWithEnhancement)((Object)kotlinType)).getOrigin();
            KotlinType kotlinType2 = ((TypeWithEnhancement)((Object)kotlinType)).getEnhancement();
            TypeProjection typeProjection3 = this.unsafeSubstitute(new TypeProjectionImpl(typeProjection.getProjectionKind(), unwrappedType), typeParameterDescriptor, n + 1);
            if (typeProjection3.isStarProjection()) {
                TypeProjection typeProjection4 = typeProjection3;
                if (typeProjection4 == null) {
                    TypeSubstitutor.$$$reportNull$$$0(20);
                }
                return typeProjection4;
            }
            KotlinType kotlinType3 = this.substitute(kotlinType2, typeProjection.getProjectionKind());
            UnwrappedType unwrappedType2 = TypeWithEnhancementKt.wrapEnhancement(typeProjection3.getType().unwrap(), kotlinType3);
            return new TypeProjectionImpl(typeProjection3.getProjectionKind(), unwrappedType2);
        }
        if (DynamicTypesKt.isDynamic(kotlinType) || kotlinType.unwrap() instanceof RawType) {
            TypeProjection typeProjection5 = typeProjection;
            if (typeProjection5 == null) {
                TypeSubstitutor.$$$reportNull$$$0(21);
            }
            return typeProjection5;
        }
        TypeProjection typeProjection6 = this.substitution.get(kotlinType);
        TypeProjection typeProjection7 = typeProjection6 != null ? TypeSubstitutor.projectedTypeForConflictedTypeWithUnsafeVariance(kotlinType, typeProjection6, typeParameterDescriptor, typeProjection) : null;
        Variance variance = typeProjection.getProjectionKind();
        if (typeProjection7 == null && FlexibleTypesKt.isFlexible(kotlinType) && !TypeCapabilitiesKt.isCustomTypeParameter(kotlinType)) {
            FlexibleType flexibleType = FlexibleTypesKt.asFlexibleType(kotlinType);
            TypeProjection typeProjection8 = this.unsafeSubstitute(new TypeProjectionImpl(variance, flexibleType.getLowerBound()), typeParameterDescriptor, n + 1);
            TypeProjection typeProjection9 = this.unsafeSubstitute(new TypeProjectionImpl(variance, flexibleType.getUpperBound()), typeParameterDescriptor, n + 1);
            Variance variance2 = typeProjection8.getProjectionKind();
            assert (variance2 == typeProjection9.getProjectionKind() && variance == Variance.INVARIANT || variance == variance2) : "Unexpected substituted projection kind: " + (Object)((Object)variance2) + "; original: " + (Object)((Object)variance);
            if (typeProjection8.getType() == flexibleType.getLowerBound() && typeProjection9.getType() == flexibleType.getUpperBound()) {
                TypeProjection typeProjection10 = typeProjection;
                if (typeProjection10 == null) {
                    TypeSubstitutor.$$$reportNull$$$0(22);
                }
                return typeProjection10;
            }
            UnwrappedType unwrappedType = KotlinTypeFactory.flexibleType(TypeSubstitutionKt.asSimpleType(typeProjection8.getType()), TypeSubstitutionKt.asSimpleType(typeProjection9.getType()));
            return new TypeProjectionImpl(variance2, unwrappedType);
        }
        if (KotlinBuiltIns.isNothing(kotlinType) || KotlinTypeKt.isError(kotlinType)) {
            TypeProjection typeProjection11 = typeProjection;
            if (typeProjection11 == null) {
                TypeSubstitutor.$$$reportNull$$$0(23);
            }
            return typeProjection11;
        }
        if (typeProjection7 != null) {
            Object object;
            VarianceConflictType varianceConflictType = TypeSubstitutor.conflictType(variance, typeProjection7.getProjectionKind());
            boolean bl = CapturedTypeConstructorKt.isCaptured(kotlinType);
            if (!bl) {
                switch (varianceConflictType) {
                    case OUT_IN_IN_POSITION: {
                        throw new SubstitutionException("Out-projection in in-position");
                    }
                    case IN_IN_OUT_POSITION: {
                        return new TypeProjectionImpl(Variance.OUT_VARIANCE, kotlinType.getConstructor().getBuiltIns().getNullableAnyType());
                    }
                }
            }
            CustomTypeParameter customTypeParameter = TypeCapabilitiesKt.getCustomTypeParameter(kotlinType);
            if (typeProjection7.isStarProjection()) {
                TypeProjection typeProjection12 = typeProjection7;
                if (typeProjection12 == null) {
                    TypeSubstitutor.$$$reportNull$$$0(24);
                }
                return typeProjection12;
            }
            KotlinType kotlinType4 = customTypeParameter != null ? customTypeParameter.substitutionResult(typeProjection7.getType()) : TypeUtils.makeNullableIfNeeded(typeProjection7.getType(), kotlinType.isMarkedNullable());
            if (!kotlinType.getAnnotations().isEmpty()) {
                object = TypeSubstitutor.filterOutUnsafeVariance(this.substitution.filterAnnotations(kotlinType.getAnnotations()));
                kotlinType4 = TypeUtilsKt.replaceAnnotations(kotlinType4, new CompositeAnnotations(new Annotations[]{kotlinType4.getAnnotations(), object}));
            }
            object = varianceConflictType == VarianceConflictType.NO_CONFLICT ? TypeSubstitutor.combine(variance, typeProjection7.getProjectionKind()) : variance;
            return new TypeProjectionImpl((Variance)((Object)object), kotlinType4);
        }
        TypeProjection typeProjection13 = this.substituteCompoundType(typeProjection, n);
        if (typeProjection13 == null) {
            TypeSubstitutor.$$$reportNull$$$0(25);
        }
        return typeProjection13;
    }

    private static TypeProjection projectedTypeForConflictedTypeWithUnsafeVariance(KotlinType kotlinType, TypeProjection typeProjection, TypeParameterDescriptor typeParameterDescriptor, TypeProjection typeProjection2) {
        if (kotlinType == null) {
            TypeSubstitutor.$$$reportNull$$$0(26);
        }
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(27);
        }
        if (typeProjection2 == null) {
            TypeSubstitutor.$$$reportNull$$$0(28);
        }
        if (!kotlinType.getAnnotations().hasAnnotation(StandardNames.FqNames.unsafeVariance)) {
            TypeProjection typeProjection3 = typeProjection;
            if (typeProjection3 == null) {
                TypeSubstitutor.$$$reportNull$$$0(29);
            }
            return typeProjection3;
        }
        TypeConstructor typeConstructor2 = typeProjection.getType().getConstructor();
        if (!(typeConstructor2 instanceof NewCapturedTypeConstructor)) {
            TypeProjection typeProjection4 = typeProjection;
            if (typeProjection4 == null) {
                TypeSubstitutor.$$$reportNull$$$0(30);
            }
            return typeProjection4;
        }
        NewCapturedTypeConstructor newCapturedTypeConstructor = (NewCapturedTypeConstructor)typeConstructor2;
        TypeProjection typeProjection5 = newCapturedTypeConstructor.getProjection();
        Variance variance = typeProjection5.getProjectionKind();
        VarianceConflictType varianceConflictType = TypeSubstitutor.conflictType(typeProjection2.getProjectionKind(), variance);
        if (varianceConflictType == VarianceConflictType.OUT_IN_IN_POSITION) {
            return new TypeProjectionImpl(typeProjection5.getType());
        }
        if (typeParameterDescriptor == null) {
            TypeProjection typeProjection6 = typeProjection;
            if (typeProjection6 == null) {
                TypeSubstitutor.$$$reportNull$$$0(31);
            }
            return typeProjection6;
        }
        VarianceConflictType varianceConflictType2 = TypeSubstitutor.conflictType(typeParameterDescriptor.getVariance(), variance);
        if (varianceConflictType2 == VarianceConflictType.OUT_IN_IN_POSITION) {
            return new TypeProjectionImpl(typeProjection5.getType());
        }
        TypeProjection typeProjection7 = typeProjection;
        if (typeProjection7 == null) {
            TypeSubstitutor.$$$reportNull$$$0(32);
        }
        return typeProjection7;
    }

    private static Annotations filterOutUnsafeVariance(Annotations annotations) {
        if (annotations == null) {
            TypeSubstitutor.$$$reportNull$$$0(33);
        }
        if (!annotations.hasAnnotation(StandardNames.FqNames.unsafeVariance)) {
            Annotations annotations2 = annotations;
            if (annotations2 == null) {
                TypeSubstitutor.$$$reportNull$$$0(34);
            }
            return annotations2;
        }
        return new FilteredAnnotations(annotations, (Function1<? super FqName, Boolean>)new Function1<FqName, Boolean>(){

            public Boolean invoke(FqName fqName) {
                if (fqName == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !fqName.equals(StandardNames.FqNames.unsafeVariance);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor$1", "invoke"));
            }
        });
    }

    private TypeProjection substituteCompoundType(TypeProjection typeProjection, int n) {
        KotlinType kotlinType;
        Object object;
        KotlinType kotlinType2 = typeProjection.getType();
        Variance variance = typeProjection.getProjectionKind();
        if (kotlinType2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return typeProjection;
        }
        KotlinType kotlinType3 = null;
        SimpleType simpleType = SpecialTypesKt.getAbbreviation(kotlinType2);
        if (simpleType != null) {
            object = this.replaceWithNonApproximatingSubstitution();
            kotlinType3 = ((TypeSubstitutor)object).substitute(simpleType, Variance.INVARIANT);
        }
        if ((kotlinType = TypeSubstitutionKt.replace(kotlinType2, (List<? extends TypeProjection>)(object = this.substituteTypeArguments(kotlinType2.getConstructor().getParameters(), kotlinType2.getArguments(), n)), this.substitution.filterAnnotations(kotlinType2.getAnnotations()))) instanceof SimpleType && kotlinType3 instanceof SimpleType) {
            kotlinType = SpecialTypesKt.withAbbreviation((SimpleType)kotlinType, (SimpleType)kotlinType3);
        }
        return new TypeProjectionImpl(variance, kotlinType);
    }

    private List<TypeProjection> substituteTypeArguments(List<TypeParameterDescriptor> list, List<TypeProjection> list2, int n) {
        ArrayList<TypeProjection> arrayList = new ArrayList<TypeProjection>(list.size());
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            TypeParameterDescriptor typeParameterDescriptor = list.get(i);
            TypeProjection typeProjection = list2.get(i);
            TypeProjection typeProjection2 = this.unsafeSubstitute(typeProjection, typeParameterDescriptor, n + 1);
            switch (TypeSubstitutor.conflictType(typeParameterDescriptor.getVariance(), typeProjection2.getProjectionKind())) {
                case NO_CONFLICT: {
                    if (typeParameterDescriptor.getVariance() == Variance.INVARIANT || typeProjection2.isStarProjection()) break;
                    typeProjection2 = new TypeProjectionImpl(Variance.INVARIANT, typeProjection2.getType());
                    break;
                }
                case OUT_IN_IN_POSITION: 
                case IN_IN_OUT_POSITION: {
                    typeProjection2 = TypeUtils.makeStarProjection(typeParameterDescriptor);
                }
            }
            if (typeProjection2 != typeProjection) {
                bl = true;
            }
            arrayList.add(typeProjection2);
        }
        if (!bl) {
            return list2;
        }
        return arrayList;
    }

    public static Variance combine(Variance variance, TypeProjection typeProjection) {
        if (variance == null) {
            TypeSubstitutor.$$$reportNull$$$0(35);
        }
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(36);
        }
        if (typeProjection.isStarProjection()) {
            Variance variance2 = Variance.OUT_VARIANCE;
            if (variance2 == null) {
                TypeSubstitutor.$$$reportNull$$$0(37);
            }
            return variance2;
        }
        return TypeSubstitutor.combine(variance, typeProjection.getProjectionKind());
    }

    public static Variance combine(Variance variance, Variance variance2) {
        if (variance == null) {
            TypeSubstitutor.$$$reportNull$$$0(38);
        }
        if (variance2 == null) {
            TypeSubstitutor.$$$reportNull$$$0(39);
        }
        if (variance == Variance.INVARIANT) {
            Variance variance3 = variance2;
            if (variance3 == null) {
                TypeSubstitutor.$$$reportNull$$$0(40);
            }
            return variance3;
        }
        if (variance2 == Variance.INVARIANT) {
            Variance variance4 = variance;
            if (variance4 == null) {
                TypeSubstitutor.$$$reportNull$$$0(41);
            }
            return variance4;
        }
        if (variance == variance2) {
            Variance variance5 = variance2;
            if (variance5 == null) {
                TypeSubstitutor.$$$reportNull$$$0(42);
            }
            return variance5;
        }
        throw new AssertionError((Object)("Variance conflict: type parameter variance '" + (Object)((Object)variance) + "' and projection kind '" + (Object)((Object)variance2) + "' cannot be combined"));
    }

    private static VarianceConflictType conflictType(Variance variance, Variance variance2) {
        if (variance == Variance.IN_VARIANCE && variance2 == Variance.OUT_VARIANCE) {
            return VarianceConflictType.OUT_IN_IN_POSITION;
        }
        if (variance == Variance.OUT_VARIANCE && variance2 == Variance.IN_VARIANCE) {
            return VarianceConflictType.IN_IN_OUT_POSITION;
        }
        return VarianceConflictType.NO_CONFLICT;
    }

    private static void assertRecursionDepth(int n, TypeProjection typeProjection, TypeSubstitution typeSubstitution) {
        if (n > 100) {
            throw new IllegalStateException("Recursion too deep. Most likely infinite loop while substituting " + TypeSubstitutor.safeToString(typeProjection) + "; substitution: " + TypeSubstitutor.safeToString(typeSubstitution));
        }
    }

    private static String safeToString(Object object) {
        try {
            return object.toString();
        }
        catch (Throwable throwable) {
            if (ExceptionUtilsKt.isProcessCanceledException(throwable)) {
                throw (RuntimeException)throwable;
            }
            return "[Exception while computing toString(): " + throwable + "]";
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutionContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "howThisTypeIsUsed";
                break;
            }
            case 16: 
            case 17: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProjection";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalProjection";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substituted";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterVariance";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectionKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithNonApproximatingSubstitution";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithContravariantApproximatingSubstitution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "safeSubstitute";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unsafeSubstitute";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "projectedTypeForConflictedTypeWithUnsafeVariance";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutUnsafeVariance";
                break;
            }
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "combine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createChainedSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "safeSubstitute";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "substituteWithoutApproximation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unsafeSubstitute";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "projectedTypeForConflictedTypeWithUnsafeVariance";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "filterOutUnsafeVariance";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum VarianceConflictType {
        NO_CONFLICT,
        IN_IN_OUT_POSITION,
        OUT_IN_IN_POSITION;

    }

    private static final class SubstitutionException
    extends Exception {
        public SubstitutionException(String string) {
            super(string);
        }
    }
}

