/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SubtypePathNode;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckingProcedureCallbacks;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt;

public final class UtilsKt {
    public static final KotlinType findCorrespondingSupertype(KotlinType kotlinType, KotlinType kotlinType2, TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType2, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeCheckingProcedureCallbacks, (String)"");
        ArrayDeque<SubtypePathNode> arrayDeque = new ArrayDeque<SubtypePathNode>();
        arrayDeque.add(new SubtypePathNode(kotlinType, null));
        TypeConstructor typeConstructor2 = kotlinType2.getConstructor();
        while (!arrayDeque.isEmpty()) {
            SubtypePathNode subtypePathNode = (SubtypePathNode)arrayDeque.poll();
            KotlinType kotlinType3 = subtypePathNode.getType();
            TypeConstructor typeConstructor3 = kotlinType3.getConstructor();
            if (typeCheckingProcedureCallbacks.assertEqualTypeConstructors(typeConstructor3, typeConstructor2)) {
                Object object;
                Object object2 = kotlinType3;
                boolean bl = kotlinType3.isMarkedNullable();
                for (SubtypePathNode subtypePathNode2 = subtypePathNode.getPrevious(); subtypePathNode2 != null; subtypePathNode2 = subtypePathNode2.getPrevious()) {
                    Object object3;
                    boolean bl2;
                    Object object4;
                    block10: {
                        object = subtypePathNode2.getType();
                        object4 = ((KotlinType)object).getArguments();
                        boolean bl3 = false;
                        if (object4 instanceof Collection && ((Collection)object4).isEmpty()) {
                            bl2 = false;
                        } else {
                            Iterator iterator2 = object4.iterator();
                            while (iterator2.hasNext()) {
                                Object t = iterator2.next();
                                TypeProjection typeProjection = (TypeProjection)t;
                                boolean bl4 = false;
                                if (!(typeProjection.getProjectionKind() != Variance.INVARIANT)) continue;
                                bl2 = true;
                                break block10;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        KotlinType kotlinType4 = CapturedTypeConstructorKt.wrapWithCapturingSubstitution$default(TypeConstructorSubstitution.Companion.create((KotlinType)object), false, 1, null).buildSubstitutor().safeSubstitute((KotlinType)object2, Variance.INVARIANT);
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"");
                        object3 = UtilsKt.approximate(kotlinType4);
                    } else {
                        object4 = TypeConstructorSubstitution.Companion.create((KotlinType)object).buildSubstitutor().safeSubstitute((KotlinType)object2, Variance.INVARIANT);
                        Intrinsics.checkNotNull((Object)object4);
                        object3 = object4;
                    }
                    object2 = object3;
                    bl = bl || ((KotlinType)object).isMarkedNullable();
                }
                object = ((KotlinType)object2).getConstructor();
                if (!typeCheckingProcedureCallbacks.assertEqualTypeConstructors((TypeConstructor)object, typeConstructor2)) {
                    throw new AssertionError((Object)("Type constructors should be equals!\nsubstitutedSuperType: " + UtilsKt.debugInfo((TypeConstructor)object) + ", \n\nsupertype: " + UtilsKt.debugInfo(typeConstructor2) + " \n" + typeCheckingProcedureCallbacks.assertEqualTypeConstructors((TypeConstructor)object, typeConstructor2)));
                }
                return TypeUtils.makeNullableAsSpecified((KotlinType)object2, bl);
            }
            for (KotlinType kotlinType5 : typeConstructor3.getSupertypes()) {
                Intrinsics.checkNotNull((Object)kotlinType5);
                arrayDeque.add(new SubtypePathNode(kotlinType5, subtypePathNode));
            }
        }
        return null;
    }

    private static final KotlinType approximate(KotlinType kotlinType) {
        return CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType).getUpper();
    }

    private static final String debugInfo(TypeConstructor typeConstructor2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        UtilsKt.debugInfo$lambda$1$unaryPlus("type: " + typeConstructor2, stringBuilder2);
        UtilsKt.debugInfo$lambda$1$unaryPlus("hashCode: " + typeConstructor2.hashCode(), stringBuilder2);
        UtilsKt.debugInfo$lambda$1$unaryPlus("javaClass: " + typeConstructor2.getClass().getCanonicalName(), stringBuilder2);
        for (DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)typeConstructor2.getDeclarationDescriptor(); declarationDescriptor != null; declarationDescriptor = declarationDescriptor.getContainingDeclaration()) {
            UtilsKt.debugInfo$lambda$1$unaryPlus("fqName: " + DescriptorRenderer.FQ_NAMES_IN_TYPES.render(declarationDescriptor), stringBuilder2);
            UtilsKt.debugInfo$lambda$1$unaryPlus("javaClass: " + declarationDescriptor.getClass().getCanonicalName(), stringBuilder2);
        }
        return stringBuilder.toString();
    }

    private static final StringBuilder debugInfo$lambda$1$unaryPlus(String string, StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return stringBuilder.append(string).append('\n');
    }
}

