/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.DefaultBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public final class ErrorTypeConstructor
implements TypeConstructor {
    private final ErrorTypeKind kind;
    private final String[] formatParams;
    private final String debugText;

    public ErrorTypeConstructor(ErrorTypeKind errorTypeKind, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        this.kind = errorTypeKind;
        this.formatParams = stringArray;
        String string = ErrorEntity.ERROR_TYPE.getDebugText();
        Object[] objectArray = new Object[1];
        String string2 = this.kind.getDebugMessage();
        String[] stringArray2 = this.formatParams;
        stringArray2 = Arrays.copyOf(stringArray2, stringArray2.length);
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(stringArray2, stringArray2.length)), (String)"");
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        this.debugText = string3;
    }

    public final ErrorTypeKind getKind() {
        return this.kind;
    }

    public final String getParam(int n) {
        return this.formatParams[n];
    }

    @Override
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public Collection<KotlinType> getSupertypes() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    public ClassifierDescriptor getDeclarationDescriptor() {
        return ErrorUtils.INSTANCE.getErrorClass();
    }

    @Override
    public KotlinBuiltIns getBuiltIns() {
        return DefaultBuiltIns.Companion.getInstance();
    }

    public String toString() {
        return this.debugText;
    }

    @Override
    public TypeConstructor refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        return this;
    }
}

