/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.e.a.a;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.roster.AbstractRosterListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.SubscribeListener;

public class RosterUtil {
    public static void waitUntilOtherEntityIsSubscribed(Roster roster, a a2, long l) {
        Date date = new Date(System.currentTimeMillis() + l);
        RosterUtil.waitUntilOtherEntityIsSubscribed(roster, a2, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitUntilOtherEntityIsSubscribed(Roster roster, a a2, Date date) {
        final ReentrantLock reentrantLock = new ReentrantLock();
        final Condition condition = reentrantLock.newCondition();
        AbstractRosterListener abstractRosterListener = new AbstractRosterListener(){

            private void signal() {
                reentrantLock.lock();
                try {
                    condition.signal();
                }
                finally {
                    reentrantLock.unlock();
                }
            }

            @Override
            public void entriesAdded(Collection<i> collection) {
                this.signal();
            }

            @Override
            public void entriesUpdated(Collection<i> collection) {
                this.signal();
            }
        };
        roster.addRosterListener(abstractRosterListener);
        boolean bl = true;
        reentrantLock.lock();
        try {
            while (!roster.isSubscribedToMyPresence((i)a2)) {
                if (!bl) {
                    throw new TimeoutException();
                }
                bl = condition.awaitUntil(date);
            }
        }
        finally {
            reentrantLock.unlock();
            roster.removeRosterListener(abstractRosterListener);
        }
    }

    public static void preApproveSubscriptionIfRequiredAndPossible(Roster roster, a a2) {
        if (!roster.isSubscriptionPreApprovalSupported()) {
            return;
        }
        RosterEntry rosterEntry = roster.getEntry(a2);
        if (rosterEntry == null || !rosterEntry.canSeeMyPresence() && !rosterEntry.isApproved()) {
            try {
                roster.preApprove(a2);
            }
            catch (SmackException.FeatureNotSupportedException featureNotSupportedException) {
                throw new AssertionError((Object)featureNotSupportedException);
            }
        }
    }

    public static void askForSubscriptionIfRequired(Roster roster, a a2) {
        RosterEntry rosterEntry = roster.getEntry(a2);
        if (rosterEntry == null || !rosterEntry.canSeeHisPresence() && !rosterEntry.isSubscriptionPending()) {
            roster.sendSubscriptionRequest(a2);
        }
    }

    public static void ensureNotSubscribedToEachOther(XMPPConnection xMPPConnection, XMPPConnection xMPPConnection2) {
        Roster roster = Roster.getInstanceFor(xMPPConnection);
        a a2 = xMPPConnection.getUser().n();
        Roster roster2 = Roster.getInstanceFor(xMPPConnection2);
        a a3 = xMPPConnection2.getUser().n();
        RosterUtil.ensureNotSubscribed(roster, a3);
        RosterUtil.ensureNotSubscribed(roster2, a2);
    }

    public static void ensureNotSubscribed(Roster roster, a a2) {
        RosterEntry rosterEntry = roster.getEntry(a2);
        if (rosterEntry != null && rosterEntry.canSeeMyPresence()) {
            rosterEntry.cancelSubscription();
        }
    }

    public static void ensureSubscribed(XMPPConnection xMPPConnection, XMPPConnection xMPPConnection2, long l) {
        RosterUtil.ensureSubscribedTo(xMPPConnection, xMPPConnection2, l);
        RosterUtil.ensureSubscribedTo(xMPPConnection2, xMPPConnection, l);
    }

    public static void ensureSubscribedTo(XMPPConnection xMPPConnection, XMPPConnection xMPPConnection2, long l) {
        Date date = new Date(System.currentTimeMillis() + l);
        RosterUtil.ensureSubscribedTo(xMPPConnection, xMPPConnection2, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureSubscribedTo(XMPPConnection xMPPConnection, XMPPConnection xMPPConnection2, Date date) {
        a a2;
        Roster roster = Roster.getInstanceFor(xMPPConnection);
        if (roster.iAmSubscribedTo((i)(a2 = xMPPConnection2.getUser().n()))) {
            return;
        }
        final a a3 = xMPPConnection.getUser().n();
        SubscribeListener subscribeListener = new SubscribeListener(){

            @Override
            public SubscribeListener.SubscribeAnswer processSubscribe(i i2, Presence presence) {
                if (i2.a((CharSequence)a3)) {
                    return SubscribeListener.SubscribeAnswer.Approve;
                }
                return null;
            }
        };
        Roster roster2 = Roster.getInstanceFor(xMPPConnection2);
        roster2.addSubscribeListener(subscribeListener);
        try {
            roster.sendSubscriptionRequest(a2);
            RosterUtil.waitUntilOtherEntityIsSubscribed(roster2, a3, date);
        }
        finally {
            roster2.removeSubscribeListener(subscribeListener);
        }
    }
}

