/*
 * Decompiled with CFR 0.152.
 */
package org.nibor.autolink.internal;

import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;
import org.nibor.autolink.internal.LinkSpanImpl;
import org.nibor.autolink.internal.Scanner;
import org.nibor.autolink.internal.Scanners;

public class EmailScanner
implements Scanner {
    private final boolean domainMustHaveDot;

    public EmailScanner(boolean bl) {
        this.domainMustHaveDot = bl;
    }

    @Override
    public LinkSpan scan(CharSequence charSequence, int n, int n2) {
        int n3 = n - 1;
        int n4 = this.findFirst(charSequence, n3, n2);
        if (n4 == -1) {
            return null;
        }
        int n5 = n + 1;
        int n6 = this.findLast(charSequence, n5);
        if (n6 == -1) {
            return null;
        }
        return new LinkSpanImpl(LinkType.EMAIL, n4, n6 + 1);
    }

    private int findFirst(CharSequence charSequence, int n, int n2) {
        int n3 = -1;
        boolean bl = true;
        for (int i = n; i >= n2; --i) {
            char c = charSequence.charAt(i);
            if (this.localAtomAllowed(c)) {
                n3 = i;
                bl = false;
                continue;
            }
            if (c != '.' || bl) break;
            bl = true;
        }
        return n3;
    }

    private int findLast(CharSequence charSequence, int n) {
        boolean bl = true;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = -1;
        for (int i = n; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (bl) {
                if (!this.subDomainAllowed(c)) break;
                n3 = i;
                bl = false;
                bl2 = true;
                continue;
            }
            if (c == '.') {
                if (!bl2) break;
                bl = true;
                if (n2 != -1) continue;
                n2 = i;
                continue;
            }
            if (c == '-') {
                bl2 = false;
                continue;
            }
            if (!this.subDomainAllowed(c)) break;
            n3 = i;
            bl2 = true;
        }
        if (this.domainMustHaveDot && (n2 == -1 || n2 > n3)) {
            return -1;
        }
        return n3;
    }

    private boolean localAtomAllowed(char c) {
        if (Scanners.isAlnum(c) || Scanners.isNonAscii(c)) {
            return true;
        }
        switch (c) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '=': 
            case '?': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private boolean subDomainAllowed(char c) {
        return Scanners.isAlnum(c) || Scanners.isNonAscii(c);
    }
}

