/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.pool;

import io.ktor.utils.io.pool.DefaultPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lio/ktor/utils/io/pool/ByteBufferPool;", "Lio/ktor/utils/io/pool/DefaultPool;", "Ljava/nio/ByteBuffer;", "", "capacity", "bufferSize", "<init>", "(II)V", "produceInstance", "()Ljava/nio/ByteBuffer;", "instance", "clearInstance", "(Ljava/nio/ByteBuffer;)Ljava/nio/ByteBuffer;", "", "validateInstance", "(Ljava/nio/ByteBuffer;)V", "I", "getBufferSize", "()I", "ktor-io"})
public final class ByteBufferPool
extends DefaultPool<ByteBuffer> {
    private final int bufferSize;

    public ByteBufferPool(int n2, int n3) {
        super(n2);
        this.bufferSize = n3;
    }

    public /* synthetic */ ByteBufferPool(int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n2 = 2000;
        }
        if ((n4 & 2) != 0) {
            n3 = 4096;
        }
        this(n2, n3);
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    protected ByteBuffer produceInstance() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.bufferSize);
        Intrinsics.checkNotNull((Object)byteBuffer);
        return byteBuffer;
    }

    @Override
    protected ByteBuffer clearInstance(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2;
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"");
        ByteBuffer byteBuffer3 = byteBuffer2 = byteBuffer;
        boolean bl = false;
        byteBuffer3.clear();
        byteBuffer3.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer2;
    }

    @Override
    protected void validateInstance(ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"");
        if (!(byteBuffer.capacity() == this.bufferSize)) {
            throw new IllegalStateException("Check failed.");
        }
        if (!(!byteBuffer.isDirect())) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public ByteBufferPool() {
        this(0, 0, 3, null);
    }
}

