/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.SaxEventInterpreter;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;
import java.util.Stack;

public class SaxEventInterpretationContext
extends ContextAwareBase
implements PropertyContainer {
    Stack<Model> modelStack;
    SaxEventInterpreter saxEventInterpreter;

    public SaxEventInterpretationContext(Context context, SaxEventInterpreter saxEventInterpreter) {
        this.context = context;
        this.saxEventInterpreter = saxEventInterpreter;
        this.modelStack = new Stack();
    }

    public SaxEventInterpreter getSaxEventInterpreter() {
        return this.saxEventInterpreter;
    }

    public Model peekModel() {
        if (this.modelStack.isEmpty()) {
            return null;
        }
        return this.modelStack.peek();
    }

    public void pushModel(Model model) {
        this.modelStack.push(model);
    }

    public boolean isModelStackEmpty() {
        return this.modelStack.isEmpty();
    }

    public Model popModel() {
        return this.modelStack.pop();
    }

    public Stack<Model> getCopyOfModelStack() {
        Stack<Model> stack = new Stack<Model>();
        stack.addAll(this.modelStack);
        return stack;
    }

    @Override
    public void addSubstitutionProperty(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProperty(String string) {
        return this.context.getProperty(string);
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return null;
    }

    public String subst(String string) {
        if (string == null) {
            return null;
        }
        try {
            return OptionHelper.substVars(string, this, this.context);
        }
        catch (ScanException | IllegalArgumentException exception) {
            this.addError("Problem while parsing [" + string + "]", exception);
            return string;
        }
    }
}

