/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.GenericXMLConfigurator;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.DependencyDefinition;
import ch.qos.logback.core.model.util.VariableSubstitutionsHelper;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Supplier;

public class ModelInterpretationContext
extends ContextAwareBase
implements ContextAwarePropertyContainer {
    Stack<Object> objectStack;
    Stack<Model> modelStack;
    Supplier<? extends GenericXMLConfigurator> configuratorSupplier;
    Map<String, Object> objectMap;
    protected VariableSubstitutionsHelper variableSubstitutionsHelper;
    protected Map<String, String> importMap;
    private final BeanDescriptionCache beanDescriptionCache;
    final DefaultNestedComponentRegistry defaultNestedComponentRegistry = new DefaultNestedComponentRegistry();
    List<DependencyDefinition> dependencyDefinitionList = new ArrayList<DependencyDefinition>();
    final List<String> startedDependees = new ArrayList<String>();
    Object configuratorHint;
    Model topModel;

    public ModelInterpretationContext(Context context) {
        this(context, null);
    }

    public ModelInterpretationContext(Context context, Object object) {
        this.context = context;
        this.configuratorHint = object;
        this.objectStack = new Stack();
        this.modelStack = new Stack();
        this.beanDescriptionCache = new BeanDescriptionCache(context);
        this.objectMap = new HashMap<String, Object>(5);
        this.variableSubstitutionsHelper = new VariableSubstitutionsHelper(context);
        this.importMap = new HashMap<String, String>(5);
    }

    public ModelInterpretationContext(ModelInterpretationContext modelInterpretationContext) {
        this(modelInterpretationContext.context, modelInterpretationContext.configuratorHint);
        this.importMap = new HashMap<String, String>(modelInterpretationContext.importMap);
        this.variableSubstitutionsHelper = new VariableSubstitutionsHelper(this.context, modelInterpretationContext.getCopyOfPropertyMap());
        this.defaultNestedComponentRegistry.duplicate(modelInterpretationContext.getDefaultNestedComponentRegistry());
        this.createAppenderBags();
    }

    public Map<String, Object> getObjectMap() {
        return this.objectMap;
    }

    public void createAppenderBags() {
        this.objectMap.put("APPENDER_BAG", new HashMap());
        this.objectMap.put("APPENDER_REF_BAG", new HashMap());
    }

    public Model getTopModel() {
        return this.topModel;
    }

    public void setTopModel(Model model) {
        this.topModel = model;
    }

    public void pushModel(Model model) {
        this.modelStack.push(model);
    }

    public Model peekModel() {
        return this.modelStack.peek();
    }

    public boolean isModelStackEmpty() {
        return this.modelStack.isEmpty();
    }

    public Model popModel() {
        return this.modelStack.pop();
    }

    public Stack<Object> getObjectStack() {
        return this.objectStack;
    }

    public boolean isObjectStackEmpty() {
        return this.objectStack.isEmpty();
    }

    public Object peekObject() {
        return this.objectStack.peek();
    }

    public void pushObject(Object object) {
        this.objectStack.push(object);
    }

    public Object popObject() {
        return this.objectStack.pop();
    }

    public Object getObject(int n) {
        return this.objectStack.get(n);
    }

    public Object getConfiguratorHint() {
        return this.configuratorHint;
    }

    public void setConfiguratorHint(Object object) {
        this.configuratorHint = object;
    }

    public BeanDescriptionCache getBeanDescriptionCache() {
        return this.beanDescriptionCache;
    }

    @Override
    public String subst(String string) {
        return this.variableSubstitutionsHelper.subst(string);
    }

    public DefaultNestedComponentRegistry getDefaultNestedComponentRegistry() {
        return this.defaultNestedComponentRegistry;
    }

    public void addDependencyDefinition(DependencyDefinition dependencyDefinition) {
        this.dependencyDefinitionList.add(dependencyDefinition);
    }

    public List<DependencyDefinition> getDependencyDefinitions() {
        return Collections.unmodifiableList(this.dependencyDefinitionList);
    }

    public List<String> getDependeeNamesForModel(Model model) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DependencyDefinition dependencyDefinition : this.dependencyDefinitionList) {
            if (dependencyDefinition.getDepender() != model) continue;
            arrayList.add(dependencyDefinition.getDependee());
        }
        return arrayList;
    }

    public boolean hasDependers(String string) {
        if (string == null || string.trim().length() == 0) {
            new IllegalArgumentException("Empty dependeeName name not allowed here");
        }
        for (DependencyDefinition dependencyDefinition : this.dependencyDefinitionList) {
            if (!dependencyDefinition.dependee.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void markStartOfNamedDependee(String string) {
        this.startedDependees.add(string);
    }

    public boolean isNamedDependeeStarted(String string) {
        return this.startedDependees.contains(string);
    }

    @Override
    public void addSubstitutionProperty(String string, String string2) {
        this.variableSubstitutionsHelper.addSubstitutionProperty(string, string2);
    }

    @Override
    public String getProperty(String string) {
        return this.variableSubstitutionsHelper.getProperty(string);
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return this.variableSubstitutionsHelper.getCopyOfPropertyMap();
    }

    public void addImport(String string, String string2) {
        this.importMap.put(string, string2);
    }

    public Map<String, String> getImportMapCopy() {
        return new HashMap<String, String>(this.importMap);
    }

    public String getImport(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.importMap.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public Supplier<? extends GenericXMLConfigurator> getConfiguratorSupplier() {
        return this.configuratorSupplier;
    }

    public void setConfiguratorSupplier(Supplier<? extends GenericXMLConfigurator> supplier) {
        this.configuratorSupplier = supplier;
    }
}

