/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class TimeBasedArchiveRemover
extends ContextAwareBase
implements ArchiveRemover {
    protected static final long UNINITIALIZED = -1L;
    protected static final long INACTIVITY_TOLERANCE_IN_MILLIS = 2764800000L;
    static final int MAX_VALUE_FOR_INACTIVITY_PERIODS = 336;
    final FileNamePattern fileNamePattern;
    final RollingCalendar rc;
    private int maxHistory = 0;
    private long totalSizeCap = 0L;
    final boolean parentClean;
    long lastHeartBeat = -1L;
    int callCount = 0;

    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rollingCalendar) {
        this.fileNamePattern = fileNamePattern;
        this.rc = rollingCalendar;
        this.parentClean = this.computeParentCleaningFlag(fileNamePattern);
    }

    @Override
    public Future<?> cleanAsynchronously(Instant instant) {
        ArchiveRemoverRunnable archiveRemoverRunnable = new ArchiveRemoverRunnable(instant);
        ExecutorService executorService = this.context.getAlternateExecutorService();
        Future<?> future = executorService.submit(archiveRemoverRunnable);
        return future;
    }

    @Override
    public void clean(Instant instant) {
        long l = instant.toEpochMilli();
        int n = this.computeElapsedPeriodsSinceLastClean(l);
        this.lastHeartBeat = l;
        if (n > 1) {
            this.addInfo("Multiple periods, i.e. " + n + " periods, seem to have elapsed. This is expected at application start.");
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.getPeriodOffsetForDeletionTarget() - i;
            Instant instant2 = this.rc.getEndOfNextNthPeriod(instant, n2);
            this.cleanPeriod(instant2);
        }
    }

    protected File[] getFilesInPeriod(Instant instant) {
        String string = this.fileNamePattern.convert(instant);
        File file = new File(string);
        if (this.fileExistsAndIsFile(file)) {
            return new File[]{file};
        }
        return new File[0];
    }

    private boolean fileExistsAndIsFile(File file) {
        return file.exists() && file.isFile();
    }

    public void cleanPeriod(Instant instant) {
        File[] fileArray;
        for (File file : fileArray = this.getFilesInPeriod(instant)) {
            this.checkAndDeleteFile(file);
        }
        if (this.parentClean && fileArray.length > 0) {
            File file = this.getParentDir(fileArray[0]);
            this.removeFolderIfEmpty(file);
        }
    }

    private boolean checkAndDeleteFile(File file) {
        this.addInfo("deleting " + String.valueOf(file));
        if (file == null) {
            this.addWarn("Cannot delete empty file");
            return false;
        }
        if (!file.exists()) {
            this.addWarn("Cannot delete non existent file");
            return false;
        }
        boolean bl = file.delete();
        if (!bl) {
            this.addWarn("Failed to delete file " + file.toString());
        }
        return bl;
    }

    void capTotalSize(Instant instant) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.maxHistory; ++i) {
            Instant instant2 = this.rc.getEndOfNextNthPeriod(instant, -i);
            File[] fileArray = this.getFilesInPeriod(instant2);
            this.descendingSort(fileArray, instant2);
            for (File file : fileArray) {
                long l3 = file.length();
                if ((l += l3) <= this.totalSizeCap) continue;
                this.addInfo("Deleting [" + String.valueOf(file) + "] of size " + String.valueOf(new FileSize(l3)));
                boolean bl = this.checkAndDeleteFile(file);
                if (bl) {
                    ++n;
                    l2 += l3;
                    continue;
                }
                ++n2;
            }
        }
        if (n + n2 == 0) {
            this.addInfo("No removal attempts were made.");
        } else {
            this.addInfo("Removed  " + String.valueOf(new FileSize(l2)) + " of files in " + n + " files.");
            if (n2 != 0) {
                this.addInfo("There were " + n2 + " failed deletion attempts.");
            }
        }
    }

    protected void descendingSort(File[] fileArray, Instant instant) {
    }

    File getParentDir(File file) {
        File file2 = file.getAbsoluteFile();
        File file3 = file2.getParentFile();
        return file3;
    }

    int computeElapsedPeriodsSinceLastClean(long l) {
        long l2 = 0L;
        if (this.lastHeartBeat == -1L) {
            this.addInfo("first clean up after appender initialization");
            l2 = this.rc.periodBarriersCrossed(l, l + 2764800000L);
            l2 = Math.min(l2, 336L);
        } else {
            l2 = this.rc.periodBarriersCrossed(this.lastHeartBeat, l);
        }
        return (int)l2;
    }

    boolean computeParentCleaningFlag(FileNamePattern fileNamePattern) {
        Converter<Object> converter;
        DateTokenConverter<Object> dateTokenConverter = fileNamePattern.getPrimaryDateTokenConverter();
        if (dateTokenConverter.getDatePattern().indexOf(47) != -1) {
            return true;
        }
        for (converter = fileNamePattern.headTokenConverter; converter != null && !(converter instanceof DateTokenConverter); converter = converter.getNext()) {
        }
        while (converter != null) {
            String string;
            if (converter instanceof LiteralConverter && (string = converter.convert(null)).indexOf(47) != -1) {
                return true;
            }
            converter = converter.getNext();
        }
        return false;
    }

    void removeFolderIfEmpty(File file) {
        this.removeFolderIfEmpty(file, 0);
    }

    private void removeFolderIfEmpty(File file, int n) {
        if (n >= 3) {
            return;
        }
        if (file.isDirectory() && FileFilterUtil.isEmptyDirectory(file)) {
            this.addInfo("deleting folder [" + String.valueOf(file) + "]");
            this.checkAndDeleteFile(file);
            this.removeFolderIfEmpty(file.getParentFile(), n + 1);
        }
    }

    @Override
    public void setMaxHistory(int n) {
        this.maxHistory = n;
    }

    protected int getPeriodOffsetForDeletionTarget() {
        return -this.maxHistory - 1;
    }

    @Override
    public void setTotalSizeCap(long l) {
        this.totalSizeCap = l;
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }

    public class ArchiveRemoverRunnable
    implements Runnable {
        Instant now;

        ArchiveRemoverRunnable(Instant instant) {
            this.now = instant;
        }

        @Override
        public void run() {
            TimeBasedArchiveRemover.this.clean(this.now);
            if (TimeBasedArchiveRemover.this.totalSizeCap != 0L && TimeBasedArchiveRemover.this.totalSizeCap > 0L) {
                TimeBasedArchiveRemover.this.capTotalSize(this.now);
            }
        }
    }
}

