/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.html.DefaultCssBuilder;
import ch.qos.logback.classic.html.DefaultThrowableRenderer;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.Transform;
import ch.qos.logback.core.html.HTMLLayoutBase;
import ch.qos.logback.core.html.IThrowableRenderer;
import ch.qos.logback.core.pattern.Converter;
import java.util.Map;

public class HTMLLayout
extends HTMLLayoutBase<ILoggingEvent> {
    static final String DEFAULT_CONVERSION_PATTERN = "%date%thread%level%logger%mdc%msg";
    IThrowableRenderer<ILoggingEvent> throwableRenderer;

    public HTMLLayout() {
        this.pattern = DEFAULT_CONVERSION_PATTERN;
        this.throwableRenderer = new DefaultThrowableRenderer();
        this.cssBuilder = new DefaultCssBuilder();
    }

    public void start() {
        int n = 0;
        if (this.throwableRenderer == null) {
            this.addError("ThrowableRender cannot be null.");
            ++n;
        }
        if (n == 0) {
            super.start();
        }
    }

    protected Map<String, String> getDefaultConverterMap() {
        return PatternLayout.DEFAULT_CONVERTER_MAP;
    }

    public String doLayout(ILoggingEvent iLoggingEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        this.startNewTableIfLimitReached(stringBuilder);
        boolean bl = true;
        if ((this.counter++ & 1L) == 0L) {
            bl = false;
        }
        String string = iLoggingEvent.getLevel().toString().toLowerCase();
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append("<tr class=\"");
        stringBuilder.append(string);
        if (bl) {
            stringBuilder.append(" odd\">");
        } else {
            stringBuilder.append(" even\">");
        }
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        for (Converter converter = this.head; converter != null; converter = converter.getNext()) {
            this.appendEventToBuffer(stringBuilder, (Converter<ILoggingEvent>)converter, iLoggingEvent);
        }
        stringBuilder.append("</tr>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        if (iLoggingEvent.getThrowableProxy() != null) {
            this.throwableRenderer.render(stringBuilder, (Object)iLoggingEvent);
        }
        return stringBuilder.toString();
    }

    private void appendEventToBuffer(StringBuilder stringBuilder, Converter<ILoggingEvent> converter, ILoggingEvent iLoggingEvent) {
        stringBuilder.append("<td class=\"");
        stringBuilder.append(this.computeConverterName(converter));
        stringBuilder.append("\">");
        stringBuilder.append(Transform.escapeTags((String)converter.convert((Object)iLoggingEvent)));
        stringBuilder.append("</td>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
    }

    public IThrowableRenderer<ILoggingEvent> getThrowableRenderer() {
        return this.throwableRenderer;
    }

    public void setThrowableRenderer(IThrowableRenderer<ILoggingEvent> iThrowableRenderer) {
        this.throwableRenderer = iThrowableRenderer;
    }

    protected String computeConverterName(Converter<ILoggingEvent> converter) {
        if (converter instanceof MDCConverter) {
            MDCConverter mDCConverter = (MDCConverter)converter;
            String string = mDCConverter.getFirstOption();
            if (string != null) {
                return string;
            }
            return "MDC";
        }
        return super.computeConverterName(converter);
    }
}

