/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;

public class ConfigurationModelHandler
extends ModelHandlerBase {
    static final Duration SCAN_PERIOD_DEFAULT = Duration.buildByMinutes((double)1.0);

    public ConfigurationModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ConfigurationModelHandler(context);
    }

    protected Class<ConfigurationModel> getSupportedModelClass() {
        return ConfigurationModel.class;
    }

    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        ConfigurationModel configurationModel = (ConfigurationModel)model;
        String string = OptionHelper.getSystemProperty((String)"logback.debug", null);
        if (string == null) {
            string = modelInterpretationContext.subst(configurationModel.getDebugStr());
        }
        if (!(OptionHelper.isNullOrEmptyOrAllSpaces((String)string) || string.equalsIgnoreCase(Boolean.FALSE.toString()) || string.equalsIgnoreCase("null"))) {
            StatusListenerConfigHelper.addOnConsoleListenerInstance((Context)this.context, (OnConsoleStatusListener)new OnConsoleStatusListener());
        }
        this.processScanAttrib(modelInterpretationContext, configurationModel);
        LoggerContext loggerContext = (LoggerContext)this.context;
        boolean bl = OptionHelper.toBoolean((String)modelInterpretationContext.subst(configurationModel.getPackagingDataStr()), (boolean)false);
        loggerContext.setPackagingDataEnabled(bl);
        ContextUtil contextUtil = new ContextUtil(this.context);
        contextUtil.addGroovyPackages(loggerContext.getFrameworkPackages());
    }

    protected void processScanAttrib(ModelInterpretationContext modelInterpretationContext, ConfigurationModel configurationModel) {
        String string = modelInterpretationContext.subst(configurationModel.getScanStr());
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)string) && !"false".equalsIgnoreCase(string)) {
            this.addInfo("Skipping ReconfigureOnChangeTask registration");
        }
    }
}

