/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.model.LoggerContextListenerModel;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;

public class LoggerContextListenerModelHandler
extends ModelHandlerBase {
    boolean inError = false;
    LoggerContextListener lcl;

    public LoggerContextListenerModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new LoggerContextListenerModelHandler(context);
    }

    protected Class<LoggerContextListenerModel> getSupportedModelClass() {
        return LoggerContextListenerModel.class;
    }

    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        LoggerContextListenerModel loggerContextListenerModel = (LoggerContextListenerModel)model;
        String string = loggerContextListenerModel.getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)string)) {
            this.addError("Empty class name for LoggerContextListener");
            this.inError = true;
        } else {
            string = modelInterpretationContext.getImport(string);
        }
        try {
            this.lcl = (LoggerContextListener)OptionHelper.instantiateByClassName((String)string, LoggerContextListener.class, (Context)this.context);
            if (this.lcl instanceof ContextAware) {
                ((ContextAware)this.lcl).setContext(this.context);
            }
            modelInterpretationContext.pushObject((Object)this.lcl);
            this.addInfo("Adding LoggerContextListener of type [" + string + "] to the object stack");
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create LoggerContextListener of type " + string + "].", exception);
        }
    }

    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) {
        if (this.inError) {
            return;
        }
        Object object = modelInterpretationContext.peekObject();
        if (object != this.lcl) {
            this.addWarn("The object on the top the of the stack is not the LoggerContextListener pushed earlier.");
        } else {
            if (this.lcl instanceof LifeCycle) {
                ((LifeCycle)this.lcl).start();
                this.addInfo("Starting LoggerContextListener");
            }
            ((LoggerContext)this.context).addListener(this.lcl);
            modelInterpretationContext.popObject();
        }
    }
}

