/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.model.ReceiverModel;
import ch.qos.logback.classic.net.ReceiverBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;

public class ReceiverModelHandler
extends ModelHandlerBase {
    private ReceiverBase receiver;
    private boolean inError;

    public ReceiverModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ReceiverModelHandler(context);
    }

    protected Class<ReceiverModel> getSupportedModelClass() {
        return ReceiverModel.class;
    }

    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        ReceiverModel receiverModel = (ReceiverModel)model;
        String string = receiverModel.getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)string)) {
            this.addError("Missing class name for receiver. ");
            this.inError = true;
            return;
        }
        string = modelInterpretationContext.getImport(string);
        try {
            this.addInfo("About to instantiate receiver of type [" + string + "]");
            this.receiver = (ReceiverBase)((Object)OptionHelper.instantiateByClassName((String)string, ReceiverBase.class, (Context)this.context));
            this.receiver.setContext(this.context);
            modelInterpretationContext.pushObject((Object)this.receiver);
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create a receiver of type [" + string + "].", exception);
            throw new ModelHandlerException((Throwable)exception);
        }
    }

    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) {
        if (this.inError) {
            return;
        }
        Object object = modelInterpretationContext.peekObject();
        if (object != this.receiver) {
            this.addWarn("The object at the of the stack is not the receiver pushed earlier.");
        } else {
            modelInterpretationContext.popObject();
            this.addInfo("Registering receiver with context.");
            modelInterpretationContext.getContext().register((LifeCycle)this.receiver);
            this.receiver.start();
        }
    }
}

