/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.SyslogAppenderBase;
import ch.qos.logback.core.net.SyslogOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SyslogAppender
extends SyslogAppenderBase<ILoggingEvent> {
    public static final String DEFAULT_SUFFIX_PATTERN = "[%thread] %logger %msg";
    public static final String DEFAULT_STACKTRACE_PATTERN = "\t";
    PatternLayout stackTraceLayout = new PatternLayout();
    String stackTracePattern = "\t";
    boolean throwableExcluded = false;

    public void start() {
        super.start();
        this.setupStackTraceLayout();
    }

    String getPrefixPattern() {
        return "%syslogStart{" + this.getFacility() + "}%nopex{}";
    }

    public SyslogOutputStream createOutputStream() {
        return new SyslogOutputStream(this.getSyslogHost(), this.getPort());
    }

    public int getSeverityForEvent(Object object) {
        ILoggingEvent iLoggingEvent = (ILoggingEvent)object;
        return LevelToSyslogSeverity.convert(iLoggingEvent);
    }

    protected void postProcess(Object object, OutputStream outputStream) {
        if (this.throwableExcluded) {
            return;
        }
        ILoggingEvent iLoggingEvent = (ILoggingEvent)object;
        IThrowableProxy iThrowableProxy = iLoggingEvent.getThrowableProxy();
        if (iThrowableProxy == null) {
            return;
        }
        String string = this.stackTraceLayout.doLayout(iLoggingEvent);
        boolean bl = true;
        while (iThrowableProxy != null) {
            StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
            try {
                this.handleThrowableFirstLine(outputStream, iThrowableProxy, string, bl);
                bl = false;
                for (StackTraceElementProxy stackTraceElementProxy : stackTraceElementProxyArray) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string).append(stackTraceElementProxy);
                    outputStream.write(stringBuilder.toString().getBytes());
                    outputStream.flush();
                }
            }
            catch (IOException iOException) {
                break;
            }
            iThrowableProxy = iThrowableProxy.getCause();
        }
    }

    private void handleThrowableFirstLine(OutputStream outputStream, IThrowableProxy iThrowableProxy, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder().append(string);
        if (!bl) {
            stringBuilder.append("Caused by: ");
        }
        stringBuilder.append(iThrowableProxy.getClassName()).append(": ").append(iThrowableProxy.getMessage());
        outputStream.write(stringBuilder.toString().getBytes());
        outputStream.flush();
    }

    boolean stackTraceHeaderLine(StringBuilder stringBuilder, boolean bl) {
        return false;
    }

    public Layout<ILoggingEvent> buildLayout() {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        if (this.suffixPattern == null) {
            this.suffixPattern = DEFAULT_SUFFIX_PATTERN;
        }
        patternLayout.setPattern(this.getPrefixPattern() + this.suffixPattern);
        patternLayout.setContext(this.getContext());
        patternLayout.start();
        return patternLayout;
    }

    private void setupStackTraceLayout() {
        this.stackTraceLayout.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        this.stackTraceLayout.setPattern(this.getPrefixPattern() + this.stackTracePattern);
        this.stackTraceLayout.setContext(this.getContext());
        this.stackTraceLayout.start();
    }

    public boolean isThrowableExcluded() {
        return this.throwableExcluded;
    }

    public void setThrowableExcluded(boolean bl) {
        this.throwableExcluded = bl;
    }

    public String getStackTracePattern() {
        return this.stackTracePattern;
    }

    public void setStackTracePattern(String string) {
        this.stackTracePattern = string;
    }
}

