/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.time.ZoneId;
import java.util.List;
import java.util.Locale;

public class DateConverter
extends ClassicConverter {
    long lastTimestamp = -1L;
    String timestampStrCache = null;
    CachingDateFormatter cachingDateFormatter = null;

    public void start() {
        Object object;
        String string = this.getFirstOption();
        if (string == null) {
            string = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (string.equals("ISO8601")) {
            string = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        List list = this.getOptionList();
        ZoneId zoneId = null;
        if (list != null && list.size() > 1) {
            object = (String)list.get(1);
            zoneId = ZoneId.of((String)object);
            this.addInfo("Setting zoneId to \"" + String.valueOf(zoneId) + "\"");
        }
        object = null;
        if (list != null && list.size() > 2) {
            String string2 = (String)list.get(2);
            object = Locale.forLanguageTag(string2);
            this.addInfo("Setting locale to \"" + String.valueOf(object) + "\"");
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(string, zoneId, (Locale)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + string, illegalArgumentException);
            this.cachingDateFormatter = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss,SSS", zoneId);
        }
        super.start();
    }

    public String convert(ILoggingEvent iLoggingEvent) {
        long l = iLoggingEvent.getTimeStamp();
        return this.cachingDateFormatter.format(l);
    }
}

