/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ConfiguratorRank;
import ch.qos.logback.classic.util.ClassicEnvUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareImpl;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.util.Comparator;
import java.util.List;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "logback-test.xml";
    public static final String CONFIG_FILE_PROPERTY = "logback.configurationFile";
    String[] INTERNAL_CONFIGURATOR_CLASSNAME_LIST = new String[]{"ch.qos.logback.classic.joran.SerializedModelConfigurator", "ch.qos.logback.classic.util.DefaultJoranConfigurator", "ch.qos.logback.classic.BasicConfigurator"};
    final LoggerContext loggerContext;
    final ContextAware contextAware;
    Comparator<Configurator> rankComparator = new Comparator<Configurator>(){

        @Override
        public int compare(Configurator configurator, Configurator configurator2) {
            ConfiguratorRank configuratorRank = configurator.getClass().getAnnotation(ConfiguratorRank.class);
            ConfiguratorRank configuratorRank2 = configurator2.getClass().getAnnotation(ConfiguratorRank.class);
            int n = configuratorRank == null ? 20 : configuratorRank.value();
            int n2 = configuratorRank2 == null ? 20 : configuratorRank2.value();
            int n3 = ContextInitializer.this.compareRankValue(n, n2);
            return -n3;
        }
    };

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
        this.contextAware = new ContextAwareImpl((Context)loggerContext, (Object)this);
    }

    public void autoConfig() {
        this.autoConfig(Configurator.class.getClassLoader());
    }

    public void autoConfig(ClassLoader classLoader) {
        classLoader = Loader.systemClassloaderIfNull((ClassLoader)classLoader);
        String string = EnvUtil.logbackVersion();
        if (string == null) {
            string = "?";
        }
        this.loggerContext.getStatusManager().add((Status)new InfoStatus("This is logback-classic version " + string, (Object)this.loggerContext));
        StatusListenerConfigHelper.installIfAsked((Context)this.loggerContext);
        List<Configurator> list = ClassicEnvUtil.loadFromServiceLoader(Configurator.class, classLoader);
        list.sort(this.rankComparator);
        if (list.isEmpty()) {
            this.contextAware.addInfo("No custom configurators were discovered as a service.");
        } else {
            this.printConfiguratorOrder(list);
        }
        for (Configurator configurator : list) {
            if (this.invokeConfigure(configurator) != Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY) continue;
            return;
        }
        for (String string2 : this.INTERNAL_CONFIGURATOR_CLASSNAME_LIST) {
            this.contextAware.addInfo("Trying to configure with " + string2);
            Configurator configurator = this.instantiateConfiguratorByClassName(string2, classLoader);
            if (configurator == null || this.invokeConfigure(configurator) != Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY) continue;
            return;
        }
    }

    private Configurator instantiateConfiguratorByClassName(String string, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return (Configurator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            this.contextAware.addInfo("Instantiation failure: " + reflectiveOperationException.toString());
            return null;
        }
    }

    private Configurator.ExecutionStatus invokeConfigure(Configurator configurator) {
        try {
            long l = System.currentTimeMillis();
            this.contextAware.addInfo("Constructed configurator of type " + String.valueOf(configurator.getClass()));
            configurator.setContext((Context)this.loggerContext);
            Configurator.ExecutionStatus executionStatus = configurator.configure(this.loggerContext);
            this.printDuration(l, configurator, executionStatus);
            return executionStatus;
        }
        catch (Exception exception) {
            throw new LogbackException(String.format("Failed to initialize or to run Configurator: %s", configurator != null ? configurator.getClass().getCanonicalName() : "null"), (Throwable)exception);
        }
    }

    private void printConfiguratorOrder(List<Configurator> list) {
        this.contextAware.addInfo("Here is a list of configurators discovered as a service, by rank: ");
        for (Configurator configurator : list) {
            this.contextAware.addInfo("  " + configurator.getClass().getName());
        }
        this.contextAware.addInfo("They will be invoked in order until ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY is returned.");
    }

    private void printDuration(long l, Configurator configurator, Configurator.ExecutionStatus executionStatus) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.contextAware.addInfo(configurator.getClass().getName() + ".configure() call lasted " + l3 + " milliseconds. ExecutionStatus=" + String.valueOf((Object)executionStatus));
    }

    private Configurator.ExecutionStatus attemptConfigurationUsingJoranUsingReflexion(ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass("ch.qos.logback.classic.util.DefaultJoranConfigurator");
            Configurator configurator = (Configurator)clazz.newInstance();
            configurator.setContext((Context)this.loggerContext);
            return configurator.configure(this.loggerContext);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            this.contextAware.addError("unexpected exception while instantiating DefaultJoranConfigurator", (Throwable)reflectiveOperationException);
            return Configurator.ExecutionStatus.INVOKE_NEXT_IF_ANY;
        }
    }

    private int compareRankValue(int n, int n2) {
        if (n > n2) {
            return 1;
        }
        if (n == n2) {
            return 0;
        }
        return -1;
    }
}

