/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.exceptions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/exposed/exceptions/ExposedSQLException;", "Ljava/sql/SQLException;", "cause", "", "contexts", "", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(Ljava/lang/Throwable;Ljava/util/List;Lorg/jetbrains/exposed/sql/Transaction;)V", "getContexts", "()Ljava/util/List;", "originalSQLException", "causedByQueries", "", "getErrorCode", "", "getSQLState", "toString", "exposed-core"})
public final class ExposedSQLException
extends SQLException {
    private final List<StatementContext> contexts;
    private final Transaction transaction;
    private final SQLException originalSQLException;

    public ExposedSQLException(Throwable throwable, List<StatementContext> list, Transaction transaction2) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        super(throwable);
        this.contexts = list;
        this.transaction = transaction2;
        this.originalSQLException = throwable instanceof SQLException ? (SQLException)throwable : null;
    }

    public final List<StatementContext> getContexts() {
        return this.contexts;
    }

    public final List<String> causedByQueries() {
        Iterable iterable = this.contexts;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            String string;
            StatementContext statementContext = (StatementContext)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            try {
                string = this.transaction.getDebug() ? StatementKt.expandArgs(statementContext, this.transaction) : statementContext.sql(this.transaction);
            }
            catch (Throwable throwable) {
                String string2;
                String string3;
                try {
                    Statement<?> statement = statementContext.getStatement();
                    AbstractQuery abstractQuery = statement instanceof AbstractQuery ? (AbstractQuery)statement : null;
                    string3 = abstractQuery != null ? abstractQuery.prepareSQL(new QueryBuilder(!this.transaction.getDebug())) : null;
                }
                catch (Throwable throwable2) {
                    string3 = null;
                }
                if ((string2 = string3) == null) {
                    string2 = "Failed on expanding args for " + (Object)((Object)statementContext.getStatement().getType()) + ": " + statementContext.getStatement();
                }
                string = string2;
            }
            collection2.add(string);
        }
        return (List)collection;
    }

    @Override
    public String getSQLState() {
        SQLException sQLException = this.originalSQLException;
        String string = sQLException != null ? sQLException.getSQLState() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public int getErrorCode() {
        SQLException sQLException = this.originalSQLException;
        return sQLException != null ? sQLException.getErrorCode() : 0;
    }

    @Override
    public String toString() {
        return super.toString() + "\nSQL: " + this.causedByQueries();
    }
}

