/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.statements.api.ExposedBlob;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/BlobColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedBlob;", "useObjectIdentifier", "", "(Z)V", "getUseObjectIdentifier", "()Z", "nonNullValueToString", "", "value", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "setParameter", "", "stmt", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "", "sqlType", "valueFromDB", "exposed-core"})
public final class BlobColumnType
extends ColumnType<ExposedBlob> {
    private final boolean useObjectIdentifier;

    public BlobColumnType(boolean bl) {
        super(false, 1, null);
        this.useObjectIdentifier = bl;
    }

    public /* synthetic */ BlobColumnType(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getUseObjectIdentifier() {
        return this.useObjectIdentifier;
    }

    @Override
    public String sqlType() {
        String string;
        if (this.useObjectIdentifier && DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect) {
            string = "oid";
        } else {
            if (this.useObjectIdentifier) {
                throw new IllegalStateException("Storing BLOBs using OID columns is only supported by PostgreSQL".toString());
            }
            string = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().blobType();
        }
        return string;
    }

    @Override
    public ExposedBlob valueFromDB(Object object) {
        ExposedBlob exposedBlob;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Object object2 = object;
        if (object2 instanceof ExposedBlob) {
            exposedBlob = (ExposedBlob)object;
        } else if (object2 instanceof InputStream) {
            exposedBlob = new ExposedBlob((InputStream)object);
        } else if (object2 instanceof byte[]) {
            exposedBlob = new ExposedBlob((byte[])object);
        } else if (object2 instanceof Blob) {
            InputStream inputStream = ((Blob)object).getBinaryStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"");
            exposedBlob = new ExposedBlob(inputStream);
        } else {
            throw new IllegalStateException(("Unexpected value of type Blob: " + object + " of " + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName()).toString());
        }
        return exposedBlob;
    }

    @Override
    public String nonNullValueToString(ExposedBlob exposedBlob) {
        Intrinsics.checkNotNullParameter((Object)exposedBlob, (String)"");
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().hexToDb(exposedBlob.hexString());
    }

    @Override
    public ExposedBlob readObject(ResultSet resultSet, int n) {
        ExposedBlob exposedBlob;
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
        if (DatabaseDialectKt.getCurrentDialect() instanceof SQLServerDialect) {
            byte[] byArray = resultSet.getBytes(n);
            if (byArray != null) {
                byte[] byArray2 = byArray;
                boolean bl = false;
                exposedBlob = new ExposedBlob(byArray2);
            } else {
                exposedBlob = null;
            }
        } else if (DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect && this.useObjectIdentifier) {
            Object object = resultSet.getBlob(n);
            if (object != null && (object = object.getBinaryStream()) != null) {
                Object object2 = object;
                boolean bl = false;
                exposedBlob = new ExposedBlob((InputStream)object2);
            } else {
                exposedBlob = null;
            }
        } else {
            InputStream inputStream = resultSet.getBinaryStream(n);
            if (inputStream != null) {
                InputStream inputStream2 = inputStream;
                boolean bl = false;
                exposedBlob = new ExposedBlob(inputStream2);
            } else {
                exposedBlob = null;
            }
        }
        return exposedBlob;
    }

    @Override
    public void setParameter(PreparedStatementApi preparedStatementApi, int n, Object object) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)preparedStatementApi, (String)"");
        Object object3 = object instanceof ExposedBlob ? (ExposedBlob)object : null;
        if (object3 == null || (object3 = ((ExposedBlob)object3).getInputStream()) == null) {
            object3 = object;
        }
        if ((object2 = object3) instanceof InputStream) {
            preparedStatementApi.setInputStream(n, (InputStream)object2, this.useObjectIdentifier);
        } else {
            Object object4 = object2;
            if (object4 == null ? true : object4 instanceof Op.NULL) {
                preparedStatementApi.setNull(n, this);
            } else {
                super.setParameter(preparedStatementApi, n, object2);
            }
        }
    }

    public BlobColumnType() {
        this(false, 1, null);
    }
}

