/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 &*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001&B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\u0015\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\rH\u0016J\u0017\u0010!\u001a\u00020\"2\b\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010%R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR/\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u00000\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lorg/jetbrains/exposed/sql/EnumerationNameColumnType;", "T", "", "Lorg/jetbrains/exposed/sql/ColumnType;", "klass", "Lkotlin/reflect/KClass;", "colLength", "", "(Lkotlin/reflect/KClass;I)V", "getColLength", "()I", "enumConstants", "", "", "kotlin.jvm.PlatformType", "getEnumConstants", "()Ljava/util/Map;", "enumConstants$delegate", "Lkotlin/Lazy;", "getKlass", "()Lkotlin/reflect/KClass;", "equals", "", "other", "", "escape", "value", "hashCode", "nonNullValueToString", "(Ljava/lang/Enum;)Ljava/lang/String;", "notNullValueToDB", "(Ljava/lang/Enum;)Ljava/lang/Object;", "sqlType", "validateValueBeforeUpdate", "", "(Ljava/lang/Enum;)V", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Enum;", "Companion", "exposed-core"})
public final class EnumerationNameColumnType<T extends Enum<T>>
extends ColumnType<T> {
    public static final Companion Companion = new Companion(null);
    private final KClass<T> klass;
    private final int colLength;
    private final Lazy enumConstants$delegate;
    private static final Map<Character, String> charactersToEscape;

    public EnumerationNameColumnType(KClass<T> kClass, int n) {
        Intrinsics.checkNotNullParameter(kClass, (String)"");
        super(false, 1, null);
        this.klass = kClass;
        this.colLength = n;
        this.enumConstants$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends T>>(this){
            final /* synthetic */ EnumerationNameColumnType<T> this$0;
            {
                this.this$0 = enumerationNameColumnType;
                super(0);
            }

            public final Map<String, T> invoke() {
                T[] TArray = JvmClassMappingKt.getJavaClass(this.this$0.getKlass()).getEnumConstants();
                Intrinsics.checkNotNull(TArray);
                T[] TArray2 = TArray;
                boolean bl = false;
                int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)TArray2.length), (int)16);
                T[] TArray3 = TArray2;
                Map map = new LinkedHashMap<K, V>(n);
                boolean bl2 = false;
                for (T t : TArray3) {
                    Enum enum_ = (Enum)t;
                    Map map2 = map;
                    boolean bl3 = false;
                    map2.put(enum_.name(), t);
                }
                return map;
            }
        });
    }

    public final KClass<T> getKlass() {
        return this.klass;
    }

    public final int getColLength() {
        return this.colLength;
    }

    private final Map<String, T> getEnumConstants() {
        Lazy lazy = this.enumConstants$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().varcharType(this.colLength);
    }

    @Override
    public T valueFromDB(Object object) {
        Enum enum_;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Object object2 = object;
        if (object2 instanceof String) {
            enum_ = (Enum)this.getEnumConstants().get(object);
            if (enum_ == null) {
                throw new IllegalStateException((object + " can't be associated with any from enum " + this.klass.getQualifiedName()).toString());
            }
        } else if (object2 instanceof Enum) {
            enum_ = (Enum)object;
        } else {
            throw new IllegalStateException((object + " of " + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName() + " is not valid for enum " + this.klass.getQualifiedName()).toString());
        }
        return (T)enum_;
    }

    @Override
    public Object notNullValueToDB(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        return ((Enum)t).name();
    }

    @Override
    public String nonNullValueToString(T t) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(t, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append('\'');
        stringBuilder2.append(this.escape(((Enum)t).name()));
        stringBuilder2.append('\'');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public void validateValueBeforeUpdate(T t) {
        int n;
        if (t != null && !((n = ((Enum)t).name().codePointCount(0, ((Enum)t).name().length())) <= this.colLength)) {
            boolean bl = false;
            String string = "Value can't be stored to database column because exceeds length (" + n + " > " + this.colLength + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        Object object2 = object;
        if (!Intrinsics.areEqual(this.getClass(), object2 != null ? object2.getClass() : null)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)object);
        EnumerationNameColumnType cfr_ignored_0 = (EnumerationNameColumnType)object;
        return Intrinsics.areEqual(this.klass, ((EnumerationNameColumnType)object).klass);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.klass.hashCode();
        return n;
    }

    private final String escape(String string) {
        CharSequence charSequence = string;
        boolean bl = false;
        CharSequence charSequence2 = charSequence;
        Collection collection = new ArrayList(charSequence.length());
        boolean bl2 = false;
        for (int i = 0; i < charSequence2.length(); ++i) {
            char c;
            char c2 = c = charSequence2.charAt(i);
            Collection collection2 = collection;
            boolean bl3 = false;
            Object object = charactersToEscape.get(Character.valueOf(c2));
            if (object == null) {
                object = Character.valueOf(c2);
            }
            collection2.add(object);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)collection), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\''), (Object)"''"), TuplesKt.to((Object)Character.valueOf('\r'), (Object)"\\r"), TuplesKt.to((Object)Character.valueOf('\n'), (Object)"\\n")};
        charactersToEscape = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/EnumerationNameColumnType$Companion;", "", "()V", "charactersToEscape", "", "", "", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

