/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.exposed.sql.ExplainResultRow;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001\u001dB#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\nJ&\u0010\u0013\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00140\u00010\u0001H\u0016J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0096\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0014\u0010\u001b\u001a\u00020\u0004*\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/exposed/sql/ExplainQuery;", "", "Lorg/jetbrains/exposed/sql/ExplainResultRow;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "Ljava/sql/ResultSet;", "analyze", "", "options", "", "internalStatement", "(ZLjava/lang/String;Lorg/jetbrains/exposed/sql/statements/Statement;)V", "getAnalyze", "()Z", "getOptions", "()Ljava/lang/String;", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "getTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "arguments", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "iterator", "", "prepareSQL", "prepared", "executeInternal", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "ResultIterator", "exposed-core"})
public class ExplainQuery
extends Statement<ResultSet>
implements Iterable<ExplainResultRow>,
KMappedMarker {
    private final boolean analyze;
    private final String options;
    private final Statement<?> internalStatement;

    public ExplainQuery(boolean bl, String string, Statement<?> statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"");
        super(StatementType.SHOW, CollectionsKt.emptyList());
        this.analyze = bl;
        this.options = string;
        this.internalStatement = statement;
    }

    public final boolean getAnalyze() {
        return this.analyze;
    }

    public final String getOptions() {
        return this.options;
    }

    private final Transaction getTransaction() {
        return TransactionManager.Companion.current();
    }

    @Override
    public ResultSet executeInternal(PreparedStatementApi preparedStatementApi, Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)preparedStatementApi, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        return preparedStatementApi.executeQuery();
    }

    @Override
    public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        return this.internalStatement.arguments();
    }

    @Override
    public String prepareSQL(Transaction transaction2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        String string = this.internalStatement.prepareSQL(transaction2, bl);
        return transaction2.getDb().getDialect().getFunctionProvider().explain(this.analyze, this.options, string, transaction2);
    }

    @Override
    public Iterator<ExplainResultRow> iterator() {
        Object t = this.getTransaction().exec(this);
        Intrinsics.checkNotNull(t);
        ResultIterator resultIterator = new ResultIterator((ResultSet)t);
        return ((Iterable)new Iterable<ExplainResultRow>(resultIterator){
            final /* synthetic */ ResultIterator $resultIterator$inlined;
            {
                this.$resultIterator$inlined = resultIterator;
            }

            public Iterator<ExplainResultRow> iterator() {
                boolean bl = false;
                return this.$resultIterator$inlined;
            }
        }).iterator();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u000bH\u0096\u0002J\t\u0010\u000f\u001a\u00020\u0002H\u0096\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/exposed/sql/ExplainQuery$ResultIterator;", "", "Lorg/jetbrains/exposed/sql/ExplainResultRow;", "rs", "Ljava/sql/ResultSet;", "(Lorg/jetbrains/exposed/sql/ExplainQuery;Ljava/sql/ResultSet;)V", "fieldIndex", "", "", "", "value", "", "hasNext", "setHasNext", "(Z)V", "next", "exposed-core"})
    private final class ResultIterator
    implements Iterator<ExplainResultRow>,
    KMappedMarker {
        private final ResultSet rs;
        private final Map<String, Integer> fieldIndex;
        private boolean hasNext;

        public ResultIterator(ResultSet resultSet) {
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
            this.rs = resultSet;
            int n = this.rs.getMetaData().getColumnCount();
            ResultIterator resultIterator = this;
            ArrayList<Pair> arrayList = new ArrayList<Pair>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Pair> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(TuplesKt.to((Object)this.rs.getMetaData().getColumnName(n4 + 1), (Object)n4));
            }
            resultIterator.fieldIndex = MapsKt.toMap((Iterable)arrayList);
            this.setHasNext(this.rs.next());
        }

        private final void setHasNext(boolean bl) {
            this.hasNext = bl;
            if (!this.hasNext) {
                java.sql.Statement statement = this.rs.getStatement();
                if (statement != null) {
                    statement.close();
                }
                Transaction transaction2 = ExplainQuery.this.getTransaction();
                int n = transaction2.getOpenResultSetsCount$exposed_core();
                transaction2.setOpenResultSetsCount$exposed_core(n + -1);
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public ExplainResultRow next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            ExplainResultRow explainResultRow = ExplainResultRow.Companion.create(this.rs, this.fieldIndex);
            this.setHasNext(this.rs.next());
            return explainResultRow;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

