/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\r\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\fJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014J\u0006\u0010 \u001a\u00020\nR\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001a\u0010\u000eR\u0015\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001b\u0010\u000eR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001c\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001d\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/jetbrains/exposed/sql/Sequence;", "", "name", "", "startWith", "", "incrementBy", "minValue", "maxValue", "cycle", "", "cache", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Boolean;Ljava/lang/Long;)V", "getCache", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getCycle", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "ddl", "", "getDdl", "()Ljava/util/List;", "identifier", "getIdentifier", "()Ljava/lang/String;", "getIncrementBy", "getMaxValue", "getMinValue", "getStartWith", "createStatement", "dropStatement", "exists", "exposed-core"})
public final class Sequence {
    private final String name;
    private final Long startWith;
    private final Long incrementBy;
    private final Long minValue;
    private final Long maxValue;
    private final Boolean cycle;
    private final Long cache;

    public Sequence(String string, Long l, Long l2, Long l3, Long l4, Boolean bl, Long l5) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.name = string;
        this.startWith = l;
        this.incrementBy = l2;
        this.minValue = l3;
        this.maxValue = l4;
        this.cycle = bl;
        this.cache = l5;
    }

    public /* synthetic */ Sequence(String string, Long l, Long l2, Long l3, Long l4, Boolean bl, Long l5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = null;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        if ((n & 8) != 0) {
            l3 = null;
        }
        if ((n & 0x10) != 0) {
            l4 = null;
        }
        if ((n & 0x20) != 0) {
            bl = null;
        }
        if ((n & 0x40) != 0) {
            l5 = null;
        }
        this(string, l, l2, l3, l4, bl, l5);
    }

    public final Long getStartWith() {
        return this.startWith;
    }

    public final Long getIncrementBy() {
        return this.incrementBy;
    }

    public final Long getMinValue() {
        return this.minValue;
    }

    public final Long getMaxValue() {
        return this.maxValue;
    }

    public final Boolean getCycle() {
        return this.cycle;
    }

    public final Long getCache() {
        return this.cache;
    }

    public final String getIdentifier() {
        return TransactionManager.Companion.current().getDb().getIdentifierManager().cutIfNecessaryAndQuote(this.name);
    }

    public final List<String> getDdl() {
        return this.createStatement();
    }

    public final List<String> createStatement() {
        StringBuilder stringBuilder;
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsCreateSequence()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support create sequence statement", DatabaseDialectKt.getCurrentDialect());
        }
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append("CREATE SEQUENCE ");
        if (DatabaseDialectKt.getCurrentDialect().getSupportsIfNotExists()) {
            stringBuilder2.append("IF NOT EXISTS ");
        }
        stringBuilder2.append(this.getIdentifier());
        SchemaKt.appendIfNotNull(stringBuilder2, " START WITH", this.startWith);
        SchemaKt.appendIfNotNull(stringBuilder2, " INCREMENT BY", this.incrementBy);
        SchemaKt.appendIfNotNull(stringBuilder2, " MINVALUE", this.minValue);
        SchemaKt.appendIfNotNull(stringBuilder2, " MAXVALUE", this.maxValue);
        if (Intrinsics.areEqual((Object)this.cycle, (Object)true)) {
            stringBuilder2.append(" CYCLE");
        }
        SchemaKt.appendIfNotNull(stringBuilder2, " CACHE", this.cache);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        String string2 = string;
        return CollectionsKt.listOf((Object)string2);
    }

    public final List<String> dropStatement() {
        StringBuilder stringBuilder;
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsCreateSequence()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support drop sequence statement", DatabaseDialectKt.getCurrentDialect());
        }
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append("DROP SEQUENCE ");
        if (DatabaseDialectKt.getCurrentDialect().getSupportsIfNotExists()) {
            stringBuilder2.append("IF EXISTS ");
        }
        stringBuilder2.append(this.getIdentifier());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        String string2 = string;
        return CollectionsKt.listOf((Object)string2);
    }

    public final boolean exists() {
        return DatabaseDialectKt.getCurrentDialect().sequenceExists(this);
    }
}

