/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.EntityIDColumnType;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchDataInconsistentException;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0004\b&\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u001fH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\r\u0010&\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b'J*\u0010(\u001a\u00020\u001e\"\u0004\b\u0000\u0010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0\f2\u0006\u0010+\u001a\u0002H)H\u0096\u0002\u00a2\u0006\u0002\u0010,J\r\u0010-\u001a\u00020\u001eH\u0010\u00a2\u0006\u0002\b.J4\u0010/\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f002\u0018\u00101\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f00H\u0014J\u0010\u00102\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\fH\u0002R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\r\u001a\"\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e0\u0002\u0018\u00010\u00028TX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013RH\u0010\u0014\u001a6\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00160\u0015j\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0016`\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001b\u00a8\u00063\u00b2\u0006\u0014\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u0002X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/exposed/sql/statements/BaseBatchInsertStatement;", "Lorg/jetbrains/exposed/sql/statements/InsertStatement;", "", "Lorg/jetbrains/exposed/sql/ResultRow;", "table", "Lorg/jetbrains/exposed/sql/Table;", "ignore", "", "shouldReturnGeneratedValues", "(Lorg/jetbrains/exposed/sql/Table;ZZ)V", "allColumnsInDataSet", "", "Lorg/jetbrains/exposed/sql/Column;", "arguments", "Lkotlin/Pair;", "", "getArguments", "()Ljava/util/List;", "setArguments", "(Ljava/util/List;)V", "data", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getData$exposed_core", "()Ljava/util/ArrayList;", "isAlwaysBatch", "()Z", "getShouldReturnGeneratedValues", "addBatch", "", "", "prepared", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "sql", "", "removeLastBatch", "removeLastBatch$exposed_core", "set", "S", "column", "value", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Object;)V", "validateLastBatch", "validateLastBatch$exposed_core", "valuesAndDefaults", "", "values", "isDefaultable", "exposed-core", "nullableColumns"})
public abstract class BaseBatchInsertStatement
extends InsertStatement<List<? extends ResultRow>> {
    private final boolean shouldReturnGeneratedValues;
    private final boolean isAlwaysBatch;
    private final ArrayList<Map<Column<?>, Object>> data;
    private final Set<Column<?>> allColumnsInDataSet;
    private List<? extends List<? extends Pair<? extends Column<?>, ? extends Object>>> arguments;

    public BaseBatchInsertStatement(Table table, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"");
        super(table, bl);
        this.shouldReturnGeneratedValues = bl2;
        this.isAlwaysBatch = true;
        this.data = new ArrayList();
        this.allColumnsInDataSet = new LinkedHashSet();
    }

    public /* synthetic */ BaseBatchInsertStatement(Table table, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(table, bl, bl2);
    }

    protected final boolean getShouldReturnGeneratedValues() {
        return this.shouldReturnGeneratedValues;
    }

    @Override
    public boolean isAlwaysBatch() {
        return this.isAlwaysBatch;
    }

    public final ArrayList<Map<Column<?>, Object>> getData$exposed_core() {
        return this.data;
    }

    private final boolean isDefaultable(Column<?> column) {
        return column.getColumnType().getNullable() || column.getDefaultValueFun() != null || column.isDatabaseGenerated$exposed_core();
    }

    @Override
    public <S> void set(Column<S> column, S s) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        if (this.data.size() > 1) {
            Map<Column<?>, Object> map = this.data.get(this.data.size() - 2);
            Intrinsics.checkNotNullExpressionValue(map, (String)"");
            if (!map.containsKey(column) && !this.isDefaultable(column)) {
                String string = TransactionManager.Companion.current().fullIdentity(column);
                throw new BatchDataInconsistentException("Can't set " + s + " for " + string + " because previous insertion can't be defaulted for that column.");
            }
        }
        super.set(column, s);
    }

    public final void addBatch() {
        if (!((Collection)this.data).isEmpty()) {
            this.validateLastBatch$exposed_core();
            this.data.set(this.data.size() - 1, new LinkedHashMap(this.getValues()));
            this.allColumnsInDataSet.addAll((Collection)this.getValues().keySet());
            this.getValues().clear();
            this.setHasBatchedValues(true);
        }
        this.data.add(this.getValues());
        this.setArguments(null);
    }

    public final void removeLastBatch$exposed_core() {
        this.data.remove(this.data.size() - 1);
        this.allColumnsInDataSet.clear();
        Iterable iterable = this.data;
        Collection collection = this.allColumnsInDataSet;
        boolean bl = false;
        for (Object t : iterable) {
            Object object = (Map)t;
            boolean bl2 = false;
            object = object.keySet();
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        this.getValues().clear();
        this.getValues().putAll((Map)CollectionsKt.last((List)this.data));
        this.setArguments(null);
        this.setHasBatchedValues(this.data.size() > 0);
    }

    public void validateLastBatch$exposed_core() {
        boolean bl;
        Column<Object> column2;
        Object object3;
        Transaction transaction2 = TransactionManager.Companion.current();
        Object object2 = SetsKt.minus(this.allColumnsInDataSet, (Iterable)this.getValues().keySet());
        boolean bl2 = false;
        Iterable iterable = object2;
        Iterable iterable2 = new ArrayList();
        boolean bl3 = false;
        for (Object object3 : iterable) {
            column2 = (Column)object3;
            boolean bl4 = false;
            if (this.isDefaultable(column2)) continue;
            iterable2.add(object3);
        }
        List list = (List)iterable2;
        if (!((Collection)list).isEmpty()) {
            object2 = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(transaction2){
                final /* synthetic */ Transaction $tr;
                {
                    this.$tr = transaction2;
                    super(1);
                }

                public final CharSequence invoke(Column<?> column) {
                    Intrinsics.checkNotNullParameter(column, (String)"");
                    return this.$tr.fullIdentity(column);
                }
            }, (int)31, null);
            throw new BatchDataInconsistentException("Can't add a new batch because columns: " + (String)object2 + " don't have client default values. DB defaults are not supported in batch inserts");
        }
        Object object4 = this.getTargets();
        boolean bl5 = false;
        iterable2 = object4;
        Collection collection = new ArrayList();
        boolean bl6 = false;
        for (Column<Object> column2 : iterable2) {
            Object object5 = (Table)((Object)column2);
            bl = false;
            object5 = ((Table)object5).getColumns();
            CollectionsKt.addAll((Collection)collection, (Iterable)object5);
        }
        object4 = CollectionsKt.minus((Iterable)((List)collection), (Iterable)this.getValues().keySet());
        bl5 = false;
        iterable2 = object4;
        collection = new ArrayList();
        bl6 = false;
        object3 = iterable2.iterator();
        while (object3.hasNext()) {
            Column<Object> column3 = column2 = object3.next();
            bl = false;
            if (!(!this.isDefaultable(column3) && !ColumnTypeKt.isAutoInc(column3.getColumnType()) && column3.getDbDefaultValue$exposed_core() == null && !(column3.getColumnType() instanceof EntityIDColumnType))) continue;
            collection.add(column2);
        }
        object2 = (List)collection;
        if (CollectionsKt.any((Iterable)((Iterable)object2))) {
            object4 = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), null, null, null, (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(transaction2){
                final /* synthetic */ Transaction $tr;
                {
                    this.$tr = transaction2;
                    super(1);
                }

                public final CharSequence invoke(Column<?> column) {
                    Intrinsics.checkNotNullParameter(column, (String)"");
                    return this.$tr.fullIdentity(column);
                }
            }, (int)31, null);
            throw new BatchDataInconsistentException("Can't add a new batch because columns: " + (String)object4 + " don't have default values. DB defaults are not supported in batch inserts");
        }
    }

    private final Set<Column<?>> allColumnsInDataSet() {
        Object object = (Map)CollectionsKt.lastOrNull((List)this.data);
        if (object == null || (object = object.keySet()) == null) {
            throw new BatchDataInconsistentException("No data provided for inserting into " + this.getTable().getTableName());
        }
        return SetsKt.plus(this.allColumnsInDataSet, (Iterable)((Iterable)object));
    }

    @Override
    protected List<List<Pair<Column<?>, Object>>> getArguments() {
        Iterable<List<Object>> iterable = this.arguments;
        if (iterable == null) {
            BaseBatchInsertStatement baseBatchInsertStatement = this;
            boolean bl = false;
            Lazy lazy = LazyKt.lazy((Function0)new Function0<List<? extends Column<?>>>(baseBatchInsertStatement){
                final /* synthetic */ BaseBatchInsertStatement $this_run;
                {
                    this.$this_run = baseBatchInsertStatement;
                    super(0);
                }

                public final List<Column<?>> invoke() {
                    Iterable iterable = BaseBatchInsertStatement.access$allColumnsInDataSet(this.$this_run);
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    Collection collection = new ArrayList<E>();
                    boolean bl2 = false;
                    for (T t : iterable2) {
                        Column column = (Column)t;
                        boolean bl3 = false;
                        if (!(column.getColumnType().getNullable() && !column.isDatabaseGenerated$exposed_core())) continue;
                        collection.add(t);
                    }
                    return (List)collection;
                }
            });
            Iterable iterable2 = baseBatchInsertStatement.data;
            boolean bl2 = false;
            Iterable iterable3 = iterable2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            boolean bl3 = false;
            for (Object t : iterable3) {
                Map map = (Map)t;
                Collection collection2 = collection;
                boolean bl4 = false;
                Map<Column<?>, Object> map2 = super.valuesAndDefaults(map);
                Intrinsics.checkNotNull(map2);
                Map map3 = TypeIntrinsics.asMutableMap(map2);
                Iterable iterable4 = CollectionsKt.minus((Iterable)BaseBatchInsertStatement._get_arguments_$lambda$9$lambda$4(lazy), (Iterable)map3.keySet());
                boolean bl5 = false;
                LinkedHashMap linkedHashMap = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable4, (int)10)), (int)16));
                Iterable iterable5 = iterable4;
                boolean bl6 = false;
                for (Object t2 : iterable5) {
                    Column column = (Column)t2;
                    Object t3 = t2;
                    Map map4 = linkedHashMap;
                    boolean bl7 = false;
                    Object v = null;
                    map4.put(t3, v);
                }
                Map map5 = linkedHashMap;
                map3.putAll(map5);
                iterable4 = MapsKt.toList((Map)map3);
                bl5 = false;
                collection2.add(CollectionsKt.sortedWith((Iterable)iterable4, (Comparator)new Comparator(){

                    public final int compare(T t, T t2) {
                        Pair pair = (Pair)t;
                        boolean bl = false;
                        Comparable comparable = (Column)pair.getFirst();
                        pair = (Pair)t2;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Column)pair.getFirst()));
                    }
                }));
            }
            Iterable iterable6 = iterable2 = (List)collection;
            boolean bl8 = false;
            this.arguments = iterable6;
            iterable = iterable2;
        }
        return iterable;
    }

    @Override
    protected void setArguments(List<? extends List<? extends Pair<? extends Column<?>, ? extends Object>>> list) {
        this.arguments = list;
    }

    @Override
    protected Map<Column<?>, Object> valuesAndDefaults(Map<Column<?>, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        List<List<Pair<Column<?>, Object>>> list = this.getArguments();
        Intrinsics.checkNotNull(list);
        return MapsKt.toMap((Iterable)((Iterable)CollectionsKt.first(list)));
    }

    @Override
    public PreparedStatementApi prepared(Transaction transaction2, String string) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return !this.shouldReturnGeneratedValues ? transaction2.getConnection().prepareStatement(string, false) : super.prepared(transaction2, string);
    }

    private static final List<Column<?>> _get_arguments_$lambda$9$lambda$4(Lazy<? extends List<? extends Column<?>>> lazy) {
        Lazy<? extends List<? extends Column<?>>> lazy2 = lazy;
        return (List)lazy2.getValue();
    }

    public static final /* synthetic */ Set access$allColumnsInDataSet(BaseBatchInsertStatement baseBatchInsertStatement) {
        return baseBatchInsertStatement.allColumnsInDataSet();
    }
}

