/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.statements.api.ExposedBlob;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\u00020\u0013*\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/exposed/sql/statements/api/ExposedBlob;", "", "bytes", "", "([B)V", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "getBytes", "()[B", "<set-?>", "getInputStream", "()Ljava/io/InputStream;", "equals", "", "other", "hashCode", "", "hexString", "", "toHexString", "exposed-core"})
public final class ExposedBlob {
    private InputStream inputStream;

    public ExposedBlob(InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"");
        this.inputStream = inputStream;
    }

    public ExposedBlob(byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        this(new ByteArrayInputStream(byArray));
    }

    public final InputStream getInputStream() {
        return this.inputStream;
    }

    public final byte[] getBytes() {
        byte[] byArray;
        byte[] byArray2 = byArray = ByteStreamsKt.readBytes((InputStream)this.inputStream);
        boolean bl = false;
        if (this.inputStream.markSupported()) {
            try {
                this.inputStream.reset();
            }
            catch (IOException iOException) {
                if (DatabaseDialectKt.getCurrentDialectIfAvailable() instanceof OracleDialect) {
                    this.inputStream = new ByteArrayInputStream(byArray2);
                }
            }
        } else {
            this.inputStream = new ByteArrayInputStream(byArray2);
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExposedBlob)) {
            return false;
        }
        return Arrays.equals(this.getBytes(), ((ExposedBlob)object).getBytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }

    public final String hexString() {
        return this.toHexString(this.getBytes());
    }

    private final String toHexString(byte[] byArray) {
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)toHexString.1.INSTANCE, (int)30, null);
    }
}

