/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.PostgreSQLFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J0\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J(\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0014\u0010\u001d\u001a\u00020\b2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006+"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "requiresAutoCommitOnCreateDrop", "", "getRequiresAutoCommitOnCreateDrop", "()Z", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "supportsWindowFrameGroupsMode", "getSupportsWindowFrameGroupsMode", "createDatabase", "createIndexWithType", "table", "columns", "type", "filterCondition", "dropDatabase", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "listDatabases", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "setSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "Companion", "exposed-core"})
public class PostgreSQLDialect
extends VendorDialect {
    public static final Companion Companion = new Companion(null);
    private final String name;
    private final boolean supportsSubqueryUnions;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean requiresAutoCommitOnCreateDrop;
    private final boolean supportsWindowFrameGroupsMode;

    public PostgreSQLDialect(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        super(Companion.getDialectName(), PostgreSQLDataTypeProvider.INSTANCE, PostgreSQLFunctionProvider.INSTANCE);
        this.name = string;
        this.supportsSubqueryUnions = true;
        this.supportsOrderByNullsFirstLast = true;
        this.requiresAutoCommitOnCreateDrop = true;
        this.supportsWindowFrameGroupsMode = true;
    }

    public /* synthetic */ PostgreSQLDialect(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = Companion.getDialectName();
        }
        this(string);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getRequiresAutoCommitOnCreateDrop() {
        return this.requiresAutoCommitOnCreateDrop;
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        return this.supportsWindowFrameGroupsMode;
    }

    @Override
    public boolean isAllowedAsColumnDefault(Expression<?> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        return true;
    }

    @Override
    public List<String> modifyColumn(Column<?> column, ColumnDiff columnDiff) {
        StringBuilder stringBuilder;
        block6: {
            boolean bl;
            Object object;
            Expression<?> expression;
            String string;
            StringBuilder stringBuilder2;
            block7: {
                Intrinsics.checkNotNullParameter(column, (String)"");
                Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"");
                stringBuilder2 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                Transaction transaction2 = TransactionManager.Companion.current();
                stringBuilder2.append("ALTER TABLE " + transaction2.identity(column.getTable()) + ' ');
                string = transaction2.identity(column);
                stringBuilder2.append("ALTER COLUMN " + string + " TYPE " + column.getColumnType().sqlType());
                if (columnDiff.getNullability()) {
                    stringBuilder2.append(", ALTER COLUMN " + string + ' ');
                    if (column.getColumnType().getNullable()) {
                        stringBuilder2.append("DROP ");
                    } else {
                        stringBuilder2.append("SET ");
                    }
                    stringBuilder2.append("NOT NULL");
                }
                if (!columnDiff.getDefaults()) break block6;
                expression = column.getDbDefaultValue$exposed_core();
                if (expression == null) break block7;
                object = expression;
                bl = false;
                StringBuilder stringBuilder3 = stringBuilder2.append(", ALTER COLUMN " + string + " SET DEFAULT " + PostgreSQLDataTypeProvider.INSTANCE.processForDefaultValue((Expression<?>)object));
                expression = stringBuilder3;
                if (stringBuilder3 != null) break block6;
            }
            object = stringBuilder2;
            bl = false;
            expression = ((StringBuilder)object).append(",  ALTER COLUMN " + string + " DROP DEFAULT");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return CollectionsKt.listOf((Object)string);
    }

    @Override
    public String createDatabase(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "CREATE DATABASE " + DatabaseDialectKt.inProperCase(string);
    }

    @Override
    public String listDatabases() {
        return "SELECT datname FROM pg_database";
    }

    @Override
    public String dropDatabase(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "DROP DATABASE " + DatabaseDialectKt.inProperCase(string);
    }

    @Override
    public String setSchema(Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        return "SET search_path TO " + schema.getIdentifier();
    }

    @Override
    protected String createIndexWithType(String string, String string2, String string3, String string4, String string5) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"");
        return "CREATE INDEX " + string + " ON " + string2 + " USING " + string4 + ' ' + string3 + string5;
    }

    @Override
    public String dropIndex(String string, String string2, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return bl && !bl2 ? "ALTER TABLE IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(string) + " DROP CONSTRAINT IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(string2) : "DROP INDEX IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(string2);
    }

    public PostgreSQLDialect() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("PostgreSQL");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

