/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.DecompressionException;

final class FastLz {
    private static final int MAX_DISTANCE = 8191;
    private static final int MAX_FARDISTANCE = 73725;
    private static final int HASH_LOG = 13;
    private static final int HASH_SIZE = 8192;
    private static final int HASH_MASK = 8191;
    private static final int MAX_COPY = 32;
    private static final int MAX_LEN = 264;
    private static final int MIN_RECOMENDED_LENGTH_FOR_LEVEL_2 = 65536;
    static final int MAGIC_NUMBER = 4607066;
    static final byte BLOCK_TYPE_NON_COMPRESSED = 0;
    static final byte BLOCK_TYPE_COMPRESSED = 1;
    static final byte BLOCK_WITHOUT_CHECKSUM = 0;
    static final byte BLOCK_WITH_CHECKSUM = 16;
    static final int OPTIONS_OFFSET = 3;
    static final int CHECKSUM_OFFSET = 4;
    static final int MAX_CHUNK_LENGTH = 65535;
    static final int MIN_LENGTH_TO_COMPRESSION = 32;
    static final int LEVEL_AUTO = 0;
    static final int LEVEL_1 = 1;
    static final int LEVEL_2 = 2;

    static int calculateOutputBufferLength(int n) {
        int n2 = (int)((double)n * 1.06);
        return Math.max(n2, 66);
    }

    static int compress(ByteBuf byteBuf, int n, int n2, ByteBuf byteBuf2, int n3, int n4) {
        int n5;
        int n6 = n4 == 0 ? (n2 < 65536 ? 1 : 2) : n4;
        int n7 = 0;
        int n8 = n7 + n2 - 2;
        int n9 = n7 + n2 - 12;
        int n10 = 0;
        int[] nArray = new int[8192];
        if (n2 < 4) {
            if (n2 != 0) {
                byteBuf2.setByte(n3 + n10++, (int)((byte)(n2 - 1)));
                ++n8;
                while (n7 <= n8) {
                    byteBuf2.setByte(n3 + n10++, (int)byteBuf.getByte(n + n7++));
                }
                return n2 + 1;
            }
            return 0;
        }
        for (n5 = 0; n5 < 8192; ++n5) {
            nArray[n5] = n7;
        }
        int n11 = 2;
        byteBuf2.setByte(n3 + n10++, 31);
        byteBuf2.setByte(n3 + n10++, (int)byteBuf.getByte(n + n7++));
        byteBuf2.setByte(n3 + n10++, (int)byteBuf.getByte(n + n7++));
        while (n7 < n9) {
            byte by;
            int n12;
            int n13;
            long l;
            int n14;
            block38: {
                int n15;
                block40: {
                    block39: {
                        n14 = 0;
                        l = 0L;
                        n13 = 3;
                        n15 = n7;
                        boolean bl = false;
                        if (n6 == 2 && byteBuf.getByte(n + n7) == byteBuf.getByte(n + n7 - 1) && FastLz.readU16(byteBuf, n + n7 - 1) == FastLz.readU16(byteBuf, n + n7 + 1)) {
                            l = 1L;
                            n7 += 3;
                            n14 = n15 + 2;
                            bl = true;
                        }
                        if (bl) break block38;
                        n5 = n12 = FastLz.hashFunction(byteBuf, n + n7);
                        n14 = nArray[n12];
                        l = n15 - n14;
                        nArray[n5] = n15;
                        if (l == 0L || (n6 != 1 ? l >= 73725L : l >= 8191L)) break block39;
                        if (byteBuf.getByte(n + n14++) == byteBuf.getByte(n + n7++) && byteBuf.getByte(n + n14++) == byteBuf.getByte(n + n7++) && byteBuf.getByte(n + n14++) == byteBuf.getByte(n + n7++)) break block40;
                    }
                    byteBuf2.setByte(n3 + n10++, (int)byteBuf.getByte(n + n15++));
                    n7 = n15;
                    if (++n11 != 32) continue;
                    n11 = 0;
                    byteBuf2.setByte(n3 + n10++, 31);
                    continue;
                }
                if (n6 == 2 && l >= 8191L) {
                    if (byteBuf.getByte(n + n7++) != byteBuf.getByte(n + n14++) || byteBuf.getByte(n + n7++) != byteBuf.getByte(n + n14++)) {
                        byteBuf2.setByte(n3 + n10++, (int)byteBuf.getByte(n + n15++));
                        n7 = n15;
                        if (++n11 != 32) continue;
                        n11 = 0;
                        byteBuf2.setByte(n3 + n10++, 31);
                        continue;
                    }
                    n13 += 2;
                }
            }
            if (--l == 0L) {
                by = byteBuf.getByte(n + n7 - 1);
                for (n7 = n15 + n13; n7 < n8 && byteBuf.getByte(n + n14++) == by; ++n7) {
                }
            } else {
                by = 0;
                for (int i = 0; i < 8; ++i) {
                    if (byteBuf.getByte(n + n14++) == byteBuf.getByte(n + n7++)) continue;
                    by = 1;
                    break;
                }
                if (by == 0) {
                    while (n7 < n8 && byteBuf.getByte(n + n14++) == byteBuf.getByte(n + n7++)) {
                    }
                }
            }
            if (n11 != 0) {
                byteBuf2.setByte(n3 + n10 - n11 - 1, (int)((byte)(n11 - 1)));
            } else {
                --n10;
            }
            n11 = 0;
            if (n6 == 2) {
                if (l < 8191L) {
                    if (n13 < 7) {
                        byteBuf2.setByte(n3 + n10++, (int)((byte)((long)(n13 << 5) + (l >>> 8))));
                        byteBuf2.setByte(n3 + n10++, (int)((byte)(l & 0xFFL)));
                    } else {
                        byteBuf2.setByte(n3 + n10++, (int)((byte)(224L + (l >>> 8))));
                        n13 -= 7;
                        while (n13 >= 255) {
                            byteBuf2.setByte(n3 + n10++, -1);
                            n13 -= 255;
                        }
                        byteBuf2.setByte(n3 + n10++, (int)((byte)n13));
                        byteBuf2.setByte(n3 + n10++, (int)((byte)(l & 0xFFL)));
                    }
                } else if (n13 < 7) {
                    byteBuf2.setByte(n3 + n10++, (int)((byte)((n13 << 5) + 31)));
                    byteBuf2.setByte(n3 + n10++, -1);
                    byteBuf2.setByte(n3 + n10++, (int)((byte)((l -= 8191L) >>> 8)));
                    byteBuf2.setByte(n3 + n10++, (int)((byte)(l & 0xFFL)));
                } else {
                    l -= 8191L;
                    byteBuf2.setByte(n3 + n10++, -1);
                    n13 -= 7;
                    while (n13 >= 255) {
                        byteBuf2.setByte(n3 + n10++, -1);
                        n13 -= 255;
                    }
                    byteBuf2.setByte(n3 + n10++, (int)((byte)n13));
                    byteBuf2.setByte(n3 + n10++, -1);
                    byteBuf2.setByte(n3 + n10++, (int)((byte)(l >>> 8)));
                    byteBuf2.setByte(n3 + n10++, (int)((byte)(l & 0xFFL)));
                }
            } else {
                if (n13 > 262) {
                    for (n13 = (n7 -= 3) - n15; n13 > 262; n13 -= 262) {
                        byteBuf2.setByte(n3 + n10++, (int)((byte)(224L + (l >>> 8))));
                        byteBuf2.setByte(n3 + n10++, -3);
                        byteBuf2.setByte(n3 + n10++, (int)((byte)(l & 0xFFL)));
                    }
                }
                if (n13 < 7) {
                    byteBuf2.setByte(n3 + n10++, (int)((byte)((long)(n13 << 5) + (l >>> 8))));
                    byteBuf2.setByte(n3 + n10++, (int)((byte)(l & 0xFFL)));
                } else {
                    byteBuf2.setByte(n3 + n10++, (int)((byte)(224L + (l >>> 8))));
                    byteBuf2.setByte(n3 + n10++, (int)((byte)(n13 - 7)));
                    byteBuf2.setByte(n3 + n10++, (int)((byte)(l & 0xFFL)));
                }
            }
            n12 = FastLz.hashFunction(byteBuf, n + n7);
            nArray[n12] = n7++;
            n12 = FastLz.hashFunction(byteBuf, n + n7);
            nArray[n12] = n7++;
            byteBuf2.setByte(n3 + n10++, 31);
        }
        ++n8;
        while (n7 <= n8) {
            byteBuf2.setByte(n3 + n10++, (int)byteBuf.getByte(n + n7++));
            if (++n11 != 32) continue;
            n11 = 0;
            byteBuf2.setByte(n3 + n10++, 31);
        }
        if (n11 != 0) {
            byteBuf2.setByte(n3 + n10 - n11 - 1, (int)((byte)(n11 - 1)));
        } else {
            --n10;
        }
        if (n6 == 2) {
            byteBuf2.setByte(n3, byteBuf2.getByte(n3) | 0x20);
        }
        return n10;
    }

    static int decompress(ByteBuf byteBuf, int n, int n2, ByteBuf byteBuf2, int n3, int n4) {
        int n5 = (byteBuf.getByte(n) >> 5) + 1;
        if (n5 != 1 && n5 != 2) {
            throw new DecompressionException(String.format("invalid level: %d (expected: %d or %d)", n5, 1, 2));
        }
        int n6 = 0;
        int n7 = 0;
        long l = byteBuf.getByte(n + n6++) & 0x1F;
        boolean bl = true;
        do {
            int n8 = n7;
            long l2 = l >> 5;
            long l3 = (l & 0x1FL) << 8;
            if (l >= 32L) {
                short s;
                n8 = (int)((long)n8 - l3);
                if (--l2 == 6L) {
                    if (n5 == 1) {
                        l2 += (long)byteBuf.getUnsignedByte(n + n6++);
                    } else {
                        do {
                            s = byteBuf.getUnsignedByte(n + n6++);
                            l2 += (long)s;
                        } while (s == 255);
                    }
                }
                if (n5 == 1) {
                    n8 -= byteBuf.getUnsignedByte(n + n6++);
                } else {
                    s = byteBuf.getUnsignedByte(n + n6++);
                    n8 -= s;
                    if (s == 255 && l3 == 7936L) {
                        l3 = byteBuf.getUnsignedByte(n + n6++) << 8;
                        n8 = (int)((long)n7 - (l3 += (long)byteBuf.getUnsignedByte(n + n6++)) - 8191L);
                    }
                }
                if ((long)n7 + l2 + 3L > (long)n4) {
                    return 0;
                }
                if (n8 - 1 < 0) {
                    return 0;
                }
                if (n6 < n2) {
                    l = byteBuf.getUnsignedByte(n + n6++);
                } else {
                    bl = false;
                }
                if (n8 == n7) {
                    byte by = byteBuf2.getByte(n3 + n8 - 1);
                    byteBuf2.setByte(n3 + n7++, (int)by);
                    byteBuf2.setByte(n3 + n7++, (int)by);
                    byteBuf2.setByte(n3 + n7++, (int)by);
                    while (l2 != 0L) {
                        byteBuf2.setByte(n3 + n7++, (int)by);
                        --l2;
                    }
                } else {
                    int n9 = n7++;
                    int n10 = --n8;
                    byteBuf2.setByte(n3 + n9, (int)byteBuf2.getByte(n3 + n10));
                    int n11 = n7++;
                    int n12 = ++n8;
                    byteBuf2.setByte(n3 + n11, (int)byteBuf2.getByte(n3 + n12));
                    int n13 = n7++;
                    int n14 = ++n8;
                    ++n8;
                    byteBuf2.setByte(n3 + n13, (int)byteBuf2.getByte(n3 + n14));
                    while (l2 != 0L) {
                        byteBuf2.setByte(n3 + n7++, (int)byteBuf2.getByte(n3 + n8++));
                        --l2;
                    }
                }
            } else {
                if ((long)n7 + ++l > (long)n4) {
                    return 0;
                }
                if ((long)n6 + l > (long)n2) {
                    return 0;
                }
                byteBuf2.setByte(n3 + n7++, (int)byteBuf.getByte(n + n6++));
                --l;
                while (l != 0L) {
                    byteBuf2.setByte(n3 + n7++, (int)byteBuf.getByte(n + n6++));
                    --l;
                }
                boolean bl2 = bl = n6 < n2;
                if (!bl) continue;
                l = byteBuf.getUnsignedByte(n + n6++);
            }
        } while (bl);
        return n7;
    }

    private static int hashFunction(ByteBuf byteBuf, int n) {
        int n2 = FastLz.readU16(byteBuf, n);
        n2 ^= FastLz.readU16(byteBuf, n + 1) ^ n2 >> 3;
        return n2 &= 0x1FFF;
    }

    private static int readU16(ByteBuf byteBuf, int n) {
        if (n + 1 >= byteBuf.readableBytes()) {
            return byteBuf.getUnsignedByte(n);
        }
        return byteBuf.getUnsignedByte(n + 1) << 8 | byteBuf.getUnsignedByte(n);
    }

    private FastLz() {
    }
}

