/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentRange;
import io.ktor.http.RangesSpecifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u0005*\b\u0012\u0004\u0012\u00020\t0\u0005H\u0000\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"", "rangeSpec", "Lio/ktor/http/RangesSpecifier;", "parseRangesSpecifier", "(Ljava/lang/String;)Lio/ktor/http/RangesSpecifier;", "", "Lio/ktor/http/ContentRange;", "", "contentLength", "Lkotlin/ranges/LongRange;", "toLongRanges", "(Ljava/util/List;J)Ljava/util/List;", "mergeRangesKeepOrder", "(Ljava/util/List;)Ljava/util/List;", "ktor-http"})
public final class RangesKt {
    public static final RangesSpecifier parseRangesSpecifier(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            String string2 = string;
            String string3 = "=";
            boolean bl = false;
            int n = StringsKt.indexOf$default((CharSequence)string2, (String)string3, (int)0, (boolean)false, (int)6, null);
            if (n == -1) {
                boolean bl2 = false;
                return null;
            }
            String string4 = string2.substring(0, n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
            String string5 = string2.substring(n + string3.length());
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
            Pair pair = TuplesKt.to((Object)string4, (Object)string5);
            string2 = (String)pair.component1();
            string3 = (String)pair.component2();
            Object object = new char[]{','};
            object = StringsKt.split$default((CharSequence)string3, (char[])object, (boolean)false, (int)0, (int)6, null);
            boolean bl3 = false;
            char[] cArray = object;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            boolean bl4 = false;
            Iterator iterator = cArray.iterator();
            while (iterator.hasNext()) {
                ContentRange contentRange;
                Object t = iterator.next();
                String string6 = (String)t;
                Collection collection2 = collection;
                boolean bl5 = false;
                if (StringsKt.startsWith$default((String)string6, (String)"-", (boolean)false, (int)2, null)) {
                    contentRange = new ContentRange.Suffix(Long.parseLong(StringsKt.removePrefix((String)string6, (CharSequence)"-")));
                } else {
                    Pair pair2;
                    String string7 = string6;
                    String string8 = "-";
                    boolean bl6 = false;
                    int n2 = StringsKt.indexOf$default((CharSequence)string7, (String)string8, (int)0, (boolean)false, (int)6, null);
                    if (n2 == -1) {
                        boolean bl7 = false;
                        pair2 = TuplesKt.to((Object)"", (Object)"");
                    } else {
                        String string9 = string7.substring(0, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"");
                        String string10 = string7.substring(n2 + string8.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"");
                        pair2 = TuplesKt.to((Object)string9, (Object)string10);
                    }
                    Pair pair3 = pair2;
                    string7 = (String)pair3.component1();
                    string8 = (String)pair3.component2();
                    contentRange = ((CharSequence)string8).length() > 0 ? (ContentRange)new ContentRange.Bounded(Long.parseLong(string7), Long.parseLong(string8)) : (ContentRange)new ContentRange.TailFrom(Long.parseLong(string7));
                }
                collection2.add(contentRange);
            }
            List list = (List)collection;
            if (list.isEmpty() || ((CharSequence)string2).length() == 0) {
                return null;
            }
            object = new RangesSpecifier(string2, (List<? extends ContentRange>)list);
            return RangesSpecifier.isValid$default((RangesSpecifier)object, null, 1, null) ? object : null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static final List<LongRange> toLongRanges(List<? extends ContentRange> list, long l) {
        boolean bl;
        ContentRange contentRange;
        Intrinsics.checkNotNullParameter(list, (String)"");
        Iterable iterable = list;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl3 = false;
        for (Object t : iterable2) {
            LongRange longRange;
            contentRange = (ContentRange)t;
            Collection collection2 = collection;
            bl = false;
            ContentRange contentRange2 = contentRange;
            if (contentRange2 instanceof ContentRange.Bounded) {
                longRange = new LongRange(((ContentRange.Bounded)contentRange).getFrom(), kotlin.ranges.RangesKt.coerceAtMost((long)((ContentRange.Bounded)contentRange).getTo(), (long)(l - 1L)));
            } else if (contentRange2 instanceof ContentRange.TailFrom) {
                longRange = kotlin.ranges.RangesKt.until((long)((ContentRange.TailFrom)contentRange).getFrom(), (long)l);
            } else if (contentRange2 instanceof ContentRange.Suffix) {
                longRange = kotlin.ranges.RangesKt.until((long)kotlin.ranges.RangesKt.coerceAtLeast((long)(l - ((ContentRange.Suffix)contentRange).getLastCount()), (long)0L), (long)l);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection2.add(longRange);
        }
        iterable = (List)collection;
        bl2 = false;
        iterable2 = iterable;
        collection = new ArrayList();
        bl3 = false;
        for (Object t : iterable2) {
            contentRange = (LongRange)t;
            bl = false;
            if (contentRange.isEmpty()) continue;
            collection.add(t);
        }
        return (List)collection;
    }

    public static final List<LongRange> mergeRangesKeepOrder(List<LongRange> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Object[] objectArray = (Object[])list;
        boolean bl = false;
        objectArray = CollectionsKt.sortedWith((Iterable)objectArray, (Comparator)new Comparator(){

            public final int compare(T t, T t2) {
                LongRange longRange = (LongRange)t;
                boolean bl = false;
                Comparable comparable = Long.valueOf(longRange.getFirst());
                longRange = (LongRange)t2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(longRange.getFirst()));
            }
        });
        Object object = new ArrayList<LongRange>(list.size());
        boolean bl2 = false;
        ArrayList<LongRange> arrayList = object;
        for (Object t : objectArray) {
            LongRange longRange = (LongRange)t;
            ArrayList<LongRange> arrayList2 = arrayList;
            boolean bl3 = false;
            if (arrayList2.isEmpty()) {
                arrayList2.add(longRange);
            } else if (((LongRange)CollectionsKt.last((List)arrayList2)).getLast() < longRange.getFirst() - 1L) {
                arrayList2.add(longRange);
            } else {
                LongRange longRange2 = (LongRange)CollectionsKt.last((List)arrayList2);
                arrayList2.set(CollectionsKt.getLastIndex((List)arrayList2), new LongRange(longRange2.getFirst(), Math.max(longRange2.getLast(), longRange.getLast())));
            }
            arrayList = arrayList2;
        }
        ArrayList<LongRange> arrayList3 = arrayList;
        objectArray = new LongRange[list.size()];
        Iterator iterator = arrayList3.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"");
        object = iterator;
        block1: while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"");
            LongRange longRange = (LongRange)e;
            int n = ((Collection)list).size();
            for (int i = 0; i < n; ++i) {
                if (!io.ktor.util.RangesKt.contains((LongRange)longRange, (LongRange)list.get(i))) continue;
                objectArray[i] = longRange;
                continue block1;
            }
        }
        return ArraysKt.filterNotNull((Object[])objectArray);
    }
}

