/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.URLBuilderJvmKt;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLProtocol;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.http.UrlDecodedParametersBuilder;
import io.ktor.http.UrlDecodedParametersBuilderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b0\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 R2\u00020\u0001:\u0001RBm\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u0014\"\u0004\b\u001e\u0010\u001fR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R*\u0010\u0007\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00068\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R$\u0010+\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u0010\u0003\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010.\"\u0004\b2\u00100R$\u00103\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u0010\u001c\u001a\u0004\b4\u0010\u0014\"\u0004\b5\u0010\u001fR(\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010%\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\u0014\"\u0004\b7\u0010\u001fR$\u00108\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u0010\u001c\u001a\u0004\b9\u0010\u0014\"\u0004\b:\u0010\u001fR(\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010%\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\u0014\"\u0004\b<\u0010\u001fR\"\u0010=\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010\u001c\u001a\u0004\b>\u0010\u0014\"\u0004\b?\u0010\u001fR$\u0010\u000e\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010\u0014\"\u0004\bA\u0010\u001fR(\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00040\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010E\"\u0004\bI\u0010GR*\u0010K\u001a\u00020J2\u0006\u0010%\u001a\u00020J8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR$\u0010\r\u001a\u00020J2\u0006\u0010%\u001a\u00020J8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\r\u0010L\u001a\u0004\bQ\u0010N\u00a8\u0006S"}, d2={"Lio/ktor/http/URLBuilder;", "", "Lio/ktor/http/URLProtocol;", "protocol", "", "host", "", "port", "user", "password", "", "pathSegments", "Lio/ktor/http/Parameters;", "parameters", "fragment", "", "trailingQuery", "<init>", "(Lio/ktor/http/URLProtocol;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/util/List;Lio/ktor/http/Parameters;Ljava/lang/String;Z)V", "buildString", "()Ljava/lang/String;", "toString", "Lio/ktor/http/Url;", "build", "()Lio/ktor/http/Url;", "", "applyOrigin", "()V", "Ljava/lang/String;", "getHost", "setHost", "(Ljava/lang/String;)V", "Z", "getTrailingQuery", "()Z", "setTrailingQuery", "(Z)V", "value", "I", "getPort", "()I", "setPort", "(I)V", "protocolOrNull", "Lio/ktor/http/URLProtocol;", "getProtocolOrNull", "()Lio/ktor/http/URLProtocol;", "setProtocolOrNull", "(Lio/ktor/http/URLProtocol;)V", "getProtocol", "setProtocol", "encodedUser", "getEncodedUser", "setEncodedUser", "getUser", "setUser", "encodedPassword", "getEncodedPassword", "setEncodedPassword", "getPassword", "setPassword", "encodedFragment", "getEncodedFragment", "setEncodedFragment", "getFragment", "setFragment", "encodedPathSegments", "Ljava/util/List;", "getEncodedPathSegments", "()Ljava/util/List;", "setEncodedPathSegments", "(Ljava/util/List;)V", "getPathSegments", "setPathSegments", "Lio/ktor/http/ParametersBuilder;", "encodedParameters", "Lio/ktor/http/ParametersBuilder;", "getEncodedParameters", "()Lio/ktor/http/ParametersBuilder;", "setEncodedParameters", "(Lio/ktor/http/ParametersBuilder;)V", "getParameters", "Companion", "ktor-http"})
public final class URLBuilder {
    public static final Companion Companion = new Companion(null);
    private String host;
    private boolean trailingQuery;
    private int port;
    private URLProtocol protocolOrNull;
    private String encodedUser;
    private String encodedPassword;
    private String encodedFragment;
    private List<String> encodedPathSegments;
    private ParametersBuilder encodedParameters;
    private ParametersBuilder parameters;
    private static final Url originUrl = URLUtilsKt.Url(URLBuilderJvmKt.getOrigin(Companion));
    private static final int INITIAL_CAPACITY = 256;

    public URLBuilder(URLProtocol uRLProtocol, String string, int n, String string2, String string3, List<String> list, Parameters parameters, String string4, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"");
        this.host = string;
        this.trailingQuery = bl;
        this.port = n;
        this.protocolOrNull = uRLProtocol;
        String string5 = string2;
        this.encodedUser = string5 != null ? CodecsKt.encodeURLParameter$default(string5, false, 1, null) : null;
        String string6 = string3;
        this.encodedPassword = string6 != null ? CodecsKt.encodeURLParameter$default(string6, false, 1, null) : null;
        this.encodedFragment = CodecsKt.encodeURLQueryComponent$default(string4, false, false, null, 7, null);
        Iterable iterable = list;
        URLBuilder uRLBuilder = this;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl3 = false;
        for (Object t : iterable2) {
            String string7 = (String)t;
            Collection collection2 = collection;
            boolean bl4 = false;
            collection2.add(CodecsKt.encodeURLPathPart(string7));
        }
        uRLBuilder.encodedPathSegments = (List)collection;
        this.encodedParameters = UrlDecodedParametersBuilderKt.encodeParameters(parameters);
        this.parameters = new UrlDecodedParametersBuilder(this.encodedParameters);
    }

    public /* synthetic */ URLBuilder(URLProtocol uRLProtocol, String string, int n, String string2, String string3, List list, Parameters parameters, String string4, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            uRLProtocol = null;
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        if ((n2 & 0x10) != 0) {
            string3 = null;
        }
        if ((n2 & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x40) != 0) {
            parameters = Parameters.Companion.getEmpty();
        }
        if ((n2 & 0x80) != 0) {
            string4 = "";
        }
        if ((n2 & 0x100) != 0) {
            bl = false;
        }
        this(uRLProtocol, string, n, string2, string3, list, parameters, string4, bl);
    }

    public final String getHost() {
        return this.host;
    }

    public final void setHost(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.host = string;
    }

    public final boolean getTrailingQuery() {
        return this.trailingQuery;
    }

    public final void setTrailingQuery(boolean bl) {
        this.trailingQuery = bl;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        if (!(0 <= n ? n < 65536 : false)) {
            boolean bl = false;
            String string = "Port must be between 0 and 65535, or 0 if not set. Provided: " + n;
            throw new IllegalArgumentException(string.toString());
        }
        this.port = n;
    }

    public final URLProtocol getProtocolOrNull() {
        return this.protocolOrNull;
    }

    public final void setProtocolOrNull(URLProtocol uRLProtocol) {
        this.protocolOrNull = uRLProtocol;
    }

    public final URLProtocol getProtocol() {
        URLProtocol uRLProtocol = this.protocolOrNull;
        if (uRLProtocol == null) {
            uRLProtocol = URLProtocol.Companion.getHTTP();
        }
        return uRLProtocol;
    }

    public final void setProtocol(URLProtocol uRLProtocol) {
        Intrinsics.checkNotNullParameter((Object)uRLProtocol, (String)"");
        this.protocolOrNull = uRLProtocol;
    }

    public final String getEncodedUser() {
        return this.encodedUser;
    }

    public final void setEncodedUser(String string) {
        this.encodedUser = string;
    }

    public final String getUser() {
        String string = this.encodedUser;
        return string != null ? CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null) : null;
    }

    public final void setUser(String string) {
        String string2 = string;
        this.encodedUser = string2 != null ? CodecsKt.encodeURLParameter$default(string2, false, 1, null) : null;
    }

    public final String getEncodedPassword() {
        return this.encodedPassword;
    }

    public final void setEncodedPassword(String string) {
        this.encodedPassword = string;
    }

    public final String getPassword() {
        String string = this.encodedPassword;
        return string != null ? CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null) : null;
    }

    public final void setPassword(String string) {
        String string2 = string;
        this.encodedPassword = string2 != null ? CodecsKt.encodeURLParameter$default(string2, false, 1, null) : null;
    }

    public final String getEncodedFragment() {
        return this.encodedFragment;
    }

    public final void setEncodedFragment(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.encodedFragment = string;
    }

    public final String getFragment() {
        return CodecsKt.decodeURLQueryComponent$default(this.encodedFragment, 0, 0, false, null, 15, null);
    }

    public final void setFragment(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.encodedFragment = CodecsKt.encodeURLQueryComponent$default(string, false, false, null, 7, null);
    }

    public final List<String> getEncodedPathSegments() {
        return this.encodedPathSegments;
    }

    public final void setEncodedPathSegments(List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.encodedPathSegments = list;
    }

    public final List<String> getPathSegments() {
        Iterable iterable = this.encodedPathSegments;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            String string = (String)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null));
        }
        return (List)collection;
    }

    public final void setPathSegments(List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Iterable iterable = list;
        URLBuilder uRLBuilder = this;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            String string = (String)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(CodecsKt.encodeURLPathPart(string));
        }
        uRLBuilder.encodedPathSegments = (List)collection;
    }

    public final ParametersBuilder getEncodedParameters() {
        return this.encodedParameters;
    }

    public final void setEncodedParameters(ParametersBuilder parametersBuilder) {
        Intrinsics.checkNotNullParameter((Object)parametersBuilder, (String)"");
        this.encodedParameters = parametersBuilder;
        this.parameters = new UrlDecodedParametersBuilder(parametersBuilder);
    }

    public final ParametersBuilder getParameters() {
        return this.parameters;
    }

    public final String buildString() {
        this.applyOrigin();
        String string = ((StringBuilder)URLBuilderKt.access$appendTo(this, new StringBuilder(256))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public String toString() {
        String string = ((StringBuilder)URLBuilderKt.access$appendTo(this, new StringBuilder(256))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final Url build() {
        this.applyOrigin();
        return new Url(this.protocolOrNull, this.host, this.port, this.getPathSegments(), this.parameters.build(), this.getFragment(), this.getUser(), this.getPassword(), this.trailingQuery, this.buildString());
    }

    private final void applyOrigin() {
        if (((CharSequence)this.host).length() > 0 || Intrinsics.areEqual((Object)this.getProtocol().getName(), (Object)"file")) {
            return;
        }
        this.host = originUrl.getHost();
        if (this.protocolOrNull == null) {
            this.protocolOrNull = originUrl.getProtocolOrNull();
        }
        if (this.port == 0) {
            this.setPort(originUrl.getSpecifiedPort());
        }
    }

    public URLBuilder() {
        this(null, null, 0, null, null, null, null, null, false, 511, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/ktor/http/URLBuilder$Companion;", "", "<init>", "()V", "Lio/ktor/http/Url;", "originUrl", "Lio/ktor/http/Url;", "", "INITIAL_CAPACITY", "I", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

