/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLParserException;
import io.ktor.http.URLProtocol;
import io.ktor.util.CharsetKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u001a\u0019\u0010\u0003\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001b\u0010\u0005\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0004\u001a3\u0010\u000b\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a+\u0010\r\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u001a+\u0010\u000f\u001a\u00020\u0006*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a+\u0010\u0011\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000e\u001a+\u0010\u0012\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000e\u001a'\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a/\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a#\u0010\u0019\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0014\u001a\u0013\u0010\u001b\u001a\u00020\u001a*\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\" \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lio/ktor/http/URLBuilder;", "", "urlString", "takeFrom", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;)Lio/ktor/http/URLBuilder;", "takeFromUnsafe", "", "startIndex", "endIndex", "slashCount", "", "parseFile", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;III)V", "parseMailto", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;II)V", "parseQuery", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;II)I", "parseFragment", "fillHost", "findScheme", "(Ljava/lang/String;II)I", "", "char", "count", "(Ljava/lang/String;IIC)I", "indexOfColonInHostPort", "", "isLetter", "(C)Z", "", "ROOT_PATH", "Ljava/util/List;", "getROOT_PATH", "()Ljava/util/List;", "ktor-http"})
public final class URLParserKt {
    private static final List<String> ROOT_PATH = CollectionsKt.listOf((Object)"");

    public static final List<String> getROOT_PATH() {
        return ROOT_PATH;
    }

    public static final URLBuilder takeFrom(URLBuilder uRLBuilder, String string) {
        URLBuilder uRLBuilder2;
        Intrinsics.checkNotNullParameter((Object)uRLBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (StringsKt.isBlank((CharSequence)string)) {
            return uRLBuilder;
        }
        try {
            uRLBuilder2 = URLParserKt.takeFromUnsafe(uRLBuilder, string);
        }
        catch (Throwable throwable) {
            throw new URLParserException(string, throwable);
        }
        return uRLBuilder2;
    }

    public static final URLBuilder takeFromUnsafe(URLBuilder uRLBuilder, String string) {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        block22: {
            int n6;
            char c;
            int n7;
            block21: {
                Intrinsics.checkNotNullParameter((Object)uRLBuilder, (String)"");
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                CharSequence charSequence = string;
                boolean bl2 = false;
                n5 = charSequence.length();
                for (n7 = 0; n7 < n5; ++n7) {
                    n4 = charSequence.charAt(n7);
                    c = '\u0000';
                    if (!(!CharsKt.isWhitespace((char)n4))) continue;
                    n6 = n7;
                    break block21;
                }
                n6 = -1;
            }
            n3 = n6;
            CharSequence charSequence = string;
            n7 = 0;
            n5 = charSequence.length() + -1;
            if (0 <= n5) {
                do {
                    n4 = n5--;
                    c = charSequence.charAt(n4);
                    n2 = 0;
                    if (!(!CharsKt.isWhitespace((char)c))) continue;
                    n = n4;
                    break block22;
                } while (0 <= n5);
            }
            n = -1;
        }
        int n8 = n + 1;
        int n9 = URLParserKt.findScheme(string, n3, n8);
        if (n9 > 0) {
            String string2 = string.substring(n3, n3 + n9);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            String string3 = string2;
            uRLBuilder.setProtocol(URLProtocol.Companion.createOrDefault(string3));
            n3 += n9 + 1;
        }
        if (Intrinsics.areEqual((Object)uRLBuilder.getProtocol().getName(), (Object)"data")) {
            String string4 = string.substring(n3, n8);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
            uRLBuilder.setHost(string4);
            return uRLBuilder;
        }
        int n10 = URLParserKt.count(string, n3, n8, '/');
        n3 += n10;
        if (Intrinsics.areEqual((Object)uRLBuilder.getProtocol().getName(), (Object)"file")) {
            URLParserKt.parseFile(uRLBuilder, string, n3, n8, n10);
            return uRLBuilder;
        }
        if (Intrinsics.areEqual((Object)uRLBuilder.getProtocol().getName(), (Object)"mailto")) {
            if (!(n10 == 0)) {
                String string5 = "Failed requirement.";
                throw new IllegalArgumentException(string5.toString());
            }
            URLParserKt.parseMailto(uRLBuilder, string, n3, n8);
            return uRLBuilder;
        }
        if (Intrinsics.areEqual((Object)uRLBuilder.getProtocol().getName(), (Object)"about")) {
            if (!(n10 == 0)) {
                String string6 = "Failed requirement.";
                throw new IllegalArgumentException(string6.toString());
            }
            String string7 = string.substring(n3, n8);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"");
            uRLBuilder.setHost(string7);
            return uRLBuilder;
        }
        if (Intrinsics.areEqual((Object)uRLBuilder.getProtocol().getName(), (Object)"tel")) {
            if (!(n10 == 0)) {
                String string8 = "Failed requirement.";
                throw new IllegalArgumentException(string8.toString());
            }
            String string9 = string.substring(n3, n8);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"");
            uRLBuilder.setHost(string9);
            return uRLBuilder;
        }
        if (n10 >= 2) {
            while (true) {
                Integer n11 = StringsKt.indexOfAny$default((CharSequence)string, (char[])CharsetKt.toCharArray((String)"@/\\?#"), (int)n3, (boolean)false, (int)4, null);
                n2 = ((Number)n11).intValue();
                bl = false;
                Integer n12 = n2 > 0 ? n11 : null;
                int n13 = n5 = n12 != null ? n12 : n8;
                if (n5 >= n8 || string.charAt(n5) != '@') break;
                n4 = URLParserKt.indexOfColonInHostPort(string, n3, n5);
                if (n4 != -1) {
                    String string10 = string.substring(n3, n4);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"");
                    uRLBuilder.setEncodedUser(string10);
                    String string11 = string.substring(n4 + 1, n5);
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"");
                    uRLBuilder.setEncodedPassword(string11);
                } else {
                    String string12 = string.substring(n3, n5);
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"");
                    uRLBuilder.setEncodedUser(string12);
                }
                n3 = n5 + 1;
            }
            URLParserKt.fillHost(uRLBuilder, string, n3, n5);
            n3 = n5;
        }
        if (n3 >= n8) {
            uRLBuilder.setEncodedPathSegments(string.charAt(n8 - 1) == '/' ? ROOT_PATH : CollectionsKt.emptyList());
            return uRLBuilder;
        }
        uRLBuilder.setEncodedPathSegments(n10 == 0 ? CollectionsKt.dropLast(uRLBuilder.getEncodedPathSegments(), (int)1) : CollectionsKt.emptyList());
        Object object = StringsKt.indexOfAny$default((CharSequence)string, (char[])CharsetKt.toCharArray((String)"?#"), (int)n3, (boolean)false, (int)4, null);
        n2 = ((Number)object).intValue();
        bl = false;
        Object object2 = n2 > 0 ? object : null;
        int n14 = n5 = object2 != null ? (Integer)object2 : n8;
        if (n5 > n3) {
            List list;
            String string13 = string.substring(n3, n5);
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"");
            String string14 = string13;
            Object object3 = uRLBuilder.getEncodedPathSegments().size() == 1 && ((CharSequence)CollectionsKt.first(uRLBuilder.getEncodedPathSegments())).length() == 0 ? CollectionsKt.emptyList() : (object = uRLBuilder.getEncodedPathSegments());
            if (Intrinsics.areEqual((Object)string14, (Object)"/")) {
                list = ROOT_PATH;
            } else {
                char[] cArray = new char[]{'/'};
                list = StringsKt.split$default((CharSequence)string14, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            }
            List list2 = list;
            List list3 = CollectionsKt.plus((Collection)(n10 == 1 ? ROOT_PATH : CollectionsKt.emptyList()), (Iterable)list2);
            uRLBuilder.setEncodedPathSegments(CollectionsKt.plus((Collection)((Collection)object), (Iterable)list3));
            n3 = n5;
        }
        if (n3 < n8 && string.charAt(n3) == '?') {
            n3 = URLParserKt.parseQuery(uRLBuilder, string, n3, n8);
        }
        URLParserKt.parseFragment(uRLBuilder, string, n3, n8);
        return uRLBuilder;
    }

    private static final void parseFile(URLBuilder uRLBuilder, String string, int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                uRLBuilder.setHost("");
                String string2 = string.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                URLBuilderKt.setEncodedPath(uRLBuilder, string2);
                break;
            }
            case 2: {
                int n4 = StringsKt.indexOf$default((CharSequence)string, (char)'/', (int)n, (boolean)false, (int)4, null);
                if (n4 == -1 || n4 == n2) {
                    String string3 = string.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                    uRLBuilder.setHost(string3);
                    return;
                }
                String string4 = string.substring(n, n4);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                uRLBuilder.setHost(string4);
                String string5 = string.substring(n4, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
                URLBuilderKt.setEncodedPath(uRLBuilder, string5);
                break;
            }
            case 3: {
                uRLBuilder.setHost("");
                StringBuilder stringBuilder = new StringBuilder().append('/');
                String string6 = string.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
                URLBuilderKt.setEncodedPath(uRLBuilder, stringBuilder.append(string6).toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid file url: " + string);
            }
        }
    }

    private static final void parseMailto(URLBuilder uRLBuilder, String string, int n, int n2) {
        int n3 = StringsKt.indexOf$default((CharSequence)string, (String)"@", (int)n, (boolean)false, (int)4, null);
        if (n3 == -1) {
            throw new IllegalArgumentException("Invalid mailto url: " + string + ", it should contain '@'.");
        }
        String string2 = string.substring(n, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        uRLBuilder.setUser(CodecsKt.decodeURLPart$default(string2, 0, 0, null, 7, null));
        String string3 = string.substring(n3 + 1, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        uRLBuilder.setHost(string3);
    }

    private static final int parseQuery(URLBuilder uRLBuilder, String string, int n, int n2) {
        if (n + 1 == n2) {
            uRLBuilder.setTrailingQuery(true);
            return n2;
        }
        Integer n3 = StringsKt.indexOf$default((CharSequence)string, (char)'#', (int)(n + 1), (boolean)false, (int)4, null);
        int n4 = ((Number)n3).intValue();
        boolean bl = false;
        Integer n5 = n4 > 0 ? n3 : null;
        int n6 = n5 != null ? n5 : n2;
        String string2 = string.substring(n + 1, n6);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        Parameters parameters = QueryKt.parseQueryString$default(string2, 0, 0, false, 6, null);
        parameters.forEach((arg_0, arg_1) -> URLParserKt.parseQuery$lambda$1(uRLBuilder, arg_0, arg_1));
        return n6;
    }

    private static final void parseFragment(URLBuilder uRLBuilder, String string, int n, int n2) {
        if (n < n2 && string.charAt(n) == '#') {
            String string2 = string.substring(n + 1, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            uRLBuilder.setEncodedFragment(string2);
        }
    }

    private static final void fillHost(URLBuilder uRLBuilder, String string, int n, int n2) {
        int n3;
        Integer n4 = URLParserKt.indexOfColonInHostPort(string, n, n2);
        int n5 = ((Number)n4).intValue();
        boolean bl = false;
        Integer n6 = n5 > 0 ? n4 : null;
        int n7 = n6 != null ? n6 : n2;
        String string2 = string.substring(n, n7);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        uRLBuilder.setHost(string2);
        if (n7 + 1 < n2) {
            String string3 = string.substring(n7 + 1, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            n3 = Integer.parseInt(string3);
        } else {
            n3 = 0;
        }
        uRLBuilder.setPort(n3);
    }

    private static final int findScheme(String string, int n, int n2) {
        int n3 = n;
        int n4 = -1;
        char c = string.charAt(n3);
        if (!('a' <= c ? c < '{' : false)) {
            if (!('A' <= c ? c < '[' : false)) {
                n4 = n3;
            }
        }
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == ':') {
                if (n4 != -1) {
                    throw new IllegalArgumentException("Illegal character in scheme at position " + n4);
                }
                return n3 - n;
            }
            switch (c2) {
                case '#': 
                case '/': 
                case '?': {
                    return -1;
                }
            }
            if (n4 == -1) {
                if (!('a' <= c2 ? c2 < '{' : false)) {
                    if (!('A' <= c2 ? c2 < '[' : false)) {
                        if (!('0' <= c2 ? c2 < ':' : false) && c2 != '.' && c2 != '+' && c2 != '-') {
                            n4 = n3;
                        }
                    }
                }
            }
            ++n3;
        }
        return -1;
    }

    private static final int count(String string, int n, int n2, char c) {
        int n3 = 0;
        while (n + n3 < n2 && string.charAt(n + n3) == c) {
            ++n3;
        }
        return n3;
    }

    private static final int indexOfColonInHostPort(String string, int n, int n2) {
        boolean bl = false;
        block5: for (int i = n; i < n2; ++i) {
            switch (string.charAt(i)) {
                case '[': {
                    bl = true;
                    continue block5;
                }
                case ']': {
                    bl = false;
                    continue block5;
                }
                case ':': {
                    if (bl) continue block5;
                    return i;
                }
            }
        }
        return -1;
    }

    private static final boolean isLetter(char c) {
        char c2 = Character.toLowerCase(c);
        return 'a' <= c2 ? c2 < '{' : false;
    }

    private static final Unit parseQuery$lambda$1(URLBuilder uRLBuilder, String string, List list) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)list, (String)"");
        uRLBuilder.getEncodedParameters().appendAll(string, list);
        return Unit.INSTANCE;
    }
}

