/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ApplicationResponsePropertiesKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.Version;
import io.ktor.http.content.VersionCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u001b\u0010\u0013\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u000e\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011\u00a2\u0006\u0004\b\u000e\u0010\u0014J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ$\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u001f\u0010 J\u001a\u0010\"\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010!H\u00d6\u0003\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010%\u001a\u00020$H\u00d6\u0001\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b'\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010(\u001a\u0004\b)\u0010\u001cR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010*\u001a\u0004\b+\u0010\u001eR\u0014\u0010,\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010(R\u0014\u0010-\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010(\u00a8\u0006/"}, d2={"Lio/ktor/http/content/EntityTagVersion;", "Lio/ktor/http/content/Version;", "", "etag", "", "weak", "<init>", "(Ljava/lang/String;Z)V", "Lio/ktor/http/Headers;", "requestHeaders", "Lio/ktor/http/content/VersionCheckResult;", "check", "(Lio/ktor/http/Headers;)Lio/ktor/http/content/VersionCheckResult;", "other", "match", "(Lio/ktor/http/content/EntityTagVersion;)Z", "weakMatch", "", "givenNoneMatchEtags", "noneMatch", "(Ljava/util/List;)Lio/ktor/http/content/VersionCheckResult;", "givenMatchEtags", "Lio/ktor/http/HeadersBuilder;", "builder", "", "appendHeadersTo", "(Lio/ktor/http/HeadersBuilder;)V", "component1", "()Ljava/lang/String;", "component2", "()Z", "copy", "(Ljava/lang/String;Z)Lio/ktor/http/content/EntityTagVersion;", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getEtag", "Z", "getWeak", "opaque", "normalized", "Companion", "ktor-http"})
public final class EntityTagVersion
implements Version {
    public static final Companion Companion = new Companion(null);
    private final String etag;
    private final boolean weak;
    private final String opaque;
    private final String normalized;
    private static final EntityTagVersion STAR = new EntityTagVersion("*", false);

    public EntityTagVersion(String string, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.etag = string;
        this.weak = bl;
        this.opaque = Intrinsics.areEqual((Object)this.etag, (Object)"*") ? this.etag : (StringsKt.startsWith$default((String)this.etag, (String)"\"", (boolean)false, (int)2, null) ? this.etag : HeaderValueWithParametersKt.quote(this.etag));
        this.normalized = this.weak ? "W/" + this.opaque : this.opaque;
        if (!(!this.weak || !Intrinsics.areEqual((Object)this.etag, (Object)EntityTagVersion.STAR.etag))) {
            boolean bl2 = false;
            String string2 = "Entity tag '*' could not be weak.";
            throw new IllegalArgumentException(string2.toString());
        }
        int n = ((CharSequence)this.etag).length();
        for (int j = 0; j < n; ++j) {
            char c = this.etag.charAt(j);
            if (Intrinsics.compare((int)c, (int)32) > 0 && c != '\"' || j == 0 || j == StringsKt.getLastIndex((CharSequence)this.etag)) continue;
            boolean bl3 = false;
            String string3 = "Character '" + c + "' is not allowed in entity-tag.";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    public final String getEtag() {
        return this.etag;
    }

    public final boolean getWeak() {
        return this.weak;
    }

    @Override
    public VersionCheckResult check(Headers headers) {
        Object object;
        boolean bl;
        VersionCheckResult versionCheckResult;
        boolean bl2;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"");
        Object object3 = headers.get(HttpHeaders.INSTANCE.getIfNoneMatch());
        if (object3 != null) {
            object2 = object3;
            bl2 = false;
            List<EntityTagVersion> list = Companion.parse((String)object2);
            object3 = list;
            if (list != null) {
                object2 = object3;
                bl2 = false;
                versionCheckResult = this.noneMatch((List<EntityTagVersion>)object2);
                bl = false;
                if (versionCheckResult != VersionCheckResult.OK) {
                    return versionCheckResult;
                }
            }
        }
        if ((object = headers.get(HttpHeaders.INSTANCE.getIfMatch())) != null) {
            object2 = object;
            bl2 = false;
            List<EntityTagVersion> list = Companion.parse((String)object2);
            object = list;
            if (list != null) {
                object2 = object;
                bl2 = false;
                versionCheckResult = this.match((List<EntityTagVersion>)object2);
                bl = false;
                if (versionCheckResult != VersionCheckResult.OK) {
                    return versionCheckResult;
                }
            }
        }
        return VersionCheckResult.OK;
    }

    public final boolean match(EntityTagVersion entityTagVersion) {
        Intrinsics.checkNotNullParameter((Object)entityTagVersion, (String)"");
        if (this.weak || entityTagVersion.weak) {
            return false;
        }
        return this.weakMatch(entityTagVersion);
    }

    private final boolean weakMatch(EntityTagVersion entityTagVersion) {
        if (Intrinsics.areEqual((Object)this, (Object)STAR) || Intrinsics.areEqual((Object)entityTagVersion, (Object)STAR)) {
            return true;
        }
        return Intrinsics.areEqual((Object)this.opaque, (Object)entityTagVersion.opaque);
    }

    public final VersionCheckResult noneMatch(List<EntityTagVersion> list) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(list, (String)"");
            if (list.contains(STAR)) {
                return VersionCheckResult.OK;
            }
            Iterable iterable = list;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    EntityTagVersion entityTagVersion = (EntityTagVersion)t;
                    boolean bl3 = false;
                    if (!this.weakMatch(entityTagVersion)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return VersionCheckResult.NOT_MODIFIED;
        }
        return VersionCheckResult.OK;
    }

    public final VersionCheckResult match(List<EntityTagVersion> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        if (list.isEmpty()) {
            return VersionCheckResult.OK;
        }
        if (list.contains(STAR)) {
            return VersionCheckResult.OK;
        }
        for (EntityTagVersion entityTagVersion : list) {
            if (!this.match(entityTagVersion)) continue;
            return VersionCheckResult.OK;
        }
        return VersionCheckResult.PRECONDITION_FAILED;
    }

    @Override
    public void appendHeadersTo(HeadersBuilder headersBuilder) {
        Intrinsics.checkNotNullParameter((Object)((Object)headersBuilder), (String)"");
        ApplicationResponsePropertiesKt.etag(headersBuilder, this.normalized);
    }

    public final String component1() {
        return this.etag;
    }

    public final boolean component2() {
        return this.weak;
    }

    public final EntityTagVersion copy(String string, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return new EntityTagVersion(string, bl);
    }

    public static /* synthetic */ EntityTagVersion copy$default(EntityTagVersion entityTagVersion, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = entityTagVersion.etag;
        }
        if ((n & 2) != 0) {
            bl = entityTagVersion.weak;
        }
        return entityTagVersion.copy(string, bl);
    }

    public String toString() {
        return "EntityTagVersion(etag=" + this.etag + ", weak=" + this.weak + ')';
    }

    public int hashCode() {
        int n = this.etag.hashCode();
        n = n * 31 + Boolean.hashCode(this.weak);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EntityTagVersion)) {
            return false;
        }
        EntityTagVersion entityTagVersion = (EntityTagVersion)object;
        if (!Intrinsics.areEqual((Object)this.etag, (Object)entityTagVersion.etag)) {
            return false;
        }
        return this.weak == entityTagVersion.weak;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lio/ktor/http/content/EntityTagVersion$Companion;", "", "<init>", "()V", "", "headerValue", "", "Lio/ktor/http/content/EntityTagVersion;", "parse", "(Ljava/lang/String;)Ljava/util/List;", "value", "parseSingle", "(Ljava/lang/String;)Lio/ktor/http/content/EntityTagVersion;", "STAR", "Lio/ktor/http/content/EntityTagVersion;", "getSTAR", "()Lio/ktor/http/content/EntityTagVersion;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        public final EntityTagVersion getSTAR() {
            return STAR;
        }

        public final List<EntityTagVersion> parse(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            List<HeaderValue> list = HttpHeaderValueParserKt.parseHeaderValue(string);
            Iterable iterable = list;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                HeaderValue headerValue = (HeaderValue)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                if (!(headerValue.getQuality() == 1.0)) {
                    boolean bl4 = false;
                    String string2 = "entity-tag quality parameter is not allowed: " + headerValue.getQuality() + '.';
                    throw new IllegalStateException(string2.toString());
                }
                if (!headerValue.getParams().isEmpty()) {
                    boolean bl5 = false;
                    String string3 = "entity-tag parameters are not allowed: " + headerValue.getParams() + '.';
                    throw new IllegalStateException(string3.toString());
                }
                collection2.add(Companion.parseSingle(headerValue.getValue()));
            }
            return (List)collection;
        }

        public final EntityTagVersion parseSingle(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            if (Intrinsics.areEqual((Object)string, (Object)"*")) {
                return this.getSTAR();
            }
            boolean bl = false;
            String string2 = null;
            if (StringsKt.startsWith$default((String)string, (String)"W/", (boolean)false, (int)2, null)) {
                bl = true;
                string2 = StringsKt.drop((String)string, (int)2);
            } else {
                bl = false;
                string2 = string;
            }
            String string3 = StringsKt.startsWith$default((String)string2, (String)"\"", (boolean)false, (int)2, null) ? string2 : HeaderValueWithParametersKt.quote(string2);
            return new EntityTagVersion(string3, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

