/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Actuals_jvmKt;
import org.jetbrains.skia.FourByteTag;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u0012\u001a\u00020\tH\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/skia/FontVariation;", "", "_tag", "", "value", "", "<init>", "(IF)V", "feature", "", "(Ljava/lang/String;F)V", "get_tag", "()I", "getValue", "()F", "tag", "getTag", "()Ljava/lang/String;", "toString", "equals", "", "other", "hashCode", "Companion", "skiko"})
public final class FontVariation {
    public static final Companion Companion = new Companion(null);
    private final int _tag;
    private final float value;
    private static final FontVariation[] EMPTY = new FontVariation[0];
    private static final Pattern _splitPattern = Actuals_jvmKt.compilePattern("\\s+");
    private static final Pattern _variationPattern = Actuals_jvmKt.compilePattern("([a-z0-9]{4})=(\\d+)");
    private static final int tagIx = 1;
    private static final int valueIx = 2;

    public FontVariation(int n, float f) {
        this._tag = n;
        this.value = f;
    }

    public final int get_tag() {
        return this._tag;
    }

    public final float getValue() {
        return this.value;
    }

    public FontVariation(String string, float f) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this(FourByteTag.Companion.fromString(string), f);
    }

    public final String getTag() {
        return FourByteTag.Companion.toString(this._tag);
    }

    public String toString() {
        return this.getTag() + '=' + this.value;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontVariation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTag(), (Object)((FontVariation)object).getTag())) {
            return false;
        }
        return Float.compare(this.value, ((FontVariation)object).value) == 0;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * n + this._tag;
        n2 = n2 * n + Float.floatToIntBits(this.value);
        return n2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0019\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u001aR\u001b\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00060\fj\u0002`\u000bX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00060\fj\u0002`\u000bX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/skia/FontVariation$Companion;", "", "<init>", "()V", "EMPTY", "", "Lorg/jetbrains/skia/FontVariation;", "getEMPTY", "()[Lorg/jetbrains/skia/FontVariation;", "[Lorg/jetbrains/skia/FontVariation;", "_splitPattern", "Lorg/jetbrains/skia/Pattern;", "Ljava/util/regex/Pattern;", "get_splitPattern$skiko", "()Ljava/util/regex/Pattern;", "Ljava/util/regex/Pattern;", "_variationPattern", "get_variationPattern$skiko", "tagIx", "", "valueIx", "parseOne", "s", "", "parse", "str", "(Ljava/lang/String;)[Lorg/jetbrains/skia/FontVariation;", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public final FontVariation[] getEMPTY() {
            return EMPTY;
        }

        public final Pattern get_splitPattern$skiko() {
            return _splitPattern;
        }

        public final Pattern get_variationPattern$skiko() {
            return _variationPattern;
        }

        public final FontVariation parseOne(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Matcher matcher = this.get_variationPattern$skiko().matcher(string);
            if (!matcher.matches()) {
                boolean bl = false;
                String string2 = "Can\u2019t parse FontVariation: " + string;
                throw new IllegalArgumentException(string2.toString());
            }
            String string3 = matcher.group(2);
            Intrinsics.checkNotNull((Object)string3);
            float f = Float.parseFloat(string3);
            String string4 = matcher.group(1);
            Intrinsics.checkNotNull((Object)string4);
            String string5 = string4;
            return new FontVariation(string5, f);
        }

        public final FontVariation[] parse(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Object object = this.get_splitPattern$skiko().split(string);
            boolean bl = false;
            String[] stringArray = object;
            Collection collection = new ArrayList(((String[])object).length);
            boolean bl2 = false;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String string3 = string2 = stringArray[i];
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(Companion.parseOne(string3));
            }
            object = (List)collection;
            bl = false;
            stringArray = object;
            return stringArray.toArray(new FontVariation[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

