/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorInfo;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.Native;
import org.jetbrains.skia.impl.NativePointerArray;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 E2\u00020\u0001:\u0001EB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0007\u0010\rB3\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0007\u0010\u0010B5\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\n\u0010\u000e\u001a\u00060\u0012j\u0002`\u0011\u00a2\u0006\u0004\b\u0007\u0010\u0013J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010.\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u00103\u001a\u00020&2\u0006\u00104\u001a\u00020\u0012J\u001e\u00105\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0012J\u000e\u00108\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0005J\u0006\u00109\u001a\u00020\u0005J\u0013\u0010:\u001a\u00020&2\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010<\u001a\u00020\u0005H\u0016J\b\u0010=\u001a\u00020>H\u0016J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0003J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u0005J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0011\u0010(\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010'R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010'R\u0011\u0010/\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0017R\u0011\u00101\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0017\u00a8\u0006F"}, d2={"Lorg/jetbrains/skia/ImageInfo;", "", "colorInfo", "Lorg/jetbrains/skia/ColorInfo;", "width", "", "height", "<init>", "(Lorg/jetbrains/skia/ColorInfo;II)V", "colorType", "Lorg/jetbrains/skia/ColorType;", "alphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "(IILorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;)V", "colorSpace", "Lorg/jetbrains/skia/ColorSpace;", "(IILorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;Lorg/jetbrains/skia/ColorSpace;)V", "Lorg/jetbrains/skia/impl/NativePointer;", "", "(IIIIJ)V", "getColorInfo", "()Lorg/jetbrains/skia/ColorInfo;", "getWidth", "()I", "getHeight", "minRowBytes", "getMinRowBytes", "getColorType", "()Lorg/jetbrains/skia/ColorType;", "withColorType", "colorAlphaType", "getColorAlphaType", "()Lorg/jetbrains/skia/ColorAlphaType;", "withColorAlphaType", "getColorSpace", "()Lorg/jetbrains/skia/ColorSpace;", "withColorSpace", "isEmpty", "", "()Z", "isOpaque", "bounds", "Lorg/jetbrains/skia/IRect;", "getBounds", "()Lorg/jetbrains/skia/IRect;", "isGammaCloseToSRGB", "withWidthHeight", "bytesPerPixel", "getBytesPerPixel", "shiftPerPixel", "getShiftPerPixel", "isRowBytesValid", "rowBytes", "computeOffset", "x", "y", "computeByteSize", "computeMinByteSize", "equals", "other", "hashCode", "toString", "", "withColorInfo", "_colorInfo", "withWidth", "_width", "withHeight", "_height", "Companion", "skiko"})
public final class ImageInfo {
    public static final Companion Companion = new Companion(null);
    private final ColorInfo colorInfo;
    private final int width;
    private final int height;
    private static final ImageInfo DEFAULT = new ImageInfo(ColorInfo.Companion.getDEFAULT(), 0, 0);

    public ImageInfo(ColorInfo colorInfo, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)colorInfo, (String)"");
        this.colorInfo = colorInfo;
        this.width = n;
        this.height = n2;
    }

    public final ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public ImageInfo(int n, int n2, ColorType colorType, ColorAlphaType colorAlphaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
        this(new ColorInfo(colorType, colorAlphaType, null), n, n2);
    }

    public ImageInfo(int n, int n2, ColorType colorType, ColorAlphaType colorAlphaType, ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
        this(new ColorInfo(colorType, colorAlphaType, colorSpace), n, n2);
    }

    public ImageInfo(int n, int n2, int n3, int n4, long l) {
        this(n, n2, ColorType.values()[n3], ColorAlphaType.values()[n4], l == Native.Companion.getNullPointer() ? null : new ColorSpace(l));
    }

    public final int getMinRowBytes() {
        return this.width * this.getBytesPerPixel();
    }

    public final ColorType getColorType() {
        return this.colorInfo.getColorType();
    }

    public final ImageInfo withColorType(ColorType colorType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"");
        return this.withColorInfo(this.colorInfo.withColorType(colorType));
    }

    public final ColorAlphaType getColorAlphaType() {
        return this.colorInfo.getAlphaType();
    }

    public final ImageInfo withColorAlphaType(ColorAlphaType colorAlphaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
        return this.withColorInfo(this.colorInfo.withAlphaType(colorAlphaType));
    }

    public final ColorSpace getColorSpace() {
        return this.colorInfo.getColorSpace();
    }

    public final ImageInfo withColorSpace(ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"");
        return this.withColorInfo(this.colorInfo.withColorSpace(colorSpace));
    }

    public final boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public final boolean isOpaque() {
        return this.colorInfo.isOpaque();
    }

    public final IRect getBounds() {
        return IRect.Companion.makeXYWH(0, 0, this.width, this.height);
    }

    public final boolean isGammaCloseToSRGB() {
        return this.colorInfo.isGammaCloseToSRGB();
    }

    public final ImageInfo withWidthHeight(int n, int n2) {
        return new ImageInfo(this.colorInfo, n, n2);
    }

    public final int getBytesPerPixel() {
        return this.colorInfo.getBytesPerPixel();
    }

    public final int getShiftPerPixel() {
        return this.colorInfo.getShiftPerPixel();
    }

    public final boolean isRowBytesValid(long l) {
        if (l < (long)this.getMinRowBytes()) {
            return false;
        }
        int n = this.getShiftPerPixel();
        return l >> n << n == l;
    }

    public final long computeOffset(int n, int n2, long l) {
        return this.colorInfo.getColorType().computeOffset(n, n2, l);
    }

    public final int computeByteSize(int n) {
        return this.height == 0 ? 0 : (this.height - 1) * n + this.width * this.getBytesPerPixel();
    }

    public final int computeMinByteSize() {
        return this.computeByteSize(this.getMinRowBytes());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImageInfo)) {
            return false;
        }
        if (this.width != ((ImageInfo)object).width) {
            return false;
        }
        if (this.height != ((ImageInfo)object).height) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorInfo, (Object)((ImageInfo)object).colorInfo);
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * n + this.width;
        n2 = n2 * n + this.height;
        n2 = n2 * n + this.colorInfo.hashCode();
        return n2;
    }

    public String toString() {
        return "ImageInfo(_colorInfo=" + this.colorInfo + ", _width=" + this.width + ", _height=" + this.height + ')';
    }

    public final ImageInfo withColorInfo(ColorInfo colorInfo) {
        Intrinsics.checkNotNullParameter((Object)colorInfo, (String)"");
        return this.colorInfo == colorInfo ? this : new ImageInfo(colorInfo, this.width, this.height);
    }

    public final ImageInfo withWidth(int n) {
        return this.width == n ? this : new ImageInfo(this.colorInfo, n, this.height);
    }

    public final ImageInfo withHeight(int n) {
        return this.height == n ? this : new ImageInfo(this.colorInfo, this.width, n);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ(\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ \u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u00a3\u0001\u0010\u0014\u001a\u00020\u00052\n\u0010\u0015\u001a\u00060\u0017j\u0002`\u00162\u0085\u0001\u0010\u0018\u001a\u0080\u0001\u0012&\u0012$0\u0017j\u0011`\u0016\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0015\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0015\u0012&\u0012$0\u001ej\u0011`\u001c\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012&\u0012$0\u001ej\u0011`\u001c\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u0019H\u0000\u00a2\u0006\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lorg/jetbrains/skia/ImageInfo$Companion;", "", "<init>", "()V", "DEFAULT", "Lorg/jetbrains/skia/ImageInfo;", "getDEFAULT", "()Lorg/jetbrains/skia/ImageInfo;", "makeN32", "width", "", "height", "alphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "colorSpace", "Lorg/jetbrains/skia/ColorSpace;", "makeS32", "makeN32Premul", "makeA8", "makeUnknown", "createUsing", "_ptr", "Lorg/jetbrains/skia/impl/NativePointer;", "", "_nGetImageInfo", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/skia/impl/InteropPointer;", "intArrayPointer", "Ljava/lang/Object;", "nativePointerArrayPtr", "", "createUsing$skiko", "(JLkotlin/jvm/functions/Function3;)Lorg/jetbrains/skia/ImageInfo;", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public final ImageInfo getDEFAULT() {
            return DEFAULT;
        }

        public final ImageInfo makeN32(int n, int n2, ColorAlphaType colorAlphaType) {
            Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), colorAlphaType, null), n, n2);
        }

        public final ImageInfo makeN32(int n, int n2, ColorAlphaType colorAlphaType, ColorSpace colorSpace) {
            Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), colorAlphaType, colorSpace), n, n2);
        }

        public final ImageInfo makeS32(int n, int n2, ColorAlphaType colorAlphaType) {
            Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), colorAlphaType, ColorSpace.Companion.getSRGB()), n, n2);
        }

        public final ImageInfo makeN32Premul(int n, int n2) {
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), ColorAlphaType.PREMUL, null), n, n2);
        }

        public final ImageInfo makeN32Premul(int n, int n2, ColorSpace colorSpace) {
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), ColorAlphaType.PREMUL, colorSpace), n, n2);
        }

        public final ImageInfo makeA8(int n, int n2) {
            return new ImageInfo(new ColorInfo(ColorType.ALPHA_8, ColorAlphaType.PREMUL, null), n, n2);
        }

        public final ImageInfo makeUnknown(int n, int n2) {
            return new ImageInfo(new ColorInfo(ColorType.UNKNOWN, ColorAlphaType.UNKNOWN, null), n, n2);
        }

        public final ImageInfo createUsing$skiko(long l, Function3<? super Long, ? super Object, ? super Object, Unit> function3) {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter(function3, (String)"");
            Stats.INSTANCE.onNativeCall();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            int[] nArray = new int[4];
            boolean bl = false;
            boolean bl2 = false;
            InteropScope interopScope = theScope.INSTANCE;
            boolean bl3 = false;
            Object object3 = object2 = interopScope.toInteropForResult(nArray);
            InteropScope interopScope2 = interopScope;
            boolean bl4 = false;
            NativePointerArray nativePointerArray = new NativePointerArray(1);
            boolean bl5 = false;
            boolean bl6 = false;
            InteropScope interopScope3 = theScope.INSTANCE;
            boolean bl7 = false;
            Object object4 = object = interopScope3.toInteropForResult(nativePointerArray);
            InteropScope interopScope4 = interopScope3;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl8 = false;
            function3.invoke((Object)l, object3, object4);
            interopScope3.fromInterop(object, nativePointerArray);
            objectRef2.element = nativePointerArray.get(0);
            interopScope.fromInterop(object2, nArray);
            int[] nArray2 = nArray;
            bl2 = false;
            int n = nArray2[0];
            int n2 = nArray2[1];
            int n3 = nArray2[2];
            int n4 = nArray2[3];
            Object object5 = objectRef.element;
            Intrinsics.checkNotNull((Object)object5);
            return new ImageInfo(n, n2, n3, n4, ((Number)object5).longValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

