/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.HardwareLayer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/skiko/FullscreenAdapter;", "Ljava/awt/event/ComponentAdapter;", "backedLayer", "Lorg/jetbrains/skiko/HardwareLayer;", "<init>", "(Lorg/jetbrains/skiko/HardwareLayer;)V", "getBackedLayer", "()Lorg/jetbrains/skiko/HardwareLayer;", "localFullscreen", "", "isWindowShown", "value", "fullscreen", "getFullscreen", "()Z", "setFullscreen", "(Z)V", "componentShown", "", "e", "Ljava/awt/event/ComponentEvent;", "componentHidden", "componentResized", "skiko"})
public final class FullscreenAdapter
extends ComponentAdapter {
    private final HardwareLayer backedLayer;
    private boolean localFullscreen;
    private boolean isWindowShown;

    public FullscreenAdapter(HardwareLayer hardwareLayer) {
        Intrinsics.checkNotNullParameter((Object)hardwareLayer, (String)"");
        this.backedLayer = hardwareLayer;
    }

    public final HardwareLayer getBackedLayer() {
        return this.backedLayer;
    }

    public final boolean getFullscreen() {
        return this.isWindowShown ? this.backedLayer.getFullscreen() : this.localFullscreen;
    }

    public final void setFullscreen(boolean bl) {
        this.localFullscreen = bl;
        if (this.isWindowShown) {
            this.backedLayer.setFullscreen(bl);
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        Intrinsics.checkNotNullParameter((Object)componentEvent, (String)"");
        this.isWindowShown = true;
        this.backedLayer.setFullscreen(this.localFullscreen);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.isWindowShown = false;
        this.localFullscreen = this.backedLayer.getFullscreen();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Intrinsics.checkNotNullParameter((Object)componentEvent, (String)"");
        if (this.isWindowShown) {
            this.localFullscreen = this.backedLayer.getFullscreen();
        }
    }
}

