/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skiko.AWTKt;
import org.jetbrains.skiko.AngleApi;
import org.jetbrains.skiko.AngleSupport_jvmKt;
import org.jetbrains.skiko.FPSCounter;
import org.jetbrains.skiko.FrameDispatcher;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.GraphicsApi_jvmKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.MainUIDispatcher_awtKt;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoProperties;
import org.jetbrains.skiko.context.AngleContextHandler;
import org.jetbrains.skiko.redrawer.AWTRedrawer;
import org.jetbrains.skiko.redrawer.AngleRedrawerKt;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001eH\u0002J\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u00020\u00138BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006*"}, d2={"Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "Lorg/jetbrains/skiko/redrawer/AWTRedrawer;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/SkiaLayerProperties;)V", "contextHandler", "Lorg/jetbrains/skiko/context/AngleContextHandler;", "renderInfo", "", "getRenderInfo", "()Ljava/lang/String;", "drawLock", "", "device", "", "getDevice", "()J", "frameDispatcher", "Lorg/jetbrains/skiko/FrameDispatcher;", "adapterName", "getAdapterName", "dispose", "", "needRender", "throttledToVsync", "", "renderImmediately", "draw", "drawAndSwap", "withVsync", "makeContext", "Lorg/jetbrains/skia/DirectContext;", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "width", "", "height", "skiko"})
public final class AngleRedrawer
extends AWTRedrawer {
    private final SkiaLayer layer;
    private final SkiaLayerProperties properties;
    private final AngleContextHandler contextHandler;
    private Object drawLock;
    private long device;
    private final FrameDispatcher frameDispatcher;

    public AngleRedrawer(SkiaLayer skiaLayer, SkiaLayerAnalytics skiaLayerAnalytics, SkiaLayerProperties skiaLayerProperties) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerProperties, (String)"");
        super(skiaLayer, skiaLayerAnalytics, GraphicsApi.ANGLE);
        this.layer = skiaLayer;
        this.properties = skiaLayerProperties;
        AngleSupport_jvmKt.loadAngleLibrary();
        this.contextHandler = new AngleContextHandler(this.layer);
        this.drawLock = new Object();
        this.frameDispatcher = new FrameDispatcher((CoroutineContext)MainUIDispatcher_awtKt.getMainUIDispatcher(), (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AngleRedrawer this$0;
            {
                this.this$0 = angleRedrawer;
                super(2, continuation);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (AngleRedrawer.access$getLayer$p(this.this$0).isShowing()) {
                            this.this$0.update(System.nanoTime());
                            AngleRedrawer.access$draw(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.device = ((Number)AWTKt.useDrawingSurfacePlatformInfo(this.layer.getBackedLayer$skiko(), arg_0 -> AngleRedrawer._init_$lambda$1(this, arg_0))).longValue();
        String string = this.getAdapterName();
        boolean bl = false;
        if (string != null && !GraphicsApi_jvmKt.isVideoCardSupported(GraphicsApi.ANGLE, OsArch_jvmKt.getHostOs(), string)) {
            throw new RenderException("Cannot create ANGLE redrawer.", null, 2, null);
        }
        this.onDeviceChosen(string);
        this.onContextInit();
    }

    @Override
    public String getRenderInfo() {
        return this.contextHandler.rendererInfo();
    }

    private final long getDevice() {
        if (this.device == 0L) {
            throw new RenderException("ANGLE device is not initialized or already disposed", null, 2, null);
        }
        return this.device;
    }

    private final String getAdapterName() {
        return AngleApi.INSTANCE.glGetString(AngleApi.INSTANCE.getGL_RENDERER());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.drawLock;
        synchronized (object) {
            boolean bl = false;
            this.frameDispatcher.cancel();
            AngleRedrawerKt.access$makeCurrent(this.getDevice());
            this.contextHandler.dispose();
            AngleRedrawerKt.access$disposeDevice(this.getDevice());
            this.device = 0L;
            super.dispose();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void needRender(boolean bl) {
        this.checkDisposed();
        this.frameDispatcher.scheduleFrame();
    }

    @Override
    public void renderImmediately() {
        block16: {
            boolean bl;
            AWTRedrawer aWTRedrawer;
            block15: {
                this.checkDisposed();
                Redrawer.DefaultImpls.update$default(this, 0L, 1, null);
                aWTRedrawer = this;
                boolean bl2 = false;
                if (AWTRedrawer.access$getDeviceAnalytics$p(aWTRedrawer) == null) {
                    boolean bl3 = false;
                    String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                    throw new IllegalArgumentException(string.toString());
                }
                if (AWTRedrawer.access$isDisposed(aWTRedrawer)) break block16;
                bl = !AWTRedrawer.access$isFirstFrameRendered$p(aWTRedrawer);
                AWTRedrawer.access$setFirstFrameRendered$p(aWTRedrawer, true);
                if (bl) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(aWTRedrawer);
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(aWTRedrawer);
                if (deviceAnalytics != null) {
                    deviceAnalytics.beforeFrameRender();
                }
                SkiaLayer skiaLayer = AWTRedrawer.access$getLayer$p(aWTRedrawer);
                boolean bl4 = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    boolean bl5 = false;
                    String string = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException(string.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(skiaLayer))) {
                    boolean bl6 = false;
                    String string = "SkiaLayer is disposed";
                    throw new IllegalStateException(string.toString());
                }
                try {
                    FPSCounter fPSCounter = SkiaLayer.access$getFpsCounter$p(skiaLayer);
                    if (fPSCounter != null) {
                        fPSCounter.tick();
                    }
                    boolean bl7 = false;
                    if (this.isDisposed()) break block15;
                    this.drawAndSwap(SkikoProperties.INSTANCE.getWindowsWaitForVsyncOnRedrawImmediately());
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException renderException) {
                    if (SkiaLayer.access$isDisposed$p(skiaLayer)) break block15;
                    Logger logger = Logger.INSTANCE;
                    boolean bl8 = false;
                    if (logger.getLoggerImpl().isWarnEnabled()) {
                        Throwable throwable = renderException;
                        SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                        boolean bl9 = false;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface.warn(throwable, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(skiaLayer), false, 1, null);
                    Redrawer redrawer = skiaLayer.getRedrawer$skiko();
                    if (redrawer != null) {
                        redrawer.renderImmediately();
                    }
                }
            }
            if (bl && !AWTRedrawer.access$isDisposed(aWTRedrawer)) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(aWTRedrawer);
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(aWTRedrawer);
            if (deviceAnalytics != null) {
                deviceAnalytics.afterFrameRender();
            }
        }
    }

    private final void draw() {
        block16: {
            boolean bl;
            AWTRedrawer aWTRedrawer;
            block15: {
                aWTRedrawer = this;
                boolean bl2 = false;
                if (AWTRedrawer.access$getDeviceAnalytics$p(aWTRedrawer) == null) {
                    boolean bl3 = false;
                    String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                    throw new IllegalArgumentException(string.toString());
                }
                if (AWTRedrawer.access$isDisposed(aWTRedrawer)) break block16;
                bl = !AWTRedrawer.access$isFirstFrameRendered$p(aWTRedrawer);
                AWTRedrawer.access$setFirstFrameRendered$p(aWTRedrawer, true);
                if (bl) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(aWTRedrawer);
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(aWTRedrawer);
                if (deviceAnalytics != null) {
                    deviceAnalytics.beforeFrameRender();
                }
                SkiaLayer skiaLayer = AWTRedrawer.access$getLayer$p(aWTRedrawer);
                boolean bl4 = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    boolean bl5 = false;
                    String string = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException(string.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(skiaLayer))) {
                    boolean bl6 = false;
                    String string = "SkiaLayer is disposed";
                    throw new IllegalStateException(string.toString());
                }
                try {
                    FPSCounter fPSCounter = SkiaLayer.access$getFpsCounter$p(skiaLayer);
                    if (fPSCounter != null) {
                        fPSCounter.tick();
                    }
                    boolean bl7 = false;
                    this.drawAndSwap(this.properties.isVsyncEnabled());
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException renderException) {
                    if (SkiaLayer.access$isDisposed$p(skiaLayer)) break block15;
                    Logger logger = Logger.INSTANCE;
                    boolean bl8 = false;
                    if (logger.getLoggerImpl().isWarnEnabled()) {
                        Throwable throwable = renderException;
                        SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                        boolean bl9 = false;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface.warn(throwable, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(skiaLayer), false, 1, null);
                    Redrawer redrawer = skiaLayer.getRedrawer$skiko();
                    if (redrawer != null) {
                        redrawer.renderImmediately();
                    }
                }
            }
            if (bl && !AWTRedrawer.access$isDisposed(aWTRedrawer)) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(aWTRedrawer);
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(aWTRedrawer);
            if (deviceAnalytics != null) {
                deviceAnalytics.afterFrameRender();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void drawAndSwap(boolean bl) {
        Object object = this.drawLock;
        synchronized (object) {
            boolean bl2 = false;
            if (this.isDisposed()) {
                return;
            }
            AngleRedrawerKt.access$makeCurrent(this.getDevice());
            this.contextHandler.draw();
            AngleRedrawerKt.access$swapBuffers(this.getDevice(), bl);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final DirectContext makeContext() {
        Long l = AngleRedrawerKt.access$makeAngleContext(this.getDevice());
        long l2 = ((Number)l).longValue();
        boolean bl = false;
        Long l3 = l2 != 0L ? l : null;
        if (l3 == null) {
            throw new RenderException("Failed to make GL context.", null, 2, null);
        }
        long l4 = l3;
        return new DirectContext(l4);
    }

    public final BackendRenderTarget makeRenderTarget(int n2, int n3) {
        Long l = AngleRedrawerKt.access$makeAngleRenderTarget(this.getDevice(), n2, n3);
        long l2 = ((Number)l).longValue();
        boolean bl = false;
        Long l3 = l2 != 0L ? l : null;
        if (l3 == null) {
            throw new RenderException("Failed to make ANGLE render target.", null, 2, null);
        }
        long l4 = l3;
        return new BackendRenderTarget(l4);
    }

    private static final long _init_$lambda$1(AngleRedrawer angleRedrawer, long l) {
        Intrinsics.checkNotNullParameter((Object)angleRedrawer, (String)"");
        Long l2 = AngleRedrawerKt.access$createAngleDevice(l, angleRedrawer.layer.getTransparency());
        long l3 = ((Number)l2).longValue();
        boolean bl = false;
        Long l4 = l3 != 0L ? l2 : null;
        if (l4 == null) {
            throw new RenderException("Failed to create ANGLE device.", null, 2, null);
        }
        return l4;
    }

    public static final /* synthetic */ SkiaLayer access$getLayer$p(AngleRedrawer angleRedrawer) {
        return angleRedrawer.layer;
    }

    public static final /* synthetic */ void access$draw(AngleRedrawer angleRedrawer) {
        angleRedrawer.draw();
    }
}

