/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002Ba\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00128\u0010\u0005\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001b\u001a\u00020\r2\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\rR@\u0010\u0005\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0004\u0018\u00018\u00002\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R$\u0010\t\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "R", "", "defaultRenderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "redrawerFactory", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "renderApi", "oldRedrawer", "onRenderApiChanged", "Lkotlin/Function1;", "", "<init>", "(Lorg/jetbrains/skiko/GraphicsApi;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "fallbackRenderApiQueue", "", "value", "redrawer", "getRedrawer", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "setRenderApi", "(Lorg/jetbrains/skiko/GraphicsApi;)V", "findNextWorkingRenderApi", "recreation", "", "dispose", "skiko"})
public final class RedrawerManager<R> {
    private final Function2<GraphicsApi, R, R> redrawerFactory;
    private final Function1<GraphicsApi, Unit> onRenderApiChanged;
    private final List<GraphicsApi> fallbackRenderApiQueue;
    private R redrawer;
    private GraphicsApi renderApi;

    public RedrawerManager(GraphicsApi graphicsApi, Function2<? super GraphicsApi, ? super R, ? extends R> function2, Function1<? super GraphicsApi, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
        Intrinsics.checkNotNullParameter(function2, (String)"");
        this.redrawerFactory = function2;
        this.onRenderApiChanged = function1;
        this.fallbackRenderApiQueue = CollectionsKt.toMutableList((Collection)SkikoProperties.INSTANCE.fallbackRenderApiQueue$skiko(graphicsApi));
        this.renderApi = this.fallbackRenderApiQueue.get(0);
    }

    public /* synthetic */ RedrawerManager(GraphicsApi graphicsApi, Function2 function2, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        this(graphicsApi, function2, (Function1<? super GraphicsApi, Unit>)function1);
    }

    public final R getRedrawer() {
        return this.redrawer;
    }

    public final GraphicsApi getRenderApi() {
        return this.renderApi;
    }

    public final void setRenderApi(GraphicsApi graphicsApi) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
            this.renderApi = graphicsApi;
            Function1<GraphicsApi, Unit> function1 = this.onRenderApiChanged;
            if (function1 == null) break block0;
            function1.invoke((Object)graphicsApi);
        }
    }

    public final void findNextWorkingRenderApi(boolean bl) {
        if (bl) {
            this.fallbackRenderApiQueue.add(0, this.renderApi);
        }
        boolean bl2 = false;
        do {
            bl2 = false;
            try {
                this.setRenderApi(this.fallbackRenderApiQueue.remove(0));
                this.redrawer = this.redrawerFactory.invoke((Object)this.renderApi, this.redrawer);
            }
            catch (RenderException renderException) {
                this.redrawer = null;
                Logger logger = Logger.INSTANCE;
                boolean bl3 = false;
                if (logger.getLoggerImpl().isWarnEnabled()) {
                    Throwable throwable = renderException;
                    SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                    boolean bl4 = false;
                    String string = "Fallback to next API";
                    skikoLoggerInterface.warn(throwable, string);
                }
                bl2 = true;
            }
        } while (bl2 && !((Collection)this.fallbackRenderApiQueue).isEmpty());
        if (bl2) {
            throw new RenderException("Cannot fallback to any render API", null, 2, null);
        }
    }

    public static /* synthetic */ void findNextWorkingRenderApi$default(RedrawerManager redrawerManager, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        redrawerManager.findNextWorkingRenderApi(bl);
    }

    public final void dispose() {
        this.redrawer = null;
    }
}

