/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import com.jetbrains.JBR;
import com.jetbrains.SharedTextures;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Surface;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.swing.SwingPainter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/skiko/swing/AcceleratedSwingPainter;", "Lorg/jetbrains/skiko/swing/SwingPainter;", "<init>", "()V", "sharedTextures", "Lcom/jetbrains/SharedTextures;", "kotlin.jvm.PlatformType", "Lcom/jetbrains/SharedTextures;", "imageWrapper", "Ljava/awt/Image;", "texturePtr", "", "gc", "Ljava/awt/GraphicsConfiguration;", "paint", "", "g", "Ljava/awt/Graphics2D;", "surface", "Lorg/jetbrains/skia/Surface;", "texture", "dispose", "skiko"})
public final class AcceleratedSwingPainter
implements SwingPainter {
    private final SharedTextures sharedTextures;
    private Image imageWrapper;
    private long texturePtr;
    private GraphicsConfiguration gc;

    public AcceleratedSwingPainter() {
        if (!JBR.isSharedTexturesSupported() || JBR.getSharedTextures().getTextureType() != 1) {
            throw new RenderException("Shared textures are not supported", null, 2, null);
        }
        this.sharedTextures = JBR.getSharedTextures();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"");
        this.gc = graphicsConfiguration;
    }

    @Override
    public void paint(Graphics2D graphics2D, Surface surface, long l) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"");
        if (!Intrinsics.areEqual((Object)graphics2D.getDeviceConfiguration(), (Object)this.gc) || this.texturePtr != l || this.imageWrapper == null) {
            this.gc = graphics2D.getDeviceConfiguration();
            this.texturePtr = l;
            this.imageWrapper = this.sharedTextures.wrapTexture(this.gc, this.texturePtr);
        }
        graphics2D.drawImage(this.imageWrapper, 0, 0, null);
    }

    @Override
    public void dispose() {
    }
}

