/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.graphicapi.InternalDirectXApi;
import org.jetbrains.skiko.swing.SoftwareSwingPainter;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingPainter;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000bH\u0014J\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00060\u000bj\u0002`\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/skiko/swing/Direct3DSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "adapter", "", "device", "Lorg/jetbrains/skia/impl/NativePointer;", "J", "painter", "Lorg/jetbrains/skiko/swing/SwingPainter;", "context", "Lorg/jetbrains/skia/DirectContext;", "texturePtr", "bytesToDraw", "", "dispose", "", "onRender", "g", "Ljava/awt/Graphics2D;", "width", "", "height", "nanoTime", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "Companion", "skiko"})
public final class Direct3DSwingRedrawer
extends SwingRedrawerBase {
    public static final Companion Companion = new Companion(null);
    private final SkikoRenderDelegate renderDelegate;
    private final long adapter;
    private final long device;
    private final SwingPainter painter;
    private final DirectContext context;
    private long texturePtr;
    private byte[] bytesToDraw;

    public Direct3DSwingRedrawer(SwingLayerProperties swingLayerProperties2, SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics) {
        long l;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        Intrinsics.checkNotNullParameter((Object)skikoRenderDelegate, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        super(swingLayerProperties2, skiaLayerAnalytics, GraphicsApi.DIRECT3D);
        this.renderDelegate = skikoRenderDelegate;
        long l2 = l = InternalDirectXApi.INSTANCE.chooseAdapter(swingLayerProperties2.getAdapterPriority());
        Direct3DSwingRedrawer direct3DSwingRedrawer = this;
        boolean bl = false;
        this.onDeviceChosen("DirectX12");
        direct3DSwingRedrawer.adapter = l;
        this.device = InternalDirectXApi.INSTANCE.createDirectXOffscreenDevice(this.adapter);
        this.painter = new SoftwareSwingPainter(swingLayerProperties2);
        if (this.device == 0L) {
            throw new RenderException("Failed to create DirectX12 device.", null, 2, null);
        }
        this.context = new DirectContext(InternalDirectXApi.INSTANCE.makeDirectXContext(this.device));
        this.bytesToDraw = new byte[0];
        this.onContextInit(this.context);
    }

    @Override
    public void dispose() {
        this.bytesToDraw = new byte[0];
        this.context.close();
        InternalDirectXApi.INSTANCE.disposeDirectXTexture(this.texturePtr);
        InternalDirectXApi.INSTANCE.disposeDevice(this.device);
        this.painter.dispose();
        super.dispose();
    }

    @Override
    protected void onRender(Graphics2D graphics2D, int n2, int n3, long l) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)arg_0 -> Direct3DSwingRedrawer.onRender$lambda$1(n2, this, n3, l, graphics2D, arg_0)));
    }

    public final void flush(Surface surface, Graphics2D graphics2D) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"");
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        surface.flushAndSubmit(false);
        InternalDirectXApi.INSTANCE.waitForCompletion(this.device, this.texturePtr);
        this.painter.paint(graphics2D, surface, this.texturePtr);
    }

    private final BackendRenderTarget makeRenderTarget() {
        return new BackendRenderTarget(InternalDirectXApi.INSTANCE.makeDirectXRenderTargetOffScreen(this.texturePtr));
    }

    private static final Unit onRender$lambda$1(int n2, Direct3DSwingRedrawer direct3DSwingRedrawer, int n3, long l, Graphics2D graphics2D, CloseScope closeScope) {
        Surface surface;
        Intrinsics.checkNotNullParameter((Object)direct3DSwingRedrawer, (String)"");
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        Intrinsics.checkNotNullParameter((Object)closeScope, (String)"");
        int n4 = InternalDirectXApi.INSTANCE.alignedTextureWidth(n2);
        direct3DSwingRedrawer.texturePtr = InternalDirectXApi.INSTANCE.makeDirectXTexture(direct3DSwingRedrawer.device, direct3DSwingRedrawer.texturePtr, n4, n3);
        if (direct3DSwingRedrawer.texturePtr == 0L) {
            throw new RenderException("Can't allocate DirectX resources", null, 2, null);
        }
        BackendRenderTarget backendRenderTarget = (BackendRenderTarget)closeScope.autoClose((AutoCloseable)direct3DSwingRedrawer.makeRenderTarget());
        Managed managed = Surface.Companion.makeFromBackendRenderTarget(direct3DSwingRedrawer.context, backendRenderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
        if (managed == null || (surface = (Surface)closeScope.autoClose((AutoCloseable)managed)) == null) {
            throw new RenderException("Cannot create surface", null, 2, null);
        }
        Surface surface2 = surface;
        managed = surface2.getCanvas();
        ((Canvas)managed).clear(0);
        direct3DSwingRedrawer.renderDelegate.onRender((Canvas)managed, n2, n3, l);
        direct3DSwingRedrawer.flush(surface2, graphics2D);
        return Unit.INSTANCE;
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/skiko/swing/Direct3DSwingRedrawer$Companion;", "", "<init>", "()V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

