/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.Surface;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.SoftwareSwingPainter;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingPainter;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/skiko/swing/SoftwareSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "painter", "Lorg/jetbrains/skiko/swing/SwingPainter;", "storage", "Lorg/jetbrains/skia/Bitmap;", "dispose", "", "onRender", "g", "Ljava/awt/Graphics2D;", "width", "", "height", "nanoTime", "", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "skiko"})
public final class SoftwareSwingRedrawer
extends SwingRedrawerBase {
    private final SkikoRenderDelegate renderDelegate;
    private final SwingPainter painter;
    private final Bitmap storage;

    public SoftwareSwingRedrawer(SwingLayerProperties swingLayerProperties2, SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics) {
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        Intrinsics.checkNotNullParameter((Object)skikoRenderDelegate, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        super(swingLayerProperties2, skiaLayerAnalytics, GraphicsApi.SOFTWARE_FAST);
        this.renderDelegate = skikoRenderDelegate;
        this.onDeviceChosen("Software");
        this.painter = new SoftwareSwingPainter(swingLayerProperties2);
        this.storage = new Bitmap();
        this.onContextInit(null);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.storage.close();
        this.painter.dispose();
    }

    @Override
    protected void onRender(Graphics2D graphics2D, int n2, int n3, long l) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)arg_0 -> SoftwareSwingRedrawer.onRender$lambda$0(this, n2, n3, l, graphics2D, arg_0)));
    }

    private final void flush(Graphics2D graphics2D, Surface surface) {
        ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)arg_0 -> SoftwareSwingRedrawer.flush$lambda$1(this, graphics2D, surface, arg_0)));
    }

    private static final Unit onRender$lambda$0(SoftwareSwingRedrawer softwareSwingRedrawer, int n2, int n3, long l, Graphics2D graphics2D, CloseScope closeScope) {
        Intrinsics.checkNotNullParameter((Object)softwareSwingRedrawer, (String)"");
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        Intrinsics.checkNotNullParameter((Object)closeScope, (String)"");
        if (softwareSwingRedrawer.storage.getWidth() != n2 || softwareSwingRedrawer.storage.getHeight() != n3) {
            softwareSwingRedrawer.storage.allocPixelsFlags(ImageInfo.Companion.makeS32(n2, n3, ColorAlphaType.PREMUL), false);
        }
        Pixmap pixmap = softwareSwingRedrawer.storage.peekPixels();
        Long l2 = pixmap != null ? Long.valueOf(pixmap.getAddr()) : null;
        Intrinsics.checkNotNull((Object)l2);
        long l3 = l2;
        Surface surface = (Surface)closeScope.autoClose((AutoCloseable)Surface.Companion.makeRasterDirect(softwareSwingRedrawer.storage.getImageInfo(), l3, softwareSwingRedrawer.storage.getRowBytes()));
        surface.getCanvas().clear(0);
        softwareSwingRedrawer.renderDelegate.onRender(surface.getCanvas(), n2, n3, l);
        softwareSwingRedrawer.flush(graphics2D, surface);
        return Unit.INSTANCE;
    }

    private static final Unit flush$lambda$1(SoftwareSwingRedrawer softwareSwingRedrawer, Graphics2D graphics2D, Surface surface, CloseScope closeScope) {
        Intrinsics.checkNotNullParameter((Object)softwareSwingRedrawer, (String)"");
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"");
        Intrinsics.checkNotNullParameter((Object)closeScope, (String)"");
        softwareSwingRedrawer.painter.paint(graphics2D, surface, 0L);
        return Unit.INSTANCE;
    }
}

