/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.channel.unix.GenericUnixChannelOption;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;

public final class RawUnixChannelOption
extends GenericUnixChannelOption<ByteBuffer> {
    private final int length;

    public RawUnixChannelOption(String string, int n, int n2, int n3) {
        super(string, n, n2);
        this.length = ObjectUtil.checkPositive((int)n3, (String)"length");
    }

    public int length() {
        return this.length;
    }

    public void validate(ByteBuffer byteBuffer) {
        super.validate((Object)byteBuffer);
        if (byteBuffer.remaining() != this.length) {
            throw new IllegalArgumentException("Length of value does not match. Expected " + this.length + ", but got " + byteBuffer.remaining());
        }
    }
}

