/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;

public class SegmentedDatagramPacket
extends DatagramPacket {
    private final int segmentSize;

    public SegmentedDatagramPacket(ByteBuf byteBuf, int n, InetSocketAddress inetSocketAddress) {
        super(byteBuf, inetSocketAddress);
        this.segmentSize = ObjectUtil.checkPositive((int)n, (String)"segmentSize");
    }

    public SegmentedDatagramPacket(ByteBuf byteBuf, int n, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        super(byteBuf, inetSocketAddress, inetSocketAddress2);
        this.segmentSize = ObjectUtil.checkPositive((int)n, (String)"segmentSize");
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public SegmentedDatagramPacket copy() {
        return new SegmentedDatagramPacket(((ByteBuf)this.content()).copy(), this.segmentSize, (InetSocketAddress)this.recipient(), (InetSocketAddress)this.sender());
    }

    public SegmentedDatagramPacket duplicate() {
        return new SegmentedDatagramPacket(((ByteBuf)this.content()).duplicate(), this.segmentSize, (InetSocketAddress)this.recipient(), (InetSocketAddress)this.sender());
    }

    public SegmentedDatagramPacket retainedDuplicate() {
        return new SegmentedDatagramPacket(((ByteBuf)this.content()).retainedDuplicate(), this.segmentSize, (InetSocketAddress)this.recipient(), (InetSocketAddress)this.sender());
    }

    public SegmentedDatagramPacket replace(ByteBuf byteBuf) {
        return new SegmentedDatagramPacket(byteBuf, this.segmentSize, (InetSocketAddress)this.recipient(), (InetSocketAddress)this.sender());
    }

    public SegmentedDatagramPacket retain() {
        super.retain();
        return this;
    }

    public SegmentedDatagramPacket retain(int n) {
        super.retain(n);
        return this;
    }

    public SegmentedDatagramPacket touch() {
        super.touch();
        return this;
    }

    public SegmentedDatagramPacket touch(Object object) {
        super.touch(object);
        return this;
    }
}

