/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.lazy.layout.LazyLayoutItemProviderKt;
import androidx.compose.foundation.lazy.layout.LazyLayoutNearestRangeState;
import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PagerLazyLayoutItemProvider;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.PrimitiveSnapshotStateKt;
import androidx.compose.runtime.SnapshotIntStateKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0005J\u0016\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020\u0003J\u0018\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0005H\u0002J\u000e\u0010,\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0005J\u000e\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020\u0003R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR+\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00038F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00058F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006/"}, d2={"Landroidx/compose/foundation/pager/PagerScrollPosition;", "", "currentPage", "", "currentPageOffsetFraction", "", "state", "Landroidx/compose/foundation/pager/PagerState;", "<init>", "(IFLandroidx/compose/foundation/pager/PagerState;)V", "getState", "()Landroidx/compose/foundation/pager/PagerState;", "<set-?>", "getCurrentPage", "()I", "setCurrentPage", "(I)V", "currentPage$delegate", "Landroidx/compose/runtime/MutableIntState;", "getCurrentPageOffsetFraction", "()F", "setCurrentPageOffsetFraction", "(F)V", "currentPageOffsetFraction$delegate", "Landroidx/compose/runtime/MutableFloatState;", "hadFirstNotEmptyLayout", "", "lastKnownCurrentPageKey", "nearestRangeState", "Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "getNearestRangeState", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "updateFromMeasureResult", "", "measureResult", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "requestPositionAndForgetLastKnownKey", "index", "offsetFraction", "matchPageWithKey", "itemProvider", "Landroidx/compose/foundation/pager/PagerLazyLayoutItemProvider;", "update", "page", "updateCurrentPageOffsetFraction", "applyScrollDelta", "delta", "foundation"})
public final class PagerScrollPosition {
    private final PagerState state;
    private final MutableIntState currentPage$delegate;
    private final MutableFloatState currentPageOffsetFraction$delegate;
    private boolean hadFirstNotEmptyLayout;
    private Object lastKnownCurrentPageKey;
    private final LazyLayoutNearestRangeState nearestRangeState;
    public static final int $stable = 8;

    public PagerScrollPosition(int n2, float f2, PagerState pagerState) {
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"");
        this.state = pagerState;
        this.currentPage$delegate = SnapshotIntStateKt.mutableIntStateOf((int)n2);
        this.currentPageOffsetFraction$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf((float)f2);
        this.nearestRangeState = new LazyLayoutNearestRangeState(n2, 30, 100);
    }

    public /* synthetic */ PagerScrollPosition(int n2, float f2, PagerState pagerState, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n2 = 0;
        }
        if ((n3 & 2) != 0) {
            f2 = 0.0f;
        }
        this(n2, f2, pagerState);
    }

    public final PagerState getState() {
        return this.state;
    }

    public final int getCurrentPage() {
        IntState intState = (IntState)this.currentPage$delegate;
        PagerScrollPosition pagerScrollPosition = this;
        Object var3_3 = null;
        boolean bl = false;
        return intState.getIntValue();
    }

    private final void setCurrentPage(int n2) {
        MutableIntState mutableIntState = this.currentPage$delegate;
        PagerScrollPosition pagerScrollPosition = this;
        Object var4_4 = null;
        int n3 = n2;
        boolean bl = false;
        mutableIntState.setIntValue(n3);
    }

    public final float getCurrentPageOffsetFraction() {
        FloatState floatState = (FloatState)this.currentPageOffsetFraction$delegate;
        PagerScrollPosition pagerScrollPosition = this;
        Object var3_3 = null;
        boolean bl = false;
        return floatState.getFloatValue();
    }

    private final void setCurrentPageOffsetFraction(float f2) {
        MutableFloatState mutableFloatState = this.currentPageOffsetFraction$delegate;
        PagerScrollPosition pagerScrollPosition = this;
        Object var4_4 = null;
        float f3 = f2;
        boolean bl = false;
        mutableFloatState.setFloatValue(f3);
    }

    public final LazyLayoutNearestRangeState getNearestRangeState() {
        return this.nearestRangeState;
    }

    public final void updateFromMeasureResult(PagerMeasureResult pagerMeasureResult) {
        Intrinsics.checkNotNullParameter((Object)pagerMeasureResult, (String)"");
        MeasuredPage measuredPage = pagerMeasureResult.getCurrentPage();
        Object object = this.lastKnownCurrentPageKey = measuredPage != null ? measuredPage.getKey() : null;
        if (this.hadFirstNotEmptyLayout || !((Collection)pagerMeasureResult.getVisiblePagesInfo()).isEmpty()) {
            this.hadFirstNotEmptyLayout = true;
            MeasuredPage measuredPage2 = pagerMeasureResult.getCurrentPage();
            this.update(measuredPage2 != null ? measuredPage2.getIndex() : 0, pagerMeasureResult.getCurrentPageOffsetFraction());
        }
    }

    public final void requestPositionAndForgetLastKnownKey(int n2, float f2) {
        this.update(n2, f2);
        this.lastKnownCurrentPageKey = null;
    }

    public final int matchPageWithKey(PagerLazyLayoutItemProvider pagerLazyLayoutItemProvider, int n2) {
        Intrinsics.checkNotNullParameter((Object)pagerLazyLayoutItemProvider, (String)"");
        int n3 = LazyLayoutItemProviderKt.findIndexByKey(pagerLazyLayoutItemProvider, this.lastKnownCurrentPageKey, n2);
        if (n2 != n3) {
            this.setCurrentPage(n3);
            this.nearestRangeState.update(n2);
        }
        return n3;
    }

    private final void update(int n2, float f2) {
        this.setCurrentPage(n2);
        this.nearestRangeState.update(n2);
        this.setCurrentPageOffsetFraction(f2);
    }

    public final void updateCurrentPageOffsetFraction(float f2) {
        this.setCurrentPageOffsetFraction(f2);
    }

    public final void applyScrollDelta(int n2) {
        boolean bl = false;
        float f2 = this.state.getPageSizeWithSpacing$foundation() == 0 ? 0.0f : (float)n2 / (float)this.state.getPageSizeWithSpacing$foundation();
        this.setCurrentPageOffsetFraction(this.getCurrentPageOffsetFraction() + f2);
    }
}

