/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001a\u001a\u0004\b\u001c\u0010\nR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b\u001e\u0010\r\u00a8\u0006\u001f"}, d2={"Lio/ktor/network/tls/EncryptionInfo;", "", "Ljava/security/PublicKey;", "serverPublic", "clientPublic", "Ljava/security/PrivateKey;", "clientPrivate", "<init>", "(Ljava/security/PublicKey;Ljava/security/PublicKey;Ljava/security/PrivateKey;)V", "component1", "()Ljava/security/PublicKey;", "component2", "component3", "()Ljava/security/PrivateKey;", "copy", "(Ljava/security/PublicKey;Ljava/security/PublicKey;Ljava/security/PrivateKey;)Lio/ktor/network/tls/EncryptionInfo;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/security/PublicKey;", "getServerPublic", "getClientPublic", "Ljava/security/PrivateKey;", "getClientPrivate", "ktor-network-tls"})
public final class EncryptionInfo {
    private final PublicKey serverPublic;
    private final PublicKey clientPublic;
    private final PrivateKey clientPrivate;

    public EncryptionInfo(PublicKey publicKey, PublicKey publicKey2, PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"");
        Intrinsics.checkNotNullParameter((Object)publicKey2, (String)"");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"");
        this.serverPublic = publicKey;
        this.clientPublic = publicKey2;
        this.clientPrivate = privateKey;
    }

    public final PublicKey getServerPublic() {
        return this.serverPublic;
    }

    public final PublicKey getClientPublic() {
        return this.clientPublic;
    }

    public final PrivateKey getClientPrivate() {
        return this.clientPrivate;
    }

    public final PublicKey component1() {
        return this.serverPublic;
    }

    public final PublicKey component2() {
        return this.clientPublic;
    }

    public final PrivateKey component3() {
        return this.clientPrivate;
    }

    public final EncryptionInfo copy(PublicKey publicKey, PublicKey publicKey2, PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"");
        Intrinsics.checkNotNullParameter((Object)publicKey2, (String)"");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"");
        return new EncryptionInfo(publicKey, publicKey2, privateKey);
    }

    public static /* synthetic */ EncryptionInfo copy$default(EncryptionInfo encryptionInfo, PublicKey publicKey, PublicKey publicKey2, PrivateKey privateKey, int n, Object object) {
        if ((n & 1) != 0) {
            publicKey = encryptionInfo.serverPublic;
        }
        if ((n & 2) != 0) {
            publicKey2 = encryptionInfo.clientPublic;
        }
        if ((n & 4) != 0) {
            privateKey = encryptionInfo.clientPrivate;
        }
        return encryptionInfo.copy(publicKey, publicKey2, privateKey);
    }

    public String toString() {
        return "EncryptionInfo(serverPublic=" + this.serverPublic + ", clientPublic=" + this.clientPublic + ", clientPrivate=" + this.clientPrivate + ')';
    }

    public int hashCode() {
        int n = this.serverPublic.hashCode();
        n = n * 31 + this.clientPublic.hashCode();
        n = n * 31 + this.clientPrivate.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EncryptionInfo)) {
            return false;
        }
        EncryptionInfo encryptionInfo = (EncryptionInfo)object;
        if (!Intrinsics.areEqual((Object)this.serverPublic, (Object)encryptionInfo.serverPublic)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientPublic, (Object)encryptionInfo.clientPublic)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.clientPrivate, (Object)encryptionInfo.clientPrivate);
    }
}

