/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList;

import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.PersistentList;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.ObjectRef;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.SmallPersistentVector;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.CommonFunctionsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.ListImplementation;
import java.util.Arrays;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010*\n\u0002\b\t\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B7\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0010\u001a\u00020\tH\u0002J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013JC\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u0017J?\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0010\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\t2\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ5\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001e\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u001fJG\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u001b\u001a\u00020\tH\u0016J;\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010&J3\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010(J?\u0010)\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010*\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010+J=\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010*\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010+J\"\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002000/H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00028\u000002H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00028\u0000042\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u001d\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u00106J\u0016\u00107\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u00108J#\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ?\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\b\u0010;\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010<R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "E", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/AbstractPersistentList;", "root", "", "", "tail", "size", "", "rootShift", "<init>", "([Ljava/lang/Object;[Ljava/lang/Object;II)V", "[Ljava/lang/Object;", "getSize", "()I", "rootSize", "add", "element", "(Ljava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "pushFilledTail", "filledTail", "newTail", "([Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "pushTail", "shift", "([Ljava/lang/Object;I[Ljava/lang/Object;)[Ljava/lang/Object;", "index", "(ILjava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "insertIntoTail", "tailIndex", "([Ljava/lang/Object;ILjava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "insertIntoRoot", "elementCarry", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/ObjectRef;", "([Ljava/lang/Object;IILjava/lang/Object;Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "removeAt", "removeFromTailAt", "([Ljava/lang/Object;III)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "pullLastBufferFromRoot", "([Ljava/lang/Object;II)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "pullLastBuffer", "tailCarry", "([Ljava/lang/Object;IILandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "removeFromRootAt", "removeAll", "predicate", "Lkotlin/Function1;", "", "builder", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "listIterator", "", "bufferFor", "(I)[Ljava/lang/Object;", "get", "(I)Ljava/lang/Object;", "set", "setInRoot", "e", "([Ljava/lang/Object;IILjava/lang/Object;)[Ljava/lang/Object;", "runtime"})
public final class PersistentVector<E>
extends AbstractPersistentList<E>
implements PersistentList<E> {
    private final Object[] root;
    private final Object[] tail;
    private final int size;
    private final int rootShift;
    public static final int $stable = 8;

    public PersistentVector(Object[] objectArray, Object[] objectArray2, int n2, int n3) {
        this.root = objectArray;
        this.tail = objectArray2;
        this.size = n2;
        this.rootShift = n3;
        boolean bl = this.size() > 32;
        if (!bl) {
            PreconditionsKt.throwIllegalArgumentException("Trie-based persistent vector should have at least 33 elements, got " + this.size());
        }
        CommonFunctionsKt.assert(this.size() - UtilsKt.rootSize(this.size()) <= RangesKt.coerceAtMost((int)this.tail.length, (int)32));
    }

    public final int getSize() {
        return this.size;
    }

    private final int rootSize() {
        return UtilsKt.rootSize(this.size());
    }

    @Override
    public final PersistentList<E> add(E e) {
        int n2 = this.size() - this.rootSize();
        if (n2 < 32) {
            Object[] objectArray = Arrays.copyOf(this.tail, 32);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"");
            Object[] objectArray2 = objectArray;
            objectArray[n2] = e;
            return new PersistentVector<E>(this.root, objectArray2, this.size() + 1, this.rootShift);
        }
        Object[] objectArray = UtilsKt.presizedBufferWith(e);
        PersistentVector persistentVector = this;
        return persistentVector.pushFilledTail(persistentVector.root, this.tail, objectArray);
    }

    private final PersistentVector<E> pushFilledTail(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        if (this.size() >> 5 > 1 << this.rootShift) {
            objectArray = UtilsKt.presizedBufferWith(objectArray);
            int n2 = this.rootShift + 5;
            objectArray = this.pushTail(objectArray, n2, objectArray2);
            return new PersistentVector<E>(objectArray, objectArray3, this.size() + 1, n2);
        }
        objectArray = this.pushTail(objectArray, this.rootShift, objectArray2);
        return new PersistentVector<E>(objectArray, objectArray3, this.size() + 1, this.rootShift);
    }

    private final Object[] pushTail(Object[] objectArray, int n2, Object[] objectArray2) {
        Object[] objectArray3;
        int n3;
        block3: {
            block2: {
                n3 = UtilsKt.indexSegment(this.size() - 1, n2);
                objectArray3 = objectArray;
                if (objectArray == null) break block2;
                Object[] objectArray4 = Arrays.copyOf(objectArray3, 32);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray4, (String)"");
                objectArray3 = objectArray4;
                if (objectArray4 != null) break block3;
            }
            objectArray3 = new Object[32];
        }
        objectArray = objectArray3;
        objectArray[n3] = n2 == 5 ? objectArray2 : this.pushTail((Object[])objectArray[n3], n2 - 5, objectArray2);
        return objectArray;
    }

    @Override
    public final PersistentList<E> add(int n2, E e) {
        ListImplementation.checkPositionIndex$runtime(n2, this.size());
        if (n2 == this.size()) {
            return this.add((Object)e);
        }
        int n3 = this.rootSize();
        if (n2 >= n3) {
            PersistentVector persistentVector = this;
            return persistentVector.insertIntoTail(persistentVector.root, n2 - n3, e);
        }
        ObjectRef objectRef = new ObjectRef(null);
        PersistentVector persistentVector = this;
        Object[] objectArray = persistentVector.insertIntoRoot(persistentVector.root, this.rootShift, n2, e, objectRef);
        return this.insertIntoTail(objectArray, 0, objectRef.getValue());
    }

    private final PersistentVector<E> insertIntoTail(Object[] objectArray, int n2, Object object) {
        int n3 = this.size() - this.rootSize();
        Object[] objectArray2 = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"");
        Object[] objectArray3 = objectArray2;
        if (n3 < 32) {
            ArraysKt.copyInto((Object[])this.tail, (Object[])objectArray3, (int)(n2 + 1), (int)n2, (int)n3);
            objectArray3[n2] = object;
            return new PersistentVector<E>(objectArray, objectArray3, this.size() + 1, this.rootShift);
        }
        Object object2 = this.tail[31];
        ArraysKt.copyInto((Object[])this.tail, (Object[])objectArray3, (int)(n2 + 1), (int)n2, (int)(n3 - 1));
        objectArray3[n2] = object;
        return this.pushFilledTail(objectArray, objectArray3, UtilsKt.presizedBufferWith(object2));
    }

    private final Object[] insertIntoRoot(Object[] objectArray, int n2, int n3, Object object, ObjectRef objectRef) {
        int n4 = UtilsKt.indexSegment(n3, n2);
        if (n2 == 0) {
            Object[] objectArray2;
            if (n4 == 0) {
                objectArray2 = new Object[32];
            } else {
                Object[] objectArray3 = Arrays.copyOf(objectArray, 32);
                objectArray2 = objectArray3;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"");
            }
            Object[] objectArray4 = objectArray2;
            ArraysKt.copyInto((Object[])objectArray, (Object[])objectArray4, (int)(n4 + 1), (int)n4, (int)31);
            objectRef.setValue(objectArray[31]);
            objectArray4[n4] = object;
            return objectArray4;
        }
        Object[] objectArray5 = Arrays.copyOf(objectArray, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray5, (String)"");
        Object[] objectArray6 = objectArray5;
        Object object2 = objectArray[n4];
        Intrinsics.checkNotNull((Object)object2);
        objectArray6[n4] = this.insertIntoRoot((Object[])object2, n2 -= 5, n3, object, objectRef);
        for (n3 = n4 + 1; n3 < 32 && objectArray6[n3] != null; ++n3) {
            Object object3 = objectArray[n3];
            Intrinsics.checkNotNull((Object)object3);
            objectArray6[n3] = this.insertIntoRoot((Object[])object3, n2, 0, objectRef.getValue(), objectRef);
        }
        return objectArray6;
    }

    @Override
    public final PersistentList<E> removeAt(int n2) {
        ListImplementation.checkElementIndex$runtime(n2, this.size());
        int n3 = this.rootSize();
        if (n2 >= n3) {
            PersistentVector persistentVector = this;
            return persistentVector.removeFromTailAt(persistentVector.root, n3, this.rootShift, n2 - n3);
        }
        PersistentVector persistentVector = this;
        Object[] objectArray = persistentVector.removeFromRootAt(persistentVector.root, this.rootShift, n2, new ObjectRef(this.tail[0]));
        return this.removeFromTailAt(objectArray, n3, this.rootShift, 0);
    }

    private final PersistentList<E> removeFromTailAt(Object[] objectArray, int n2, int n3, int n4) {
        int n5 = this.size() - n2;
        CommonFunctionsKt.assert(n4 < n5);
        if (n5 == 1) {
            return this.pullLastBufferFromRoot(objectArray, n2, n3);
        }
        Object[] objectArray2 = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"");
        Object[] objectArray3 = objectArray2;
        if (n4 < n5 - 1) {
            int n6 = n4;
            ArraysKt.copyInto((Object[])this.tail, (Object[])objectArray3, (int)n6, (int)(n6 + 1), (int)n5);
        }
        objectArray3[n5 - 1] = null;
        return new PersistentVector<E>(objectArray, objectArray3, n2 + n5 - 1, n3);
    }

    private final PersistentList<E> pullLastBufferFromRoot(Object[] objectArray, int n2, int n3) {
        if (n3 == 0) {
            Object[] objectArray2;
            if (objectArray.length == 33) {
                Object[] objectArray3 = Arrays.copyOf(objectArray, 32);
                objectArray2 = objectArray3;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"");
            } else {
                objectArray2 = objectArray;
            }
            Object[] objectArray4 = objectArray2;
            return new SmallPersistentVector(objectArray4);
        }
        Object[] objectArray5 = new ObjectRef(null);
        Object[] objectArray6 = this.pullLastBuffer(objectArray, n3, n2 - 1, (ObjectRef)objectArray5);
        Intrinsics.checkNotNull((Object)objectArray6);
        objectArray = objectArray6;
        Object object = objectArray5.getValue();
        Intrinsics.checkNotNull((Object)object);
        objectArray5 = (Object[])object;
        if (objectArray[1] == null) {
            Object object2 = objectArray[0];
            Intrinsics.checkNotNull((Object)object2);
            objectArray = (Object[])object2;
            return new PersistentVector<E>(objectArray, objectArray5, n2, n3 - 5);
        }
        return new PersistentVector<E>(objectArray, objectArray5, n2, n3);
    }

    private final Object[] pullLastBuffer(Object[] objectArray, int n2, int n3, ObjectRef objectRef) {
        Object[] objectArray2;
        Object[] objectArray3;
        int n4 = UtilsKt.indexSegment(n3, n2);
        if (n2 == 5) {
            objectRef.setValue(objectArray[n4]);
            objectArray3 = null;
        } else {
            Object object = objectArray[n4];
            Intrinsics.checkNotNull((Object)object);
            objectArray3 = objectArray2 = this.pullLastBuffer((Object[])object, n2 - 5, n3, objectRef);
        }
        if (objectArray3 == null && n4 == 0) {
            return null;
        }
        Object[] objectArray4 = Arrays.copyOf(objectArray, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray4, (String)"");
        objectArray = objectArray4;
        objectArray4[n4] = objectArray2;
        return objectArray;
    }

    private final Object[] removeFromRootAt(Object[] objectArray, int n2, int n3, ObjectRef objectRef) {
        int n4 = UtilsKt.indexSegment(n3, n2);
        if (n2 == 0) {
            Object[] objectArray2;
            if (n4 == 0) {
                objectArray2 = new Object[32];
            } else {
                Object[] objectArray3 = Arrays.copyOf(objectArray, 32);
                objectArray2 = objectArray3;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"");
            }
            Object[] objectArray4 = objectArray2;
            int n5 = n4;
            ArraysKt.copyInto((Object[])objectArray, (Object[])objectArray4, (int)n5, (int)(n5 + 1), (int)32);
            objectArray4[31] = objectRef.getValue();
            objectRef.setValue(objectArray[n4]);
            return objectArray4;
        }
        int n6 = 31;
        if (objectArray[31] == null) {
            n6 = UtilsKt.indexSegment(this.rootSize() - 1, n2);
        }
        Object[] objectArray5 = Arrays.copyOf(objectArray, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray5, (String)"");
        objectArray = objectArray5;
        n2 -= 5;
        int n7 = n4 + 1;
        if (n7 <= n6) {
            while (true) {
                Object object = objectArray[n6];
                Intrinsics.checkNotNull((Object)object);
                objectArray[n6] = this.removeFromRootAt((Object[])object, n2, 0, objectRef);
                if (n6 == n7) break;
                --n6;
            }
        }
        Object object = objectArray[n4];
        Intrinsics.checkNotNull((Object)object);
        objectArray[n4] = this.removeFromRootAt((Object[])object, n2, n3, objectRef);
        return objectArray;
    }

    @Override
    public final PersistentList<E> removeAll(Function1<? super E, Boolean> function1) {
        PersistentList.Builder builder;
        PersistentList.Builder builder2 = builder = this.builder();
        ((PersistentVectorBuilder)builder).removeAllWithPredicate(function1);
        return ((PersistentVectorBuilder)builder).build();
    }

    @Override
    public final PersistentVectorBuilder<E> builder() {
        return new PersistentVectorBuilder(this, this.root, this.tail, this.rootShift);
    }

    @Override
    public final ListIterator<E> listIterator(int n2) {
        ListImplementation.checkPositionIndex$runtime(n2, this.size());
        return new PersistentVectorIterator<Object>(this.root, this.tail, n2, this.size(), this.rootShift / 5 + 1);
    }

    private final Object[] bufferFor(int n2) {
        if (this.rootSize() <= n2) {
            return this.tail;
        }
        Object[] objectArray = this.root;
        for (int i2 = this.rootShift; i2 > 0; i2 -= 5) {
            Object object = objectArray[UtilsKt.indexSegment(n2, i2)];
            Intrinsics.checkNotNull((Object)object);
            objectArray = (Object[])object;
        }
        return objectArray;
    }

    @Override
    public final E get(int n2) {
        ListImplementation.checkElementIndex$runtime(n2, this.size());
        Object[] objectArray = this.bufferFor(n2);
        return (E)objectArray[n2 & 0x1F];
    }

    @Override
    public final PersistentList<E> set(int n2, E e) {
        ListImplementation.checkElementIndex$runtime(n2, this.size());
        if (this.rootSize() <= n2) {
            Object[] objectArray = Arrays.copyOf(this.tail, 32);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"");
            Object[] objectArray2 = objectArray;
            objectArray[n2 & 0x1F] = e;
            return new PersistentVector<E>(this.root, objectArray2, this.size(), this.rootShift);
        }
        PersistentVector persistentVector = this;
        Object[] objectArray = persistentVector.setInRoot(persistentVector.root, this.rootShift, n2, e);
        return new PersistentVector<E>(objectArray, this.tail, this.size(), this.rootShift);
    }

    private final Object[] setInRoot(Object[] objectArray, int n2, int n3, Object object) {
        int n4 = UtilsKt.indexSegment(n3, n2);
        Object[] objectArray2 = Arrays.copyOf(objectArray, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"");
        objectArray = objectArray2;
        if (n2 == 0) {
            objectArray[n4] = object;
        } else {
            Object object2 = objectArray[n4];
            Intrinsics.checkNotNull((Object)object2);
            objectArray[n4] = this.setInRoot((Object[])object2, n2 - 5, n3, object);
        }
        return objectArray;
    }
}

