/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpmcAtomicArrayQueueL3Pad;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MpmcAtomicArrayQueue<E>
extends MpmcAtomicArrayQueueL3Pad<E> {
    public static final int MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.mpmc.max.lookahead.step", 4096);
    private final int lookAheadStep = Math.max(2, Math.min(this.capacity() / 4, MAX_LOOK_AHEAD_STEP));

    public MpmcAtomicArrayQueue(int n) {
        super(RangeUtil.checkGreaterThanOrEqual(n, 2, "capacity"));
    }

    @Override
    public boolean offer(E e) {
        long l;
        int n;
        if (e == null) {
            throw new NullPointerException();
        }
        int n2 = this.mask;
        long l2 = n2 + 1;
        AtomicLongArray atomicLongArray = this.sequenceBuffer;
        long l3 = Long.MIN_VALUE;
        while (true) {
            long l4;
            if ((l4 = AtomicQueueUtil.lvLongElement(atomicLongArray, n = AtomicQueueUtil.calcCircularLongElementOffset(l = this.lvProducerIndex(), n2))) < l) {
                if (l - l2 >= l3 && l - l2 >= (l3 = this.lvConsumerIndex())) {
                    return false;
                }
                l4 = l + 1L;
            }
            if (l4 > l) continue;
            long l5 = l;
            if (this.casProducerIndex(l5, l5 + 1L)) break;
        }
        AtomicQueueUtil.spRefElement(this.buffer, AtomicQueueUtil.calcCircularRefElementOffset(l, n2), e);
        AtomicQueueUtil.soLongElement(atomicLongArray, n, l + 1L);
        return true;
    }

    @Override
    public E poll() {
        long l;
        int n;
        AtomicLongArray atomicLongArray = this.sequenceBuffer;
        int n2 = this.mask;
        long l2 = -1L;
        while (true) {
            long l3;
            long l4;
            if ((l4 = AtomicQueueUtil.lvLongElement(atomicLongArray, n = AtomicQueueUtil.calcCircularLongElementOffset(l = this.lvConsumerIndex(), n2))) < (l3 = l + 1L)) {
                if (l >= l2 && l == (l2 = this.lvProducerIndex())) {
                    return null;
                }
                l4 = l3 + 1L;
            }
            if (l4 > l3) continue;
            long l5 = l;
            if (this.casConsumerIndex(l5, l5 + 1L)) break;
        }
        int n3 = AtomicQueueUtil.calcCircularRefElementOffset(l, n2);
        Object e = AtomicQueueUtil.lpRefElement(this.buffer, n3);
        AtomicQueueUtil.spRefElement(this.buffer, n3, null);
        AtomicQueueUtil.soLongElement(atomicLongArray, n, l + (long)n2 + 1L);
        return e;
    }

    @Override
    public E peek() {
        Object e;
        AtomicLongArray atomicLongArray = this.sequenceBuffer;
        int n = this.mask;
        long l = -1L;
        while (true) {
            long l2;
            long l3;
            int n2;
            long l4;
            if ((l4 = AtomicQueueUtil.lvLongElement(atomicLongArray, n2 = AtomicQueueUtil.calcCircularLongElementOffset(l3 = this.lvConsumerIndex(), n))) < (l2 = l3 + 1L)) {
                if (l3 < l || l3 != (l = this.lvProducerIndex())) continue;
                return null;
            }
            if (l4 != l2) continue;
            int n3 = AtomicQueueUtil.calcCircularRefElementOffset(l3, n);
            e = AtomicQueueUtil.lvRefElement(this.buffer, n3);
            if (this.lvConsumerIndex() == l3) break;
        }
        return e;
    }

    @Override
    public boolean relaxedOffer(E e) {
        long l;
        int n;
        if (e == null) {
            throw new NullPointerException();
        }
        int n2 = this.mask;
        AtomicLongArray atomicLongArray = this.sequenceBuffer;
        while (true) {
            long l2;
            if ((l2 = AtomicQueueUtil.lvLongElement(atomicLongArray, n = AtomicQueueUtil.calcCircularLongElementOffset(l = this.lvProducerIndex(), n2))) < l) {
                return false;
            }
            if (l2 > l) continue;
            long l3 = l;
            if (this.casProducerIndex(l3, l3 + 1L)) break;
        }
        AtomicQueueUtil.spRefElement(this.buffer, AtomicQueueUtil.calcCircularRefElementOffset(l, n2), e);
        AtomicQueueUtil.soLongElement(atomicLongArray, n, l + 1L);
        return true;
    }

    @Override
    public E relaxedPoll() {
        int n;
        long l;
        long l2;
        long l3;
        AtomicLongArray atomicLongArray = this.sequenceBuffer;
        int n2 = this.mask;
        do {
            if ((l3 = AtomicQueueUtil.lvLongElement(atomicLongArray, n = AtomicQueueUtil.calcCircularLongElementOffset(l = this.lvConsumerIndex(), n2))) >= (l2 = l + 1L)) continue;
            return null;
        } while (l3 > l2 || !this.casConsumerIndex(l, l2));
        int n3 = AtomicQueueUtil.calcCircularRefElementOffset(l, n2);
        Object e = AtomicQueueUtil.lpRefElement(this.buffer, n3);
        AtomicQueueUtil.spRefElement(this.buffer, n3, null);
        AtomicQueueUtil.soLongElement(atomicLongArray, n, l + (long)n2 + 1L);
        return e;
    }

    @Override
    public E relaxedPeek() {
        Object e;
        AtomicLongArray atomicLongArray = this.sequenceBuffer;
        int n = this.mask;
        while (true) {
            long l;
            long l2;
            int n2;
            long l3;
            if ((l3 = AtomicQueueUtil.lvLongElement(atomicLongArray, n2 = AtomicQueueUtil.calcCircularLongElementOffset(l2 = this.lvConsumerIndex(), n))) < (l = l2 + 1L)) {
                return null;
            }
            if (l3 != l) continue;
            int n3 = AtomicQueueUtil.calcCircularRefElementOffset(l2, n);
            e = AtomicQueueUtil.lvRefElement(this.buffer, n3);
            if (this.lvConsumerIndex() == l2) break;
        }
        return e;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        int n2;
        if (consumer == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative: " + n);
        }
        if (n == 0) {
            return 0;
        }
        AtomicLongArray atomicLongArray = this.sequenceBuffer;
        int n3 = this.mask;
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        int n4 = Math.min(this.lookAheadStep, n);
        for (int i = 0; i < n; i += n2) {
            long l;
            int n5 = n - i;
            n2 = Math.min(n5, n4);
            long l2 = this.lvConsumerIndex();
            long l3 = l2 + (long)n2 - 1L;
            int n6 = AtomicQueueUtil.calcCircularLongElementOffset(l3, n3);
            long l4 = AtomicQueueUtil.lvLongElement(atomicLongArray, n6);
            if (l4 == (l = l3 + 1L) && this.casConsumerIndex(l2, l)) {
                for (n5 = 0; n5 < n2; ++n5) {
                    long l5 = l2 + (long)n5;
                    int n7 = AtomicQueueUtil.calcCircularLongElementOffset(l5, n3);
                    int n8 = AtomicQueueUtil.calcCircularRefElementOffset(l5, n3);
                    long l6 = l5 + 1L;
                    while (AtomicQueueUtil.lvLongElement(atomicLongArray, n7) != l6) {
                    }
                    Object e = AtomicQueueUtil.lpRefElement(atomicReferenceArray, n8);
                    AtomicQueueUtil.spRefElement(atomicReferenceArray, n8, null);
                    AtomicQueueUtil.soLongElement(atomicLongArray, n7, l5 + (long)n3 + 1L);
                    consumer.accept(e);
                }
                continue;
            }
            if (l4 < l && this.notAvailable(l2, n3, atomicLongArray, l2 + 1L)) {
                return i;
            }
            return i + this.drainOneByOne(consumer, n5);
        }
        return n;
    }

    private int drainOneByOne(MessagePassingQueue.Consumer<E> consumer, int n) {
        AtomicLongArray atomicLongArray = this.sequenceBuffer;
        int n2 = this.mask;
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        for (int i = 0; i < n; ++i) {
            long l;
            int n3;
            while (true) {
                long l2;
                long l3;
                if ((l3 = AtomicQueueUtil.lvLongElement(atomicLongArray, n3 = AtomicQueueUtil.calcCircularLongElementOffset(l = this.lvConsumerIndex(), n2))) < (l2 = l + 1L)) {
                    return i;
                }
                if (l3 > l2) continue;
                long l4 = l;
                if (this.casConsumerIndex(l4, l4 + 1L)) break;
            }
            int n4 = AtomicQueueUtil.calcCircularRefElementOffset(l, n2);
            Object e = AtomicQueueUtil.lpRefElement(atomicReferenceArray, n4);
            AtomicQueueUtil.spRefElement(atomicReferenceArray, n4, null);
            AtomicQueueUtil.soLongElement(atomicLongArray, n3, l + (long)n2 + 1L);
            consumer.accept(e);
        }
        return n;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n) {
        int n2;
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative:" + n);
        }
        if (n == 0) {
            return 0;
        }
        AtomicLongArray atomicLongArray = this.sequenceBuffer;
        int n3 = this.mask;
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        int n4 = Math.min(this.lookAheadStep, n);
        for (int i = 0; i < n; i += n2) {
            long l;
            int n5 = n - i;
            n2 = Math.min(n5, n4);
            long l2 = this.lvProducerIndex();
            long l3 = l2 + (long)n2 - 1L;
            int n6 = AtomicQueueUtil.calcCircularLongElementOffset(l3, n3);
            long l4 = AtomicQueueUtil.lvLongElement(atomicLongArray, n6);
            if (l4 == (l = l3) && this.casProducerIndex(l2, l + 1L)) {
                for (n5 = 0; n5 < n2; ++n5) {
                    long l5 = l2 + (long)n5;
                    int n7 = AtomicQueueUtil.calcCircularLongElementOffset(l5, n3);
                    int n8 = AtomicQueueUtil.calcCircularRefElementOffset(l5, n3);
                    while (AtomicQueueUtil.lvLongElement(atomicLongArray, n7) != l5) {
                    }
                    AtomicQueueUtil.soRefElement(atomicReferenceArray, n8, supplier.get());
                    AtomicQueueUtil.soLongElement(atomicLongArray, n7, l5 + 1L);
                }
                continue;
            }
            if (l4 < l && this.notAvailable(l2, n3, atomicLongArray, l2)) {
                return i;
            }
            return i + this.fillOneByOne(supplier, n5);
        }
        return n;
    }

    private boolean notAvailable(long l, int n, AtomicLongArray atomicLongArray, long l2) {
        int n2 = AtomicQueueUtil.calcCircularLongElementOffset(l, n);
        long l3 = AtomicQueueUtil.lvLongElement(atomicLongArray, n2);
        return l3 < l2;
    }

    private int fillOneByOne(MessagePassingQueue.Supplier<E> supplier, int n) {
        AtomicLongArray atomicLongArray = this.sequenceBuffer;
        int n2 = this.mask;
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        for (int i = 0; i < n; ++i) {
            long l;
            int n3;
            while (true) {
                long l2;
                if ((l2 = AtomicQueueUtil.lvLongElement(atomicLongArray, n3 = AtomicQueueUtil.calcCircularLongElementOffset(l = this.lvProducerIndex(), n2))) < l) {
                    return i;
                }
                if (l2 > l) continue;
                long l3 = l;
                if (this.casProducerIndex(l3, l3 + 1L)) break;
            }
            AtomicQueueUtil.soRefElement(atomicReferenceArray, AtomicQueueUtil.calcCircularRefElementOffset(l, n2), supplier.get());
            AtomicQueueUtil.soLongElement(atomicLongArray, n3, l + 1L);
        }
        return n;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return MessagePassingQueueUtil.drain(this, consumer);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillBounded(this, supplier);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }
}

