/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.EnumDescriptor;
import kotlinx.serialization.internal.PluginGeneratedSerialDescriptor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tB'\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0005H\u0016R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lkotlinx/serialization/internal/EnumSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "serialName", "", "values", "", "<init>", "(Ljava/lang/String;[Ljava/lang/Enum;)V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Ljava/lang/String;[Ljava/lang/Enum;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "[Ljava/lang/Enum;", "overriddenDescriptor", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor$delegate", "Lkotlin/Lazy;", "createUnmarkedDescriptor", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Enum;)V", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Enum;", "toString", "kotlinx-serialization-core"})
public final class EnumSerializer<T extends Enum<T>>
implements KSerializer<T> {
    private final T[] values;
    private SerialDescriptor overriddenDescriptor;
    private final Lazy descriptor$delegate;

    public EnumSerializer(String string, T[] TArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        this.values = TArray;
        this.descriptor$delegate = LazyKt.lazy(() -> EnumSerializer.descriptor_delegate$lambda$0(this, string));
    }

    public EnumSerializer(String string, T[] TArray, SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        this(string, (Enum[])TArray);
        this.overriddenDescriptor = serialDescriptor;
    }

    @Override
    public final SerialDescriptor getDescriptor() {
        Lazy lazy = this.descriptor$delegate;
        return (SerialDescriptor)lazy.getValue();
    }

    private final SerialDescriptor createUnmarkedDescriptor(String object) {
        object = new EnumDescriptor((String)object, this.values.length);
        for (T t : this.values) {
            PluginGeneratedSerialDescriptor.addElement$default((PluginGeneratedSerialDescriptor)object, ((Enum)t).name(), false, 2, null);
        }
        return (SerialDescriptor)object;
    }

    @Override
    public final void serialize(Encoder encoder, T t) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        int n = ArraysKt.indexOf((Object[])this.values, t);
        if (n == -1) {
            StringBuilder stringBuilder = new StringBuilder().append(t).append(" is not a valid enum ").append(this.getDescriptor().getSerialName()).append(", must be one of ");
            String string = Arrays.toString(this.values);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            throw new SerializationException(stringBuilder.append(string).toString());
        }
        encoder.encodeEnum(this.getDescriptor(), n);
    }

    @Override
    public final T deserialize(Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"");
        int n = decoder.decodeEnum(this.getDescriptor());
        if (!(n >= 0 ? n < this.values.length : false)) {
            throw new SerializationException(n + " is not among valid " + this.getDescriptor().getSerialName() + " enum values, values size is " + this.values.length);
        }
        return this.values[n];
    }

    public final String toString() {
        return "kotlinx.serialization.internal.EnumSerializer<" + this.getDescriptor().getSerialName() + '>';
    }

    private static final SerialDescriptor descriptor_delegate$lambda$0(EnumSerializer enumSerializer, String string) {
        SerialDescriptor serialDescriptor = enumSerializer.overriddenDescriptor;
        if (serialDescriptor == null) {
            serialDescriptor = enumSerializer.createUnmarkedDescriptor(string);
        }
        return serialDescriptor;
    }
}

