/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.PlatformKt;
import kotlinx.serialization.internal.PrimitiveSerialDescriptor;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\f\u001a\u00020\u0007*\u00020\u0007H\u0002\u001a$\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u0003\"\b\b\u0000\u0010\u000e*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u000e0\u0002H\u0000\"\"\u0010\u0000\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"BUILTIN_SERIALIZERS", "", "Lkotlin/reflect/KClass;", "Lkotlinx/serialization/KSerializer;", "PrimitiveDescriptorSafe", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialName", "", "kind", "Lkotlinx/serialization/descriptors/PrimitiveKind;", "checkNameIsNotAPrimitive", "", "capitalize", "builtinSerializerOrNull", "T", "", "kotlinx-serialization-core"})
public final class PrimitivesKt {
    private static final Map<KClass<?>, KSerializer<?>> BUILTIN_SERIALIZERS = PlatformKt.initBuiltins();

    public static final SerialDescriptor PrimitiveDescriptorSafe(String string, PrimitiveKind primitiveKind) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)primitiveKind, (String)"");
        PrimitivesKt.checkNameIsNotAPrimitive(string);
        return new PrimitiveSerialDescriptor(string, primitiveKind);
    }

    public static final void checkNameIsNotAPrimitive(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Object object = BUILTIN_SERIALIZERS.values();
        object = object.iterator();
        while (object.hasNext()) {
            KSerializer kSerializer = (KSerializer)object.next();
            String string2 = kSerializer.getDescriptor().getSerialName();
            if (!Intrinsics.areEqual((Object)string, (Object)string2)) continue;
            throw new IllegalArgumentException(StringsKt.trimIndent((String)("\n                The name of serial descriptor should uniquely identify associated serializer.\n                For serial name " + string + " there already exists " + Reflection.getOrCreateKotlinClass(kSerializer.getClass()).getSimpleName() + ".\n                Please refer to SerialDescriptor documentation for additional information.\n            ")));
        }
    }

    private static final String capitalize(String string) {
        if (((CharSequence)string).length() > 0) {
            char c = string.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = stringBuilder.append((Object)(Character.isLowerCase(c) ? CharsKt.titlecase((char)c) : String.valueOf(c)));
            String string2 = string;
            String string3 = string2.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            return stringBuilder2.append(string3).toString();
        }
        return string;
    }

    public static final <T> KSerializer<T> builtinSerializerOrNull(KClass<T> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"");
        return BUILTIN_SERIALIZERS.get(kClass);
    }
}

