/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.pool;

import io.ktor.utils.io.pool.ObjectPool;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00028\u00002\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\r\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0011\u0010\tJ\u0015\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0012\u0010\u000fJ\r\u0010\u0013\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0011\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b\u0018\u0010\tJ\u0017\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0007J\u000f\u0010\u001b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001dR\u001c\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lio/ktor/utils/io/pool/DefaultPool;", "", "T", "Lio/ktor/utils/io/pool/ObjectPool;", "", "capacity", "<init>", "(I)V", "produceInstance", "()Ljava/lang/Object;", "instance", "clearInstance", "(Ljava/lang/Object;)Ljava/lang/Object;", "", "validateInstance", "(Ljava/lang/Object;)V", "disposeInstance", "borrow", "recycle", "dispose", "()V", "", "tryPush", "(Ljava/lang/Object;)Z", "tryPop", "index", "pushTop", "popTop", "()I", "I", "getCapacity", "maxIndex", "shift", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "instances", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "", "next", "[I", "ktor-io"})
public abstract class DefaultPool<T>
implements ObjectPool<T> {
    private final int capacity;
    private volatile /* synthetic */ long top;
    private static final /* synthetic */ AtomicLongFieldUpdater top$FU;
    private final int maxIndex;
    private final int shift;
    private final AtomicReferenceArray<T> instances;
    private final int[] next;

    public DefaultPool(int n) {
        this.capacity = n;
        if (!(this.capacity > 0)) {
            String string = "capacity should be positive but it is " + this.capacity;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.capacity <= 0x1FFFFFFF)) {
            String string = "capacity should be less or equal to 536870911 but it is " + this.capacity;
            throw new IllegalArgumentException(string.toString());
        }
        this.top = 0L;
        this.maxIndex = Integer.highestOneBit((this.capacity << 2) - 1) << 1;
        this.shift = Integer.numberOfLeadingZeros(this.maxIndex) + 1;
        this.instances = new AtomicReferenceArray(this.maxIndex + 1);
        this.next = new int[this.maxIndex + 1];
    }

    @Override
    public final int getCapacity() {
        return this.capacity;
    }

    protected abstract T produceInstance();

    protected T clearInstance(T t2) {
        Intrinsics.checkNotNullParameter(t2, (String)"");
        return t2;
    }

    protected void validateInstance(T t2) {
        Intrinsics.checkNotNullParameter(t2, (String)"");
    }

    protected void disposeInstance(T t2) {
        Intrinsics.checkNotNullParameter(t2, (String)"");
    }

    @Override
    public final T borrow() {
        T t2;
        T t3 = this.tryPop();
        if (t3 == null || (t3 = this.clearInstance(t2 = t3)) == null) {
            t3 = this.produceInstance();
        }
        return t3;
    }

    @Override
    public final void recycle(T t2) {
        Intrinsics.checkNotNullParameter(t2, (String)"");
        this.validateInstance(t2);
        if (!this.tryPush(t2)) {
            this.disposeInstance(t2);
        }
    }

    @Override
    public final void dispose() {
        while (this.tryPop() != null) {
            T t2;
            this.disposeInstance(t2);
        }
        return;
    }

    private final boolean tryPush(T t2) {
        int n = (System.identityHashCode(t2) * -1640531527 >>> this.shift) + 1;
        for (int i2 = 0; i2 < 8; ++i2) {
            if (this.instances.compareAndSet(n, null, t2)) {
                this.pushTop(n);
                return true;
            }
            if ((n += -1) != 0) continue;
            n = this.maxIndex;
        }
        return false;
    }

    private final T tryPop() {
        int n = this.popTop();
        if (n == 0) {
            return null;
        }
        return this.instances.getAndSet(n, null);
    }

    private final void pushTop(int n) {
        long l;
        long l2;
        if (!(n > 0)) {
            String string = "index should be positive";
            throw new IllegalArgumentException(string.toString());
        }
        do {
            l2 = this.top;
            long l3 = (l2 >> 32 & 0xFFFFFFFFL) + 1L;
            int n2 = (int)l2;
            l = l3 << 32 | (long)n;
            this.next[n] = n2;
        } while (!top$FU.compareAndSet(this, l2, l));
    }

    private final int popTop() {
        int n;
        int n2;
        long l;
        long l2;
        long l3;
        do {
            if ((l3 = this.top) == 0L) {
                return 0;
            }
            l = (l3 >> 32 & 0xFFFFFFFFL) + 1L;
            n = (int)l3;
            if (n != 0) continue;
            return 0;
        } while (!top$FU.compareAndSet(this, l3, l2 = l << 32 | (long)(n2 = this.next[n])));
        return n;
    }

    @Override
    public void close() {
        ObjectPool.DefaultImpls.close(this);
    }

    static {
        top$FU = AtomicLongFieldUpdater.newUpdater(DefaultPool.class, "top");
    }
}

