/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp.rce;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.h.b.a;
import org.h.d.d;
import org.h.d.e;
import org.h.e.b;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.tcp.rce.IpTcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.tcp.rce.SrvXmppRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;

public class RemoteXmppTcpConnectionEndpoints {
    private static final Logger LOGGER = Logger.getLogger(RemoteXmppTcpConnectionEndpoints.class.getName());
    public static final String XMPP_CLIENT_DNS_SRV_PREFIX = "_xmpp-client._tcp";
    public static final String XMPP_SERVER_DNS_SRV_PREFIX = "_xmpp-server._tcp";

    public static Result<Rfc6120TcpRemoteConnectionEndpoint> lookup(ConnectionConfiguration connectionConfiguration) {
        List<RemoteConnectionEndpointLookupFailure> list;
        List<Rfc6120TcpRemoteConnectionEndpoint> list2 = connectionConfiguration.getHostAddress();
        a a2 = connectionConfiguration.getHost();
        if (list2 != null) {
            list = Collections.emptyList();
            IpTcpRemoteConnectionEndpoint<d<?>> ipTcpRemoteConnectionEndpoint = IpTcpRemoteConnectionEndpoint.from(((InetAddress)((Object)list2)).toString(), connectionConfiguration.getPort(), (InetAddress)((Object)list2));
            list2 = Collections.singletonList(ipTcpRemoteConnectionEndpoint);
        } else if (a2 != null) {
            list = new ArrayList(1);
            Object object = DNSUtil.getDNSResolver().lookupHostAddress(a2, list, connectionConfiguration.getDnssecMode());
            if (object != null) {
                list2 = new ArrayList<Rfc6120TcpRemoteConnectionEndpoint>(object.size());
                connectionConfiguration = connectionConfiguration.getPort();
                object = object.iterator();
                while (object.hasNext()) {
                    Object object2 = (InetAddress)object.next();
                    object2 = IpTcpRemoteConnectionEndpoint.from((CharSequence)a2, (UInt16)connectionConfiguration, (InetAddress)object2);
                    list2.add((Rfc6120TcpRemoteConnectionEndpoint)object2);
                }
            } else {
                list2 = Collections.emptyList();
            }
        } else {
            list = new ArrayList();
            a a3 = connectionConfiguration.getXmppServiceDomainAsDnsNameIfPossible();
            if (a3 == null) {
                throw new IllegalStateException();
            }
            list2 = RemoteXmppTcpConnectionEndpoints.resolveXmppServiceDomain(a3, list, connectionConfiguration.getDnssecMode());
        }
        assert (!list2.isEmpty() || !list.isEmpty());
        return new Result<Rfc6120TcpRemoteConnectionEndpoint>(list2, list);
    }

    public static List<Rfc6120TcpRemoteConnectionEndpoint> resolveXmppServiceDomain(a a2, List<RemoteConnectionEndpointLookupFailure> list, ConnectionConfiguration.DnssecMode dnssecMode) {
        DNSResolver dNSResolver = RemoteXmppTcpConnectionEndpoints.getDnsResolverOrThrow();
        return RemoteXmppTcpConnectionEndpoints.resolveDomain(a2, DomainType.client, list, dnssecMode, dNSResolver);
    }

    public static List<Rfc6120TcpRemoteConnectionEndpoint> resolveXmppServerDomain(a a2, List<RemoteConnectionEndpointLookupFailure> list, ConnectionConfiguration.DnssecMode dnssecMode) {
        DNSResolver dNSResolver = RemoteXmppTcpConnectionEndpoints.getDnsResolverOrThrow();
        return RemoteXmppTcpConnectionEndpoints.resolveDomain(a2, DomainType.server, list, dnssecMode, dNSResolver);
    }

    private static List<Rfc6120TcpRemoteConnectionEndpoint> resolveDomain(a a2, DomainType domainType, List<RemoteConnectionEndpointLookupFailure> list, ConnectionConfiguration.DnssecMode dnssecMode, DNSResolver dNSResolver) {
        Object object5;
        Object object2;
        ArrayList<Rfc6120TcpRemoteConnectionEndpoint> arrayList = new ArrayList<Rfc6120TcpRemoteConnectionEndpoint>();
        Object object3 = a.a((a)domainType.srvPrefix, (a)a2);
        Object object4 = dNSResolver.lookupSrvRecords(object3, list, dnssecMode);
        if (object4 != null && !object4.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                object3 = "Resolved SRV RR for " + object3 + ":";
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    object5 = (e)object2.next();
                    object3 = (String)object3 + " " + object5;
                }
                LOGGER.fine((String)object3);
            }
            object3 = b.a((Collection)object4);
            for (Object object5 : object3) {
                object4 = dNSResolver.lookupHostAddress(((e)object5).d, list, dnssecMode);
                if (object4 == null) continue;
                object4 = new SrvXmppRemoteConnectionEndpoint((e)object5, (List<? extends InetAddress>)object4);
                arrayList.add((Rfc6120TcpRemoteConnectionEndpoint)object4);
            }
        } else {
            LOGGER.info("Could not resolve DNS SRV resource records for " + object3 + ". Consider adding those.");
        }
        switch (domainType) {
            case client: {
                object3 = UInt16.from((int)5222);
                break;
            }
            case server: {
                object3 = UInt16.from((int)5269);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        object2 = dNSResolver.lookupHostAddress(a2, list, dnssecMode);
        if (object2 != null) {
            object5 = object2.iterator();
            while (object5.hasNext()) {
                object4 = (InetAddress)object5.next();
                object4 = IpTcpRemoteConnectionEndpoint.from((CharSequence)a2, (UInt16)object3, (InetAddress)object4);
                arrayList.add((Rfc6120TcpRemoteConnectionEndpoint)object4);
            }
        }
        return arrayList;
    }

    private static DNSResolver getDnsResolverOrThrow() {
        DNSResolver dNSResolver = DNSUtil.getDNSResolver();
        if (dNSResolver == null) {
            throw new IllegalStateException("No DNS resolver configured in Smack");
        }
        return dNSResolver;
    }

    static enum DomainType {
        server("_xmpp-server._tcp"),
        client("_xmpp-client._tcp");

        public final a srvPrefix;

        private DomainType(String string2) {
            this.srvPrefix = a.a((String)string2);
        }
    }

    public static final class Result<RCE extends RemoteConnectionEndpoint> {
        public final List<RCE> discoveredRemoteConnectionEndpoints;
        public final List<RemoteConnectionEndpointLookupFailure> lookupFailures;

        private Result(List<RCE> list, List<RemoteConnectionEndpointLookupFailure> list2) {
            this.discoveredRemoteConnectionEndpoints = list;
            this.lookupFailures = list2;
        }
    }
}

